/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.dao.BcmTChnipmpProjectMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryTChnipmpProjectPO;
import com.tydic.bcm.personal.po.BcmTChnipmpProjectPO;
import com.tydic.bcm.personal.task.api.BcmBasicProjectSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmBasicProjectSyncTaskReqBO;
import com.tydic.bcm.personal.task.bo.BcmBasicProjectSyncTaskRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmBasicProjectSyncTaskService"})
public class BcmBasicProjectSyncTaskServiceImpl
implements BcmBasicProjectSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmBasicProjectSyncTaskServiceImpl.class);
    @Autowired
    private BcmTChnipmpProjectMapper bcmTChnipmpProjectMapper;
    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncBasicProject"})
    public BcmBasicProjectSyncTaskRspBO syncBasicProject(@RequestBody BcmBasicProjectSyncTaskReqBO reqBO) {
        this.sync();
        return BcmRuUtil.success(BcmBasicProjectSyncTaskRspBO.class);
    }

    private void sync() {
        Page<BcmTChnipmpProjectPO> page = this.getChnipmpProject();
        List syncList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)syncList)) {
            return;
        }
        Map<String, BcmBasicProjectInfoPO> thanMap = this.getBasicProject(syncList);
        ArrayList<Long> successIdList = new ArrayList(syncList.size());
        if (CollectionUtils.isEmpty(thanMap)) {
            this.addBasicProject(syncList);
            successIdList = syncList.stream().map(BcmTChnipmpProjectPO::getId).collect(Collectors.toList());
        } else {
            ArrayList<BcmTChnipmpProjectPO> addList = new ArrayList<BcmTChnipmpProjectPO>(syncList.size());
            ArrayList<BcmBasicProjectInfoPO> updateList = new ArrayList<BcmBasicProjectInfoPO>(syncList.size());
            ArrayList<Long> skipIdList = new ArrayList<Long>(syncList.size());
            for (BcmTChnipmpProjectPO po : syncList) {
                BcmBasicProjectInfoPO basicProjectInfoPO = thanMap.get(po.getProjectNo());
                if (basicProjectInfoPO == null) {
                    addList.add(po);
                    successIdList.add(po.getId());
                    continue;
                }
                BcmBasicProjectInfoPO newInfoPO = this.setBcmBasicProject(po);
                newInfoPO.setId(basicProjectInfoPO.getId());
                if (!JSON.toJSONString((Object)newInfoPO).equals(JSON.toJSONString((Object)basicProjectInfoPO))) {
                    newInfoPO.setId(BcmIdUtil.nextId());
                    if (newInfoPO.getUpdateTime() == null) {
                        newInfoPO.setUpdateTime(new Date());
                    }
                    updateList.add(newInfoPO);
                    successIdList.add(po.getId());
                    continue;
                }
                skipIdList.add(po.getId());
            }
            if (!CollectionUtils.isEmpty(addList)) {
                this.addBasicProject(addList);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.bcmBasicProjectInfoMapper.updateBatch(updateList);
            }
            if (!CollectionUtils.isEmpty(skipIdList)) {
                this.updateChnipmpProject(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
            }
        }
        if (!CollectionUtils.isEmpty(successIdList)) {
            this.updateChnipmpProject(successIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (page.getTotalPages() > 1) {
            this.sync();
        }
    }

    private void updateChnipmpProject(List<Long> idList, String dealResult) {
        BcmQueryTChnipmpProjectPO bcmQueryTChnipmpProjectPO = new BcmQueryTChnipmpProjectPO();
        bcmQueryTChnipmpProjectPO.setIdList(idList);
        bcmQueryTChnipmpProjectPO.setDealResult(dealResult);
        bcmQueryTChnipmpProjectPO.setDealTime(new Date());
        this.bcmTChnipmpProjectMapper.updateBatch(bcmQueryTChnipmpProjectPO);
    }

    private void addBasicProject(List<BcmTChnipmpProjectPO> syncList) {
        ArrayList<BcmBasicProjectInfoPO> bcmBasicProjectInfoPOS = new ArrayList<BcmBasicProjectInfoPO>();
        for (BcmTChnipmpProjectPO po : syncList) {
            BcmBasicProjectInfoPO basicProjectInfoPO = this.setBcmBasicProject(po);
            basicProjectInfoPO.setId(BcmIdUtil.nextId());
            if (basicProjectInfoPO.getUpdateTime() == null) {
                basicProjectInfoPO.setUpdateTime(new Date());
            }
            bcmBasicProjectInfoPOS.add(basicProjectInfoPO);
        }
        this.bcmBasicProjectInfoMapper.insertBatch(bcmBasicProjectInfoPOS);
    }

    private BcmBasicProjectInfoPO setBcmBasicProject(BcmTChnipmpProjectPO po) {
        BcmBasicProjectInfoPO bcmBasicProjectInfoPO = BcmRuUtil.js(po, BcmBasicProjectInfoPO.class);
        this.setBasicProjectOrg(po, bcmBasicProjectInfoPO);
        bcmBasicProjectInfoPO.setProjectCode(po.getProjectNo());
        bcmBasicProjectInfoPO.setBudgetMoney(new BigDecimal(po.getProjectBudget()));
        bcmBasicProjectInfoPO.setProOrgName(this.getProOrgName(po));
        bcmBasicProjectInfoPO.setCreateTime(po.getCreateDate());
        bcmBasicProjectInfoPO.setCreateUserName(po.getExecuUserName());
        bcmBasicProjectInfoPO.setStatus(BcmPersonalCommonConstant.Status.ENABLE);
        bcmBasicProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        return bcmBasicProjectInfoPO;
    }

    private BcmBasicProjectInfoPO setBasicProjectOrg(BcmTChnipmpProjectPO po, BcmBasicProjectInfoPO bcmBasicProjectInfoPO) {
        bcmBasicProjectInfoPO.setOneInstitution(po.getOneInstitution());
        bcmBasicProjectInfoPO.setOneOrgName(po.getOneOrgName());
        bcmBasicProjectInfoPO.setStatus(BcmPersonalCommonConstant.Status.ENABLE);
        if (StringUtils.isNotBlank((String)po.getTwoInstitution())) {
            bcmBasicProjectInfoPO.setTwoInstitution(po.getTwoInstitution());
            bcmBasicProjectInfoPO.setTwoOrgName(po.getTwoOrgName());
            if (StringUtils.isNotBlank((String)po.getThreeInstitution())) {
                bcmBasicProjectInfoPO.setThreeInstitution(po.getThreeInstitution());
                bcmBasicProjectInfoPO.setThreeOrgName(po.getThreeOrgName());
                if (StringUtils.isNotBlank((String)po.getFourInstitution())) {
                    bcmBasicProjectInfoPO.setFourInstitution(po.getFourInstitution());
                    bcmBasicProjectInfoPO.setFourOrgName(po.getFourOrgName());
                } else {
                    bcmBasicProjectInfoPO.setFourInstitution(po.getThreeInstitution());
                    bcmBasicProjectInfoPO.setFourOrgName(po.getThreeOrgName());
                }
            } else {
                bcmBasicProjectInfoPO.setThreeInstitution(po.getTwoInstitution());
                bcmBasicProjectInfoPO.setThreeOrgName(po.getTwoOrgName());
                bcmBasicProjectInfoPO.setFourInstitution(po.getTwoInstitution());
                bcmBasicProjectInfoPO.setFourOrgName(po.getTwoOrgName());
            }
        } else {
            bcmBasicProjectInfoPO.setTwoInstitution(po.getOneInstitution());
            bcmBasicProjectInfoPO.setTwoOrgName(po.getOneOrgName());
            bcmBasicProjectInfoPO.setThreeInstitution(po.getOneInstitution());
            bcmBasicProjectInfoPO.setThreeOrgName(po.getOneOrgName());
            bcmBasicProjectInfoPO.setFourInstitution(po.getOneInstitution());
            bcmBasicProjectInfoPO.setFourOrgName(po.getOneOrgName());
        }
        return bcmBasicProjectInfoPO;
    }

    private String getProOrgName(BcmTChnipmpProjectPO po) {
        StringBuilder builder = new StringBuilder();
        builder.append(po.getOneOrgName());
        if (StringUtils.isNotBlank((String)po.getTwoInstitution()) && !po.getOneInstitution().equals(po.getTwoInstitution())) {
            builder.append("-" + po.getTwoOrgName());
            if (StringUtils.isNotBlank((String)po.getThreeInstitution()) && !po.getTwoInstitution().equals(po.getThreeInstitution())) {
                builder.append("-" + po.getThreeOrgName());
                if (StringUtils.isNotBlank((String)po.getFourInstitution()) && !po.getThreeInstitution().equals(po.getFourInstitution())) {
                    builder.append("-" + po.getFourOrgName());
                }
            }
        }
        return builder.toString();
    }

    private Map<String, BcmBasicProjectInfoPO> getBasicProject(List<BcmTChnipmpProjectPO> syncList) {
        BcmQueryBasicProjectInfoPO bcmQueryBasicProjectInfoPO = new BcmQueryBasicProjectInfoPO();
        bcmQueryBasicProjectInfoPO.setProjectCodeList(syncList.stream().map(BcmTChnipmpProjectPO::getProjectNo).collect(Collectors.toList()));
        List<BcmBasicProjectInfoPO> list = this.bcmBasicProjectInfoMapper.getList(bcmQueryBasicProjectInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(BcmBasicProjectInfoPO::getProjectCode, o -> o, (k1, k2) -> k2));
    }

    private Page<BcmTChnipmpProjectPO> getChnipmpProject() {
        BcmTChnipmpProjectPO bcmTChnipmpProjectPO = new BcmTChnipmpProjectPO();
        bcmTChnipmpProjectPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        Page page = new Page(1, this.dealSize.intValue());
        List<BcmTChnipmpProjectPO> pageList = this.bcmTChnipmpProjectMapper.getPageList(bcmTChnipmpProjectPO, (Page<BcmTChnipmpProjectPO>)page);
        page.setResult(pageList);
        return page;
    }
}

