/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.dao.BcmTbBudgetsubFmisMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmQueryBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmTbBudgetsubFmisPO;
import com.tydic.bcm.personal.po.BcmTbBudgetsubFmisUpdatePO;
import com.tydic.bcm.personal.task.api.BcmBudgetSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncBudgetProjectReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncBudgetProjectRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmBudgetSyncTaskService"})
public class BcmBudgetSyncTaskServiceImpl
implements BcmBudgetSyncTaskService {
    @Autowired
    private BcmTbBudgetsubFmisMapper bcmTbBudgetsubFmisMapper;
    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;
    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;
    private static final Integer delPage = 1;
    @Value(value="${DEAL_COUNT:100}")
    private Integer dealCount;
    @Value(value="${virtual.finance.org}")
    private String virtualFinanceOrg;
    private static final Long defaultUserId = 1L;
    private static final String defaultUserName = "\u7cfb\u7edf\u7ba1\u7406\u5458";

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncBudgetProject"})
    public BcmFmisSyncBudgetProjectRspBO syncBudgetProject(@RequestBody BcmFmisSyncBudgetProjectReqBO reqBO) {
        BcmFmisSyncBudgetProjectRspBO rspBO = new BcmFmisSyncBudgetProjectRspBO();
        BcmTbBudgetsubFmisPO qryPO = new BcmTbBudgetsubFmisPO();
        qryPO.setDealResult("PENDING");
        int syncNum = 0;
        while (true) {
            Page pageNow;
            List<BcmTbBudgetsubFmisPO> pageList;
            if (ObjectUtil.isEmpty(pageList = this.bcmTbBudgetsubFmisMapper.getPageList(qryPO, (Page<BcmTbBudgetsubFmisPO>)(pageNow = new Page(delPage.intValue(), this.dealCount.intValue()))))) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setSyncNum(Integer.valueOf(syncNum));
                return rspBO;
            }
            List<String> projectIdList = pageList.stream().map(BcmTbBudgetsubFmisPO::getPkObj).collect(Collectors.toList());
            BcmQueryBudgetProjectInfoPO qryProjectPO = new BcmQueryBudgetProjectInfoPO();
            qryProjectPO.setProjectIdList(projectIdList);
            qryProjectPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            List<BcmBudgetProjectInfoPO> projectInfoPOS = this.bcmBudgetProjectInfoMapper.getList(qryProjectPO);
            ArrayList<BcmBudgetProjectInfoPO> batchInsertPOList = new ArrayList<BcmBudgetProjectInfoPO>();
            if (ObjectUtil.isNotEmpty(projectInfoPOS)) {
                Map updateMap = projectInfoPOS.stream().collect(Collectors.toMap(BcmBudgetProjectInfoPO::getProjectId, Function.identity()));
                for (BcmTbBudgetsubFmisPO item : pageList) {
                    BcmOrgOrgsFmisPO nowOrgPO = this.bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty((Object)nowOrgPO) && !this.virtualFinanceOrg.equals(item.getPkOrg())) {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    if (!updateMap.containsKey(item.getPkObj())) {
                        BcmBudgetProjectInfoPO insertPO = this.setInsertReqPO(item, nowOrgPO);
                        batchInsertPOList.add(insertPO);
                        this.updateStatus(item, "SUCCESS");
                        continue;
                    }
                    BcmBudgetProjectInfoPO sourcePO = (BcmBudgetProjectInfoPO)updateMap.get(item.getPkObj());
                    BcmBudgetProjectInfoPO setPO = new BcmBudgetProjectInfoPO();
                    setPO.setProjectName(item.getObjname());
                    setPO.setProjectCode(item.getObjcode());
                    setPO.setStatus(item.getEnablestate());
                    setPO.setFinancialOrgId(item.getPkOrg());
                    this.fillVirtualFinanceOrg(setPO, nowOrgPO);
                    if (!setPO.equals(sourcePO)) {
                        setPO.setUpdateUserId(defaultUserId);
                        setPO.setUpdateUserName(defaultUserName);
                        setPO.setUpdateTime(new Date());
                        if (this.virtualFinanceOrg.equals(item.getPkOrg())) {
                            setPO.setPublicFlag(2);
                        } else {
                            setPO.setPublicFlag(1);
                        }
                        BcmBudgetProjectInfoPO wherePO = new BcmBudgetProjectInfoPO();
                        wherePO.setId(sourcePO.getId());
                        this.bcmBudgetProjectInfoMapper.updateBy(setPO, wherePO);
                        this.updateStatus(item, "SUCCESS");
                        continue;
                    }
                    this.updateStatus(item, "SKIP");
                }
            } else {
                for (BcmTbBudgetsubFmisPO item : pageList) {
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    BcmOrgOrgsFmisPO nowOrgPO = this.bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty((Object)nowOrgPO) && !this.virtualFinanceOrg.equals(item.getPkOrg())) {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    BcmBudgetProjectInfoPO insertPO = this.setInsertReqPO(item, nowOrgPO);
                    batchInsertPOList.add(insertPO);
                    this.updateStatus(item, "SUCCESS");
                }
            }
            if (!ObjectUtil.isNotEmpty(batchInsertPOList)) continue;
            int insertNum = this.bcmBudgetProjectInfoMapper.insertBatch(batchInsertPOList);
            syncNum += insertNum;
        }
    }

    private void updateStatus(BcmTbBudgetsubFmisPO item, String dealResult) {
        BcmTbBudgetsubFmisUpdatePO fmisSetPO = new BcmTbBudgetsubFmisUpdatePO();
        fmisSetPO.setDealResult(dealResult);
        fmisSetPO.setDealTime(new Date());
        BcmTbBudgetsubFmisUpdatePO fmisWherePO = new BcmTbBudgetsubFmisUpdatePO();
        fmisWherePO.setId(item.getId());
        this.bcmTbBudgetsubFmisMapper.updateBy(fmisSetPO, fmisWherePO);
    }

    private BcmBudgetProjectInfoPO setInsertReqPO(BcmTbBudgetsubFmisPO item, BcmOrgOrgsFmisPO nowOrgPO) {
        BcmBudgetProjectInfoPO insertPO = new BcmBudgetProjectInfoPO();
        insertPO.setId(BcmIdUtil.nextId());
        insertPO.setProjectId(item.getPkObj());
        insertPO.setProjectCode(item.getObjcode());
        insertPO.setProjectName(item.getObjname());
        insertPO.setStatus(item.getEnablestate());
        this.fillVirtualFinanceOrg(insertPO, nowOrgPO);
        insertPO.setCreateUserId(defaultUserId);
        insertPO.setCreateUserName(defaultUserName);
        insertPO.setCreateTime(new Date());
        insertPO.setUpdateUserId(defaultUserId);
        insertPO.setUpdateUserName(defaultUserName);
        insertPO.setUpdateTime(new Date());
        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        if (this.virtualFinanceOrg.equals(item.getPkOrg())) {
            insertPO.setPublicFlag(2);
        } else {
            insertPO.setPublicFlag(1);
        }
        return insertPO;
    }

    private void fillVirtualFinanceOrg(BcmBudgetProjectInfoPO bcmBudgetProjectInfoPO, BcmOrgOrgsFmisPO nowOrgPO) {
        if (nowOrgPO != null) {
            bcmBudgetProjectInfoPO.setFinancialOrgId(nowOrgPO.getPkOrg());
            bcmBudgetProjectInfoPO.setFinancialOrgCode(nowOrgPO.getCode());
            bcmBudgetProjectInfoPO.setFinancialOrgName(nowOrgPO.getName());
        } else {
            bcmBudgetProjectInfoPO.setFinancialOrgId(this.virtualFinanceOrg);
            bcmBudgetProjectInfoPO.setFinancialOrgCode(this.virtualFinanceOrg);
            bcmBudgetProjectInfoPO.setFinancialOrgName("\u865a\u62df\u8d22\u52a1\u7ec4\u7ec7");
        }
    }
}

