/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.dao.BcmFmisCostcenterMapper;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.po.BcmFmisCosetCenterPO;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmQueryCostInfoPO;
import com.tydic.bcm.personal.po.BcmQueryFmisCosetCenterPO;
import com.tydic.bcm.personal.po.BcmQueryOrgOrgsFmisPO;
import com.tydic.bcm.personal.task.api.BcmCostCenterSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmSyncCostCenterReqBO;
import com.tydic.bcm.personal.task.bo.BcmSyncCostCenterRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmCostCenterSyncTaskService"})
public class BcmCostCenterSyncTaskServiceImpl
implements BcmCostCenterSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmCostCenterSyncTaskServiceImpl.class);
    @Autowired
    private BcmFmisCostcenterMapper bcmFmisCostcenterMapper;
    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;
    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncCostCenter"})
    public BcmSyncCostCenterRspBO syncCostCenter(@RequestBody BcmSyncCostCenterReqBO reqBO) {
        this.sync();
        return BcmRuUtil.success(BcmSyncCostCenterRspBO.class);
    }

    private Page<BcmFmisCosetCenterPO> getFmisCosetCenterList(Integer pageNo, Integer pageSize) {
        BcmQueryFmisCosetCenterPO bcmQueryFmisCosetCenterPO = new BcmQueryFmisCosetCenterPO();
        bcmQueryFmisCosetCenterPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        Page page = new Page(pageNo.intValue(), pageSize.intValue());
        List<BcmFmisCosetCenterPO> list = this.bcmFmisCostcenterMapper.getPageList(bcmQueryFmisCosetCenterPO, (Page<BcmFmisCosetCenterPO>)page);
        page.setResult(list);
        return page;
    }

    private Map<String, BcmCostInfoPO> getCostMap(List<BcmFmisCosetCenterPO> fmisCosetCenterList) {
        BcmQueryCostInfoPO bcmQueryCostInfoPO = new BcmQueryCostInfoPO();
        bcmQueryCostInfoPO.setCostCenterCodeList(fmisCosetCenterList.stream().map(BcmFmisCosetCenterPO::getCcCode).collect(Collectors.toList()));
        bcmQueryCostInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        List<BcmCostInfoPO> costList = this.bcmCostInfoMapper.getList(bcmQueryCostInfoPO);
        if (CollectionUtils.isEmpty(costList)) {
            return null;
        }
        Map<String, BcmCostInfoPO> costMap = costList.stream().collect(Collectors.toMap(a -> a.getCostCenterCode() + "-" + a.getFinancialOrgCode(), o -> o, (k1, k2) -> k2));
        return costMap;
    }

    private void sync() {
        Page<BcmFmisCosetCenterPO> page = this.getFmisCosetCenterList(1, this.dealSize);
        List fmisCosetCenterList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)fmisCosetCenterList)) {
            return;
        }
        Map<String, BcmCostInfoPO> costMap = this.getCostMap(fmisCosetCenterList);
        log.info("\u6210\u672c\u4e2d\u5fc3Map{}", (Object)JSONObject.toJSONString(costMap));
        ArrayList<Long> successIdList = new ArrayList(fmisCosetCenterList.size());
        ArrayList<Long> skipIdList = new ArrayList<Long>(fmisCosetCenterList.size());
        ArrayList<Long> failIdList = new ArrayList(fmisCosetCenterList.size());
        Map<String, List<BcmOrgOrgsFmisPO>> orgListMap = this.getOrgListMap(fmisCosetCenterList);
        if (CollectionUtils.isEmpty(costMap)) {
            Map<String, List<Long>> idMap = this.addCost(fmisCosetCenterList, orgListMap);
            successIdList = idMap.get(BcmDealResultEnum.SUCCESS.getDealResult());
            failIdList = idMap.get(BcmDealResultEnum.FAIL.getDealResult());
        } else {
            Date now = new Date();
            ArrayList<BcmFmisCosetCenterPO> addList = new ArrayList<BcmFmisCosetCenterPO>(fmisCosetCenterList.size());
            ArrayList<BcmCostInfoPO> updateList = new ArrayList<BcmCostInfoPO>(fmisCosetCenterList.size());
            for (BcmFmisCosetCenterPO fmisCosetCenterPO : fmisCosetCenterList) {
                log.info("\u6210\u672c\u4e2d\u5fc3key{}", (Object)(fmisCosetCenterPO.getCcCode() + "-" + fmisCosetCenterPO.getOrgCode()));
                log.info("\u662f\u5426\u5b58\u5728{}", (Object)costMap.containsKey(fmisCosetCenterPO.getCcCode() + "-" + fmisCosetCenterPO.getOrgCode()));
                BcmCostInfoPO costInfoPO = costMap.get(fmisCosetCenterPO.getCcCode() + "-" + fmisCosetCenterPO.getOrgCode());
                if (costInfoPO == null) {
                    addList.add(fmisCosetCenterPO);
                    continue;
                }
                List<BcmOrgOrgsFmisPO> orgList = orgListMap.get(fmisCosetCenterPO.getOrgCode());
                if (!costInfoPO.getCostCenterName().equals(fmisCosetCenterPO.getCcName()) || !costInfoPO.getFinancialOrgName().equals(fmisCosetCenterPO.getOrgName())) {
                    BcmCostInfoPO updatePO = new BcmCostInfoPO();
                    if (CollectionUtils.isEmpty(orgList)) {
                        failIdList.add(fmisCosetCenterPO.getId());
                        continue;
                    }
                    BcmOrgOrgsFmisPO orgOrgsFmisPO = this.getOrg(orgList);
                    updatePO.setCostCenterId(fmisCosetCenterPO.getCcCode());
                    updatePO.setCostCenterCode(fmisCosetCenterPO.getCcCode());
                    updatePO.setCostCenterName(fmisCosetCenterPO.getCcName());
                    updatePO.setUpdateTime(now);
                    updatePO.setFinancialOrgCode(fmisCosetCenterPO.getOrgCode());
                    updatePO.setFinancialOrgName(fmisCosetCenterPO.getOrgName());
                    updatePO.setFinancialOrgId(orgOrgsFmisPO.getPkOrg());
                    updateList.add(updatePO);
                    successIdList.add(fmisCosetCenterPO.getId());
                    continue;
                }
                skipIdList.add(fmisCosetCenterPO.getId());
            }
            if (!CollectionUtils.isEmpty(addList)) {
                Map<String, List<Long>> idMap = this.addCost(fmisCosetCenterList, orgListMap);
                successIdList.addAll((Collection<Long>)idMap.get(BcmDealResultEnum.SUCCESS.getDealResult()));
                failIdList.addAll((Collection<Long>)idMap.get(BcmDealResultEnum.FAIL.getDealResult()));
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.bcmCostInfoMapper.updateBatch(updateList);
            }
        }
        if (!CollectionUtils.isEmpty(successIdList)) {
            this.updateFmisCosetCenter(successIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (!CollectionUtils.isEmpty(skipIdList)) {
            this.updateFmisCosetCenter(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
        }
        if (!CollectionUtils.isEmpty(failIdList)) {
            this.updateFmisCosetCenter(failIdList, BcmDealResultEnum.FAIL.getDealResult());
        }
        if (page.getTotalPages() > 1) {
            this.sync();
        }
    }

    private Map<String, List<Long>> addCost(List<BcmFmisCosetCenterPO> fmisCosetCenterList, Map<String, List<BcmOrgOrgsFmisPO>> orgListMap) {
        ArrayList<BcmCostInfoPO> bcmCostInfoPOS = new ArrayList<BcmCostInfoPO>(fmisCosetCenterList.size());
        Date now = new Date();
        ArrayList<Long> successIdList = new ArrayList<Long>(fmisCosetCenterList.size());
        ArrayList<Long> failIdList = new ArrayList<Long>(fmisCosetCenterList.size());
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>(2);
        for (BcmFmisCosetCenterPO fmisCosetCenterPO : fmisCosetCenterList) {
            List<BcmOrgOrgsFmisPO> orgList = orgListMap.get(fmisCosetCenterPO.getOrgCode());
            if (CollectionUtils.isEmpty(orgList)) {
                failIdList.add(fmisCosetCenterPO.getId());
                continue;
            }
            BcmOrgOrgsFmisPO orgOrgsFmisPO = this.getOrg(orgList);
            BcmCostInfoPO bcmCostInfoPO = new BcmCostInfoPO();
            bcmCostInfoPO.setId(BcmIdUtil.nextId());
            bcmCostInfoPO.setStatus(BcmPersonalCommonConstant.Status.ENABLE);
            bcmCostInfoPO.setCostCenterId(fmisCosetCenterPO.getCcCode());
            bcmCostInfoPO.setCostCenterCode(fmisCosetCenterPO.getCcCode());
            bcmCostInfoPO.setCostCenterName(fmisCosetCenterPO.getCcName());
            bcmCostInfoPO.setFinancialOrgId(orgOrgsFmisPO.getPkOrg());
            bcmCostInfoPO.setFinancialOrgName(orgOrgsFmisPO.getName());
            bcmCostInfoPO.setFinancialOrgCode(orgOrgsFmisPO.getCode());
            bcmCostInfoPO.setCreateTime(now);
            bcmCostInfoPO.setUpdateTime(now);
            bcmCostInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            bcmCostInfoPOS.add(bcmCostInfoPO);
            successIdList.add(fmisCosetCenterPO.getId());
        }
        if (!CollectionUtils.isEmpty(bcmCostInfoPOS)) {
            this.bcmCostInfoMapper.insertBatch(bcmCostInfoPOS);
        }
        idMap.put(BcmDealResultEnum.SUCCESS.getDealResult(), successIdList);
        idMap.put(BcmDealResultEnum.FAIL.getDealResult(), failIdList);
        return idMap;
    }

    private void updateFmisCosetCenter(List<Long> idList, String dealResult) {
        BcmQueryFmisCosetCenterPO bcmQueryFmisCosetCenterPO = new BcmQueryFmisCosetCenterPO();
        bcmQueryFmisCosetCenterPO.setIdList(idList);
        bcmQueryFmisCosetCenterPO.setDealResult(dealResult);
        bcmQueryFmisCosetCenterPO.setDealTime(new Date());
        this.bcmFmisCostcenterMapper.updateBatchById(bcmQueryFmisCosetCenterPO);
    }

    private Map<String, List<BcmOrgOrgsFmisPO>> getOrgListMap(List<BcmFmisCosetCenterPO> fmisCosetCenterList) {
        Set orgCodeSet = fmisCosetCenterList.stream().map(BcmFmisCosetCenterPO::getOrgCode).collect(Collectors.toSet());
        BcmQueryOrgOrgsFmisPO bcmQueryOrgOrgsFmisPO = new BcmQueryOrgOrgsFmisPO();
        bcmQueryOrgOrgsFmisPO.setOrgCodeList(new ArrayList<String>(orgCodeSet));
        List<BcmOrgOrgsFmisPO> orgList = this.bcmOrgOrgsFmisMapper.getList(bcmQueryOrgOrgsFmisPO);
        if (CollectionUtils.isEmpty(orgList)) {
            return new HashMap<String, List<BcmOrgOrgsFmisPO>>();
        }
        return orgList.stream().collect(Collectors.groupingBy(BcmOrgOrgsFmisPO::getCode));
    }

    private BcmOrgOrgsFmisPO getOrg(List<BcmOrgOrgsFmisPO> orgList) {
        orgList = orgList.stream().sorted(Comparator.comparing(BcmOrgOrgsFmisPO::getPushTime).reversed()).collect(Collectors.toList());
        return orgList.get(0);
    }
}

