/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmQueryOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.task.api.BcmFinanceOrgSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncFinanceOrgReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncFinanceOrgRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmFinanceOrgSyncTaskService"})
public class BcmFinanceOrgSyncTaskServiceImpl
implements BcmFinanceOrgSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmFinanceOrgSyncTaskServiceImpl.class);
    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;
    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;
    @Value(value="${DEAL_FINANCE_ORG_COUNT:100}")
    private Integer dealCount;
    @Value(value="${SYNC_FINANCE_ORG_ALL_URL:}")
    private String syncFinanceOrgAllUrl;
    @Value(value="${SYNC_ORG_EXT_ALL_URL:}")
    private String syncOrgExtAllUrl;
    private static final Integer delPage = 1;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncFinanceOrg"})
    public BcmFmisSyncFinanceOrgRspBO syncFinanceOrg(@RequestBody BcmFmisSyncFinanceOrgReqBO reqBO) {
        BcmFmisSyncFinanceOrgRspBO rspBO = new BcmFmisSyncFinanceOrgRspBO();
        BcmQueryOrgOrgsFmisPO qryPO = new BcmQueryOrgOrgsFmisPO();
        qryPO.setDealResult("PENDING");
        Page page = new Page(delPage.intValue(), this.dealCount.intValue());
        List<BcmOrgOrgsFmisPO> pageList = this.bcmOrgOrgsFmisMapper.getPageList(qryPO, (Page<BcmOrgOrgsFmisPO>)page);
        if (ObjectUtil.isEmpty(pageList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Date lastDate = pageList.get(0).getPushTime();
        JSONObject reqStr = new JSONObject();
        reqStr.put("extField2", (Object)"0");
        log.info("\u540c\u6b65\u4e4b\u524d\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6e05\u9664\u4e0a\u6b21\u7684\u6807\u5fd7\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr.toJSONString());
        String rspStr = HttpUtil.post((String)this.syncOrgExtAllUrl, (String)reqStr.toJSONString());
        log.info("\u540c\u6b65\u4e4b\u524d\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6e05\u9664\u4e0a\u6b21\u7684\u6807\u5fd7\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType("NC_ORG");
        BcmSyncLogPO bcmSyncLogPO = this.bcmSyncLogMapper.getModelBy(syncLogPO);
        if (ObjectUtil.isNotEmpty((Object)bcmSyncLogPO)) {
            BcmSyncLogPO updateLogPO = new BcmSyncLogPO();
            updateLogPO.setId(bcmSyncLogPO.getId());
            updateLogPO.setLastDate(lastDate);
            this.bcmSyncLogMapper.updateById(updateLogPO);
        } else {
            BcmSyncLogPO insertLogPO = new BcmSyncLogPO();
            insertLogPO.setId(BcmIdUtil.nextId());
            insertLogPO.setDataType("NC_ORG");
            insertLogPO.setLastDate(lastDate);
            this.bcmSyncLogMapper.insert(insertLogPO);
        }
        int syncNum = 0;
        while (true) {
            Page pageNow;
            if (ObjectUtil.isEmpty(pageList = this.bcmOrgOrgsFmisMapper.getPageList(qryPO, (Page<BcmOrgOrgsFmisPO>)(pageNow = new Page(delPage.intValue(), this.dealCount.intValue()))))) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setSyncNum(Integer.valueOf(syncNum));
                return rspBO;
            }
            this.doAbilityMethod(pageList, this.syncFinanceOrgAllUrl);
            syncNum += pageList.size();
        }
    }

    private void doAbilityMethod(List<BcmOrgOrgsFmisPO> successPOList, String url) {
        List<Long> idList = successPOList.stream().map(BcmOrgOrgsFmisPO::getId).collect(Collectors.toList());
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("\u540c\u6b65\u8d22\u52a1\u7ec4\u7ec7\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)url, (String)reqStr);
        log.info("\u540c\u6b65\u8d22\u52a1\u7ec4\u7ec7\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        if (!rspStr.contains("\u5931\u8d25")) {
            this.changeDealResult(idList, "SUCCESS");
        } else {
            this.changeDealResult(idList, "FAIL");
        }
    }

    private void changeDealResult(List<Long> ids, String dealResult) {
        BcmQueryOrgOrgsFmisPO updatePO = new BcmQueryOrgOrgsFmisPO();
        updatePO.setDealResult(dealResult);
        updatePO.setDealTime(new Date());
        updatePO.setIdList(ids);
        this.bcmOrgOrgsFmisMapper.updateBatchById(updatePO);
    }
}

