/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFinanceMatterApplyMapper;
import com.tydic.bcm.personal.dao.BcmFmisFinmattersMapper;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyExtendPO;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyPO;
import com.tydic.bcm.personal.po.BcmFmisFinmattersPO;
import com.tydic.bcm.personal.po.BcmQueryFmisFinmattersPO;
import com.tydic.bcm.personal.task.api.BcmFmisFinmattersSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisFinmattersSyncTaskReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisFinmattersSyncTaskRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmFmisFinmattersSyncTaskService"})
public class BcmFmisFinmattersSyncTaskServiceImpl
implements BcmFmisFinmattersSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmFmisFinmattersSyncTaskServiceImpl.class);
    @Autowired
    private BcmFmisFinmattersMapper bcmFmisFinmattersMapper;
    @Autowired
    private BcmFinanceMatterApplyMapper bcmFinanceMatterApplyMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncFmisFinmatters"})
    public BcmFmisFinmattersSyncTaskRspBO syncFmisFinmatters(@RequestBody BcmFmisFinmattersSyncTaskReqBO reqBO) {
        this.sync();
        return BcmRuUtil.success(BcmFmisFinmattersSyncTaskRspBO.class);
    }

    private void sync() {
        Page<BcmFmisFinmattersPO> page = this.getFmisFinmatters();
        List list = page.getResult();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<Long> successIdList = new ArrayList(list.size());
        Map<String, BcmFinanceMatterApplyPO> thanMap = this.getFinanceMatterApply(list);
        if (CollectionUtils.isEmpty(thanMap)) {
            this.addFinanceMatterApply(list);
            successIdList = list.stream().map(BcmFmisFinmattersPO::getId).collect(Collectors.toList());
        } else {
            ArrayList<Long> skipIdList = new ArrayList<Long>(list.size());
            ArrayList<BcmFmisFinmattersPO> addList = new ArrayList<BcmFmisFinmattersPO>(list.size());
            ArrayList<BcmFinanceMatterApplyPO> updateList = new ArrayList<BcmFinanceMatterApplyPO>(list.size());
            for (BcmFmisFinmattersPO po : list) {
                BcmFinanceMatterApplyPO fmaPO = thanMap.get(po.getFileId());
                if (fmaPO == null) {
                    addList.add(po);
                    successIdList.add(po.getId());
                    continue;
                }
                if (!(po.getItemName().equals(fmaPO.getFinanceApplyName()) && po.getObjCode().equals(fmaPO.getBudgetProjectCode()) && po.getObjName().equals(fmaPO.getBudgetProjectName()) && po.getCode().equals(fmaPO.getFinanceOrgCode()) && po.getName().equals(fmaPO.getFinanceOrgName()))) {
                    fmaPO = this.setUpdateBcmFinanceMatterApplyPO(fmaPO, po);
                    successIdList.add(po.getId());
                    updateList.add(fmaPO);
                    continue;
                }
                skipIdList.add(po.getId());
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.bcmFinanceMatterApplyMapper.updadateBath(updateList);
            }
            if (!CollectionUtils.isEmpty(addList)) {
                this.addFinanceMatterApply(addList);
            }
            if (!CollectionUtils.isEmpty(skipIdList)) {
                this.updateFmisFinmatters(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
            }
        }
        if (!CollectionUtils.isEmpty(successIdList)) {
            this.updateFmisFinmatters(successIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (page.getTotalPages() > 1) {
            this.sync();
        }
    }

    private BcmFinanceMatterApplyPO setUpdateBcmFinanceMatterApplyPO(BcmFinanceMatterApplyPO fmaPO, BcmFmisFinmattersPO po) {
        fmaPO.setFinanceApplyName(po.getItemName());
        fmaPO.setFinanceApplyId(po.getFileId());
        fmaPO.setFinanceApplyCode(po.getFileId());
        fmaPO.setBudgetProjectCode(po.getObjCode());
        fmaPO.setBudgetProjectName(po.getObjName());
        fmaPO.setFinanceOrgCode(po.getCode());
        fmaPO.setFinanceOrgName(po.getName());
        fmaPO.setUpdateUserName(po.getModifier());
        if (StringUtils.isNotBlank((String)po.getModifiedTime())) {
            fmaPO.setUpdateTime(this.strToDate(po.getModifiedTime()));
        }
        return fmaPO;
    }

    private void updateFmisFinmatters(List<Long> idList, String dealResult) {
        BcmQueryFmisFinmattersPO bcmQueryFmisFinmattersPO = new BcmQueryFmisFinmattersPO();
        bcmQueryFmisFinmattersPO.setIdList(idList);
        bcmQueryFmisFinmattersPO.setDealResult(dealResult);
        bcmQueryFmisFinmattersPO.setDealTime(new Date());
        this.bcmFmisFinmattersMapper.updateBathById(bcmQueryFmisFinmattersPO);
    }

    private Page<BcmFmisFinmattersPO> getFmisFinmatters() {
        BcmQueryFmisFinmattersPO bcmQueryFmisFinmattersPO = new BcmQueryFmisFinmattersPO();
        bcmQueryFmisFinmattersPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        Page page = new Page(1, this.dealSize.intValue());
        List<BcmFmisFinmattersPO> pageList = this.bcmFmisFinmattersMapper.getPageList(bcmQueryFmisFinmattersPO, (Page<BcmFmisFinmattersPO>)page);
        page.setResult(pageList);
        return page;
    }

    private void addFinanceMatterApply(List<BcmFmisFinmattersPO> list) {
        ArrayList<BcmFinanceMatterApplyPO> financeMatterApplyPOList = new ArrayList<BcmFinanceMatterApplyPO>(list.size());
        for (BcmFmisFinmattersPO fso : list) {
            BcmFinanceMatterApplyPO fsoApplyPO = this.setBcmFinanceMatterApplyPO(fso);
            financeMatterApplyPOList.add(fsoApplyPO);
        }
        this.bcmFinanceMatterApplyMapper.insertBatch(financeMatterApplyPOList);
    }

    private BcmFinanceMatterApplyPO setBcmFinanceMatterApplyPO(BcmFmisFinmattersPO po) {
        log.info("\u65b0\u589ePO" + JSONObject.toJSONString((Object)po));
        BcmFinanceMatterApplyPO fsoApplyPO = new BcmFinanceMatterApplyPO();
        fsoApplyPO.setId(po.getId());
        fsoApplyPO.setFinanceApplyCode(po.getFileId());
        fsoApplyPO.setFinanceApplyId(po.getFileId());
        fsoApplyPO.setFinanceApplyName(po.getItemName());
        fsoApplyPO.setBudgetProjectCode(po.getObjCode());
        fsoApplyPO.setBudgetProjectName(po.getObjName());
        fsoApplyPO.setFinanceOrgCode(po.getCode());
        fsoApplyPO.setFinanceOrgName(po.getName());
        fsoApplyPO.setCreateUserName(po.getCreator());
        fsoApplyPO.setUpdateUserName(po.getModifier());
        fsoApplyPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        fsoApplyPO.setCreateTime(this.strToDate(po.getCreateTime()));
        if (!StringUtils.isBlank((String)po.getModifiedTime())) {
            fsoApplyPO.setUpdateTime(this.strToDate(po.getModifiedTime()));
        } else {
            fsoApplyPO.setUpdateTime(this.strToDate(po.getCreateTime()));
        }
        return fsoApplyPO;
    }

    private Date strToDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return new Date();
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    private Map<String, BcmFinanceMatterApplyPO> getFinanceMatterApply(List<BcmFmisFinmattersPO> list) {
        BcmFinanceMatterApplyExtendPO bcmFinanceMatterApplyExtendPO = new BcmFinanceMatterApplyExtendPO();
        bcmFinanceMatterApplyExtendPO.setFinanceApplyCodeList(list.stream().map(BcmFmisFinmattersPO::getFileId).collect(Collectors.toList()));
        bcmFinanceMatterApplyExtendPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        List<BcmFinanceMatterApplyPO> financeMatterApplyList = this.bcmFinanceMatterApplyMapper.getList(bcmFinanceMatterApplyExtendPO);
        if (CollectionUtils.isEmpty(financeMatterApplyList)) {
            return null;
        }
        return financeMatterApplyList.stream().collect(Collectors.toMap(BcmFinanceMatterApplyPO::getFinanceApplyCode, o -> o, (k1, k2) -> k2));
    }
}

