/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.dao.BcmFmisPaymentRecordMapper;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.po.BcmFmisPaymentRecordPO;
import com.tydic.bcm.personal.po.BcmQueryFmisPaymentRecordPO;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.task.api.BcmFmisPaymentRecordSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisPaymentRecordSyncTaskReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisPaymentRecordSyncTaskRspBO;
import com.tydic.bcm.personal.task.bo.BcmFscPayInfoBackAbilityReqBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmFmisPaymentRecordSyncTaskService"})
public class BcmFmisPaymentRecordSyncTaskServiceImpl
implements BcmFmisPaymentRecordSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmFmisPaymentRecordSyncTaskServiceImpl.class);
    @Autowired
    private BcmFmisPaymentRecordMapper bcmFmisPaymentRecordMapper;
    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;
    @Value(value="${SYNC_PAYMENT_RECORD_URL:url}")
    private String syncPaymentRecordUrl;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncPaymentRecord"})
    public BcmFmisPaymentRecordSyncTaskRspBO syncPaymentRecord(@RequestBody BcmFmisPaymentRecordSyncTaskReqBO reqBO) {
        this.sync();
        return BcmRuUtil.success(BcmFmisPaymentRecordSyncTaskRspBO.class);
    }

    private void sync() {
        Page<BcmFmisPaymentRecordPO> syncPage = this.getFmisPaymentRecordList();
        List syncList = syncPage.getResult();
        ArrayList<Long> succssIdList = new ArrayList<Long>(syncList.size());
        ArrayList<Long> failIdList = new ArrayList<Long>(syncList.size());
        if (CollectionUtils.isEmpty((Collection)syncList)) {
            return;
        }
        BcmSyncLogPO syncLogPO = this.getSyncLog();
        if (syncLogPO == null) {
            for (BcmFmisPaymentRecordPO po : syncList) {
                boolean check = this.pushAbility(po);
                if (check) {
                    succssIdList.add(po.getId());
                    continue;
                }
                failIdList.add(po.getId());
            }
            this.addSyncLog();
        } else {
            ArrayList<Long> skipIdList = new ArrayList<Long>(syncList.size());
            ArrayList addList = new ArrayList(syncList.size());
            addList.addAll(syncList);
            if (!CollectionUtils.isEmpty(addList)) {
                for (BcmFmisPaymentRecordPO po : addList) {
                    boolean check = this.pushAbility(po);
                    if (check) {
                        succssIdList.add(po.getId());
                        continue;
                    }
                    failIdList.add(po.getId());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)syncList)) {
                this.updateFmisPaymentRecord(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
            }
            this.updateSyncLog(syncLogPO.getId());
        }
        if (!CollectionUtils.isEmpty(succssIdList)) {
            this.updateFmisPaymentRecord(succssIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (!CollectionUtils.isEmpty(failIdList)) {
            this.updateFmisPaymentRecord(failIdList, BcmDealResultEnum.FAIL.getDealResult());
        }
        if (syncPage.getTotalPages() > 1) {
            this.sync();
        }
    }

    private void setComparePO(BcmFmisPaymentRecordPO po) {
        po.setId(null);
        po.setDealTime(null);
        po.setDealResult(null);
    }

    private Map<String, BcmFmisPaymentRecordPO> getThanMap(List<String> storeIdList, Date pushTime) {
        BcmQueryFmisPaymentRecordPO bcmQueryFmisPaymentRecordPO = new BcmQueryFmisPaymentRecordPO();
        bcmQueryFmisPaymentRecordPO.setPushTime(pushTime);
        bcmQueryFmisPaymentRecordPO.setStoreIdList(storeIdList);
        bcmQueryFmisPaymentRecordPO.setDealResult(BcmDealResultEnum.SUCCESS.getDealResult());
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayString = yesterday.format(formatter);
        bcmQueryFmisPaymentRecordPO.setPaymentTime(yesterdayString);
        List<BcmFmisPaymentRecordPO> list = this.bcmFmisPaymentRecordMapper.getList(bcmQueryFmisPaymentRecordPO);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(BcmFmisPaymentRecordPO::getStoreId, o -> o, (k1, k2) -> k2));
    }

    private Boolean pushAbility(BcmFmisPaymentRecordPO po) {
        log.info("\u4ed8\u6b3e\u8bb0\u5f55po:{}", (Object)JSONObject.toJSONString((Object)po));
        BcmFscPayInfoBackAbilityReqBO bcmFscPayInfoReqBO = new BcmFscPayInfoBackAbilityReqBO();
        bcmFscPayInfoReqBO.setBusiAmount(new BigDecimal(po.getPaymentAmount()));
        bcmFscPayInfoReqBO.setBusiOrderId(Long.valueOf(po.getStoreId()));
        bcmFscPayInfoReqBO.setPayerName(po.getPayer());
        bcmFscPayInfoReqBO.setShouldPayId(Long.valueOf(po.getOrderItemId()));
        if (!"1".equals(po.getPaymentResult())) {
            bcmFscPayInfoReqBO.setPayResult("0");
        } else {
            bcmFscPayInfoReqBO.setPayResult(po.getPaymentResult());
        }
        bcmFscPayInfoReqBO.setBusiTime((Date)DateUtil.parse((CharSequence)po.getPaymentTime()));
        bcmFscPayInfoReqBO.setId(po.getId());
        log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0url:{}\u5165\u53c2:{}", (Object)this.syncPaymentRecordUrl, (Object)JSONObject.toJSONString((Object)bcmFscPayInfoReqBO));
        String rspStr = HttpUtil.post((String)this.syncPaymentRecordUrl, (String)JSONObject.toJSONString((Object)bcmFscPayInfoReqBO));
        log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2:{}", (Object)rspStr);
        if (StrUtil.isBlank((CharSequence)rspStr)) {
            return false;
        }
        BaseRspBo baseRspBo = BcmRuUtil.jss(rspStr, BaseRspBo.class);
        return "0".equals(baseRspBo.getCode());
    }

    private BcmSyncLogPO getSyncLog() {
        BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
        bcmSyncLogPO.setDataType("PAYMENT_RECORD");
        return this.bcmSyncLogMapper.getModelBy(bcmSyncLogPO);
    }

    private Page<BcmFmisPaymentRecordPO> getFmisPaymentRecordList() {
        BcmFmisPaymentRecordPO bcmFmisPaymentRecordPO = new BcmFmisPaymentRecordPO();
        bcmFmisPaymentRecordPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayString = yesterday.format(formatter);
        bcmFmisPaymentRecordPO.setPaymentTime(yesterdayString);
        Page page = new Page(1, this.dealSize.intValue());
        List<BcmFmisPaymentRecordPO> pageList = this.bcmFmisPaymentRecordMapper.getPageList(bcmFmisPaymentRecordPO, (Page<BcmFmisPaymentRecordPO>)page);
        page.setResult(pageList);
        return page;
    }

    private void updateFmisPaymentRecord(List<Long> idList, String dealResult) {
        BcmQueryFmisPaymentRecordPO bcmQueryFmisPaymentRecordPO = new BcmQueryFmisPaymentRecordPO();
        bcmQueryFmisPaymentRecordPO.setIdList(idList);
        bcmQueryFmisPaymentRecordPO.setDealResult(dealResult);
        bcmQueryFmisPaymentRecordPO.setDealTime(new Date());
        this.bcmFmisPaymentRecordMapper.updateBatch(bcmQueryFmisPaymentRecordPO);
    }

    private void addSyncLog() {
        BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
        bcmSyncLogPO.setId(BcmIdUtil.nextId());
        bcmSyncLogPO.setLastDate(new Date());
        bcmSyncLogPO.setDataType("PAYMENT_RECORD");
        this.bcmSyncLogMapper.insert(bcmSyncLogPO);
    }

    private void updateSyncLog(Long id) {
        BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
        bcmSyncLogPO.setId(id);
        bcmSyncLogPO.setLastDate(new Date());
        this.bcmSyncLogMapper.updateById(bcmSyncLogPO);
    }

    public static void main(String[] args) {
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterdayString = yesterday.format(formatter);
        System.out.println(yesterdayString);
    }
}

