/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.bcm.personal.constants.ContractStatusEnum;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpContractInfoMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoExtendPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoPO;
import com.tydic.bcm.personal.task.api.BcmIpmpContractSyncTaskService;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmIpmpContractSyncTaskService"})
public class BcmIpmpContractSyncTaskServiceImpl
implements BcmIpmpContractSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmIpmpContractSyncTaskServiceImpl.class);
    private final BcmSyncLogMapper bcmSyncLogMapper;
    private final TChnipmpContractInfoMapper tChnipmpContractInfoMapper;
    @Value(value="${DEAL_COUNT:100}")
    private Integer dealCount;
    @Value(value="${SYNC_IPMP_CONTRACT_URL:}")
    private String syncIpmpContractUrl;
    @Resource
    private FileClient fileClient;
    @Value(value="${OUT_FILE_DOWN:url}")
    private String outFileDownUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    private static final String PATH = "dyc-common/";

    @Async(value="contract-sync-thread-pool")
    @PostMapping(value={"syncIpmpContract"})
    public void syncIpmpContract() {
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType("IPMP_CONTRACT");
        BcmSyncLogPO bcmSyncLogPO = this.bcmSyncLogMapper.getModelBy(syncLogPO);
        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;
        while (true) {
            List<TChnipmpContractInfoPO> existSupplier;
            Page page = new Page(pageNo, this.dealCount.intValue());
            TChnipmpContractInfoExtendPO contract = new TChnipmpContractInfoExtendPO();
            contract.setDealResult("PENDING");
            contract.setGtPushDate(pushDate);
            List<TChnipmpContractInfoPO> needDealContractList = this.tChnipmpContractInfoMapper.queryAllByLimit(contract, (Page<TChnipmpContractInfoPO>)page);
            if (CollectionUtil.isEmpty(needDealContractList)) break;
            List<String> contractIds = needDealContractList.stream().map(TChnipmpContractInfoPO::getId).collect(Collectors.toList());
            HashMap existContractMap = new HashMap();
            if (pushDate != null && CollectionUtil.isNotEmpty(existSupplier = this.tChnipmpContractInfoMapper.queryLastByOutId(contractIds, pushDate))) {
                List<TChnipmpContractInfoPO> tChnipmpContractInfoPOS;
                List<String> contractNos = existSupplier.stream().filter(a -> ContractStatusEnum.CANCEL.getContractStatus().equals(a.getContractStatus()) && !ObjectUtil.isEmpty((Object)a.getContractNo())).map(a -> a.getContractNo()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(contractNos) && !CollectionUtils.isEmpty(tChnipmpContractInfoPOS = this.tChnipmpContractInfoMapper.queryLastByOriginNo(contractNos, pushDate))) {
                    List originNos = tChnipmpContractInfoPOS.stream().filter(a -> !ObjectUtil.isEmpty((Object)a.getOriginContractNo())).map(a -> a.getOriginContractNo()).distinct().collect(Collectors.toList());
                    for (TChnipmpContractInfoPO need : needDealContractList) {
                        if (!originNos.contains(need.getContractNo())) continue;
                        need.setContractStatus("14");
                    }
                }
                existContractMap.putAll(existSupplier.stream().collect(Collectors.toMap(TChnipmpContractInfoPO::getId, Function.identity())));
            }
            ArrayList<TChnipmpContractInfoPO> resultList = new ArrayList<TChnipmpContractInfoPO>();
            for (TChnipmpContractInfoPO need : needDealContractList) {
                block15: {
                    need.setDealTime(new Date());
                    TChnipmpContractInfoPO contractInfoPO = (TChnipmpContractInfoPO)existContractMap.get(need.getId());
                    if (!need.equals(contractInfoPO)) {
                        TChnipmpContractInfoExtendPO tChnipmpContractInfoExtendPO = (TChnipmpContractInfoExtendPO)BeanUtil.copyProperties((Object)need, TChnipmpContractInfoExtendPO.class);
                        try {
                            List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> argFileInfoBOS;
                            ArrayList<TChnipmpContractInfoExtendPO.ArgFileInfoBO> fileList = new ArrayList<TChnipmpContractInfoExtendPO.ArgFileInfoBO>();
                            if (StrUtil.isNotBlank((CharSequence)tChnipmpContractInfoExtendPO.getFileEcm0301())) {
                                argFileInfoBOS = this.contractFile(tChnipmpContractInfoExtendPO.getFileEcm0301(), tChnipmpContractInfoExtendPO.getFileName0301());
                                fileList.addAll(argFileInfoBOS);
                            }
                            if (StrUtil.isNotBlank((CharSequence)tChnipmpContractInfoExtendPO.getFileEcm0305())) {
                                argFileInfoBOS = this.contractFile(tChnipmpContractInfoExtendPO.getFileEcm0305(), tChnipmpContractInfoExtendPO.getFileName0305());
                                fileList.addAll(argFileInfoBOS);
                            }
                            if (StrUtil.isNotBlank((CharSequence)tChnipmpContractInfoExtendPO.getFileEcm0306())) {
                                argFileInfoBOS = this.contractFile(tChnipmpContractInfoExtendPO.getFileEcm0306(), tChnipmpContractInfoExtendPO.getFileName0306());
                                fileList.addAll(argFileInfoBOS);
                            }
                            if (StrUtil.isNotBlank((CharSequence)tChnipmpContractInfoExtendPO.getFileEcm0304())) {
                                argFileInfoBOS = this.contractFile(tChnipmpContractInfoExtendPO.getFileEcm0304(), tChnipmpContractInfoExtendPO.getFileName0304());
                                fileList.addAll(argFileInfoBOS);
                            }
                            if (StrUtil.isNotBlank((CharSequence)tChnipmpContractInfoExtendPO.getFileEcm0314())) {
                                argFileInfoBOS = this.contractFile(tChnipmpContractInfoExtendPO.getFileEcm0314(), tChnipmpContractInfoExtendPO.getFileName0314());
                                fileList.addAll(argFileInfoBOS);
                            }
                            tChnipmpContractInfoExtendPO.setAgrAccessoryBOs(fileList);
                            boolean b = this.doAbilityMethod(tChnipmpContractInfoExtendPO);
                            if (b) {
                                need.setDealResult("SUCCESS");
                                break block15;
                            }
                            need.setDealResult("FAIL");
                        }
                        catch (Exception e) {
                            log.error("\u5408\u540c\u540c\u6b65\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)tChnipmpContractInfoExtendPO), (Object)e);
                            need.setDealResult("FAIL");
                        }
                    } else {
                        need.setDealResult("SKIP");
                    }
                }
                resultList.add(need);
            }
            if (!CollectionUtil.isNotEmpty(resultList)) continue;
            this.tChnipmpContractInfoMapper.insertOrUpdateBatch(resultList);
        }
        this.finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
    }

    private List<TChnipmpContractInfoExtendPO.ArgFileInfoBO> contractFile(String fileIdStr, String fileNameStr) {
        Object[] fileIds = fileIdStr.split(",");
        Object[] fileNameList = fileNameStr.split(",");
        if (ArrayUtil.isEmpty((Object[])fileIds) || ArrayUtil.isEmpty((Object[])fileNameList)) {
            throw new ZTBusinessException("\u6587\u4ef6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileIds.length != fileNameList.length) {
            throw new ZTBusinessException("\u6587\u4ef6\u96c6\u5408id\u4e0e\u540d\u79f0\u4e0d\u5339\u914d");
        }
        ArrayList<TChnipmpContractInfoExtendPO.ArgFileInfoBO> result = new ArrayList<TChnipmpContractInfoExtendPO.ArgFileInfoBO>();
        for (int i = 0; i < fileIds.length; ++i) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put("ecmId", fileIds[i]);
                InputStream inputStream = HttpRequest.post((String)this.outFileDownUrl).body(JSON.toJSONString(params)).execute().bodyStream();
                if (inputStream == null) continue;
                String fileUrl = this.upload(inputStream, (String)fileNameList[i]);
                TChnipmpContractInfoExtendPO.ArgFileInfoBO fileInfoBO = new TChnipmpContractInfoExtendPO.ArgFileInfoBO();
                fileInfoBO.setAccessoryName((String)fileNameList[i]);
                fileInfoBO.setAccessoryUrl(fileUrl);
                fileInfoBO.setAttachmentType(1);
                result.add(fileInfoBO);
                continue;
            }
            catch (Exception e) {
                log.error("\u5408\u540c\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25 {}", fileIds[i], (Object)e);
            }
        }
        return result;
    }

    private boolean doAbilityMethod(TChnipmpContractInfoExtendPO contractInfoExtend) {
        List<BaseRspBo> baseRspBos = this.doAbilityMethod(Lists.newArrayList((Object[])new TChnipmpContractInfoExtendPO[]{contractInfoExtend}));
        if (CollectionUtil.isNotEmpty(baseRspBos)) {
            return "0".equals(baseRspBos.get(0).getCode());
        }
        return false;
    }

    private List<BaseRspBo> doAbilityMethod(List<TChnipmpContractInfoExtendPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("\u540c\u6b65\u5408\u540c\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)this.syncIpmpContractUrl, (String)reqStr);
        log.info("\u540c\u6b65\u5408\u540c\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        return JSON.parseArray((String)rspStr, BaseRspBo.class);
    }

    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            this.bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType("IPMP_CONTRACT");
            saveSyncLog.setLastDate(new Date());
            this.bcmSyncLogMapper.insert(saveSyncLog);
        }
    }

    private String upload(InputStream inputStream, String fileName) {
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        String path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, inputStream);
        return this.ossFileUrl + path;
    }

    public BcmIpmpContractSyncTaskServiceImpl(BcmSyncLogMapper bcmSyncLogMapper, TChnipmpContractInfoMapper tChnipmpContractInfoMapper) {
        this.bcmSyncLogMapper = bcmSyncLogMapper;
        this.tChnipmpContractInfoMapper = tChnipmpContractInfoMapper;
    }
}

