/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.dao.BcmIpmpSupplierBankMapper;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TEspSupplierBankMapper;
import com.tydic.bcm.personal.po.BcmIpmpSupplierBankPO;
import com.tydic.bcm.personal.po.TEspSupplierBankPO;
import com.tydic.bcm.personal.po.TEspSupplierBankQueryPO;
import com.tydic.bcm.personal.po.TEspSupplierBankUpdatePO;
import com.tydic.bcm.personal.task.api.BcmIpmpSupplierBankSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmIpmpSyncSupplierBankReqBO;
import com.tydic.bcm.personal.task.bo.BcmIpmpSyncSupplierBankRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmIpmpSupplierBankSyncTaskService"})
public class BcmIpmpSupplierBankSyncTaskServiceImpl
implements BcmIpmpSupplierBankSyncTaskService {
    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;
    @Autowired
    private TEspSupplierBankMapper tEspSupplierBankMapper;
    @Autowired
    private BcmIpmpSupplierBankMapper bcmIpmpSupplierBankMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncIpmpSupplierBank"})
    public BcmIpmpSyncSupplierBankRspBO syncIpmpSupplierBank(@RequestBody BcmIpmpSyncSupplierBankReqBO reqBO) {
        this.sync();
        return BcmRuUtil.success(BcmIpmpSyncSupplierBankRspBO.class);
    }

    private void changeDealResult(List<Long> ids, String dealResult) {
        TEspSupplierBankUpdatePO setPO = new TEspSupplierBankUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        TEspSupplierBankUpdatePO wherePO = new TEspSupplierBankUpdatePO();
        wherePO.setIdList(ids);
        this.tEspSupplierBankMapper.updateBy(setPO, wherePO);
    }

    private void sync() {
        TEspSupplierBankQueryPO qryPO = new TEspSupplierBankQueryPO();
        qryPO.setDealResult("PENDING");
        Page page = new Page(1, this.dealSize.intValue());
        List<TEspSupplierBankPO> prePageList = this.tEspSupplierBankMapper.getPageList(qryPO, (Page<TEspSupplierBankPO>)page);
        ArrayList<TEspSupplierBankPO> pageList = new ArrayList<TEspSupplierBankPO>();
        ArrayList<Long> failIdList = new ArrayList<Long>();
        if (ObjectUtil.isEmpty(prePageList)) {
            return;
        }
        for (TEspSupplierBankPO tEspSupplierBankPO : prePageList) {
            if (ObjectUtil.isEmpty((Object)tEspSupplierBankPO.getBankId())) {
                failIdList.add(tEspSupplierBankPO.getId());
                continue;
            }
            pageList.add(tEspSupplierBankPO);
        }
        List<String> bankIds = pageList.stream().map(a -> a.getBankId()).distinct().collect(Collectors.toList());
        ArrayList<Long> successIdList = new ArrayList<Long>();
        ArrayList<BcmIpmpSupplierBankPO> insertPOList = new ArrayList<BcmIpmpSupplierBankPO>();
        ArrayList<Long> skipIdList = new ArrayList<Long>();
        BcmIpmpSupplierBankPO qryOldPO = new BcmIpmpSupplierBankPO();
        qryOldPO.setBankIds(bankIds);
        List<BcmIpmpSupplierBankPO> oldBankPOList = this.bcmIpmpSupplierBankMapper.getList(qryOldPO);
        Map oldBankMap = oldBankPOList.stream().collect(Collectors.toMap(BcmIpmpSupplierBankPO::getBankId, Function.identity(), (e1, e2) -> e2));
        if (ObjectUtil.isEmpty(oldBankPOList)) {
            for (TEspSupplierBankPO newBankPO : pageList) {
                BcmIpmpSupplierBankPO insertPO = (BcmIpmpSupplierBankPO)JSON.parseObject((String)JSON.toJSONString((Object)newBankPO), BcmIpmpSupplierBankPO.class);
                insertPO.setId(BcmIdUtil.nextId());
                insertPOList.add(insertPO);
                successIdList.add(newBankPO.getId());
            }
        } else {
            for (TEspSupplierBankPO newBankPO : pageList) {
                if (oldBankMap.containsKey(newBankPO.getBankId())) {
                    int newHashCode;
                    BcmIpmpSupplierBankPO oldBankPO = (BcmIpmpSupplierBankPO)oldBankMap.get(newBankPO.getBankId());
                    int oldHashCode = oldBankPO.hashCode();
                    if (oldHashCode == (newHashCode = newBankPO.hashCode())) {
                        skipIdList.add(newBankPO.getId());
                        continue;
                    }
                    BcmIpmpSupplierBankPO setSupBankPO = (BcmIpmpSupplierBankPO)JSON.parseObject((String)JSON.toJSONString((Object)newBankPO), BcmIpmpSupplierBankPO.class);
                    BcmIpmpSupplierBankPO whereSupBankPO = new BcmIpmpSupplierBankPO();
                    whereSupBankPO.setId(oldBankPO.getId());
                    this.bcmIpmpSupplierBankMapper.updateBy(setSupBankPO, whereSupBankPO);
                    successIdList.add(newBankPO.getId());
                    continue;
                }
                BcmIpmpSupplierBankPO insertPO = (BcmIpmpSupplierBankPO)JSON.parseObject((String)JSON.toJSONString((Object)newBankPO), BcmIpmpSupplierBankPO.class);
                insertPO.setId(BcmIdUtil.nextId());
                insertPOList.add(insertPO);
                successIdList.add(newBankPO.getId());
            }
        }
        if (ObjectUtil.isNotEmpty(skipIdList)) {
            this.changeDealResult(skipIdList, "SKIP");
        }
        if (ObjectUtil.isNotEmpty(successIdList)) {
            this.changeDealResult(successIdList, "SUCCESS");
        }
        if (ObjectUtil.isNotEmpty(failIdList)) {
            this.changeDealResult(failIdList, "FAIL");
        }
        if (ObjectUtil.isNotEmpty(insertPOList)) {
            this.bcmIpmpSupplierBankMapper.insertBatch(insertPOList);
        }
        if (page.getTotalPages() > 1) {
            this.sync();
        }
    }
}

