/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpSupplierMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierExtendPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierPO;
import com.tydic.bcm.personal.task.api.BcmIpmpSupplierOrgSyncTaskService;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmIpmpSupplierOrgSyncTaskService"})
public class BcmIpmpSupplierOrgSyncTaskServiceImpl
implements BcmIpmpSupplierOrgSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmIpmpSupplierOrgSyncTaskServiceImpl.class);
    private final BcmSyncLogMapper bcmSyncLogMapper;
    private final TChnipmpSupplierMapper chnipmpSupplierMapper;
    @Value(value="${DEAL_COUNT:100}")
    private Integer dealCount;
    @Value(value="${SYNC_SUPPLIER_ORG_URL:}")
    private String syncSupplierOrgUrl;
    @Value(value="${OUT_FILE_DOWN:url}")
    private String outFileDownUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Resource
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncIpmpSupplierOrg"})
    public void syncIpmpSupplierOrg() {
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType("IPMP_SUPPLIER");
        BcmSyncLogPO bcmSyncLogPO = this.bcmSyncLogMapper.getModelBy(syncLogPO);
        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;
        while (true) {
            boolean success;
            List<TChnipmpSupplierPO> existSupplier;
            Page page = new Page(pageNo, this.dealCount.intValue());
            TChnipmpSupplierExtendPO supplier = new TChnipmpSupplierExtendPO();
            supplier.setDealResult("PENDING");
            supplier.setGtPushDate(pushDate);
            List<TChnipmpSupplierPO> needDealSupplierList = this.chnipmpSupplierMapper.queryAllByLimit(supplier, (Page<TChnipmpSupplierPO>)page);
            if (CollectionUtil.isEmpty(needDealSupplierList)) break;
            List<String> userIds = needDealSupplierList.stream().map(TChnipmpSupplierPO::getCompanyId).collect(Collectors.toList());
            HashMap existSupplierMap = new HashMap();
            if (pushDate != null && CollectionUtil.isNotEmpty(existSupplier = this.chnipmpSupplierMapper.queryLastByCompanyId(userIds, pushDate))) {
                existSupplierMap.putAll(existSupplier.stream().collect(Collectors.toMap(TChnipmpSupplierPO::getCompanyId, Function.identity())));
            }
            ArrayList<TChnipmpSupplierPO> sendList = new ArrayList<TChnipmpSupplierPO>();
            ArrayList<TChnipmpSupplierPO> resultList = new ArrayList<TChnipmpSupplierPO>();
            for (TChnipmpSupplierPO need : needDealSupplierList) {
                need.setDealTime(new Date());
                TChnipmpSupplierPO supplierUserPO = (TChnipmpSupplierPO)existSupplierMap.get(need.getCompanyId());
                if (!need.equals(supplierUserPO)) {
                    if (!BcmIpmpSupplierOrgSyncTaskServiceImpl.isErrorData(need.getQlfEcmId(), need.getQlfEcmName())) {
                        try {
                            HashMap<String, String> params = new HashMap<String, String>(1);
                            params.put("ecmId", need.getQlfEcmId());
                            InputStream inputStream = HttpRequest.post((String)this.outFileDownUrl).body(JSON.toJSONString(params)).execute().bodyStream();
                            if (inputStream != null) {
                                String fileUrl = this.upload(inputStream, need.getQlfEcmName());
                                need.setQlfEcmId(fileUrl);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                        }
                    } else {
                        log.error("\u9700\u8981\u540c\u6b65\u7684\u4f9b\u5e94\u5546\u6570\u636e\u8425\u4e1a\u6267\u7167\u9519\u8bef {}", (Object)JSON.toJSONString((Object)need));
                        need.setQlfEcmId(null);
                    }
                    sendList.add(need);
                    need.setDealResult("SUCCESS");
                } else {
                    need.setDealResult("SKIP");
                }
                resultList.add(need);
            }
            if (CollectionUtil.isNotEmpty(sendList) && !(success = this.doAbilityMethod(sendList))) {
                List failIds = sendList.stream().map(TChnipmpSupplierPO::getId).collect(Collectors.toList());
                resultList.forEach(tChnipmpSupplierPO -> {
                    if (failIds.contains(tChnipmpSupplierPO.getId())) {
                        tChnipmpSupplierPO.setDealResult("FAIL");
                    }
                });
            }
            if (!CollectionUtil.isNotEmpty(resultList)) continue;
            this.chnipmpSupplierMapper.insertOrUpdateBatch(resultList);
        }
        this.finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
    }

    private static boolean isErrorData(String qlfEcmId, String qlfEcmName) {
        if (StrUtil.isBlank((CharSequence)qlfEcmId) || StrUtil.isBlank((CharSequence)qlfEcmName)) {
            return true;
        }
        return !StrUtil.contains((CharSequence)qlfEcmName, (CharSequence)".");
    }

    private boolean doAbilityMethod(List<TChnipmpSupplierPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("\u540c\u6b65\u4f9b\u5e94\u5546\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)this.syncSupplierOrgUrl, (String)reqStr);
        log.info("\u540c\u6b65\u4f9b\u5e94\u5546\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        BaseRspBo baseRspBo = (BaseRspBo)JSON.parseObject((String)rspStr, BaseRspBo.class);
        return "0".equals(baseRspBo.getCode());
    }

    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            this.bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType("IPMP_SUPPLIER");
            saveSyncLog.setLastDate(new Date());
            this.bcmSyncLogMapper.insert(saveSyncLog);
        }
    }

    private String upload(InputStream inputStream, String fileName) {
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        String path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, inputStream);
        return this.ossFileUrl + path;
    }

    public BcmIpmpSupplierOrgSyncTaskServiceImpl(BcmSyncLogMapper bcmSyncLogMapper, TChnipmpSupplierMapper chnipmpSupplierMapper) {
        this.bcmSyncLogMapper = bcmSyncLogMapper;
        this.chnipmpSupplierMapper = chnipmpSupplierMapper;
    }
}

