/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TChnipmpSupplierUserMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierUserExtendPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierUserPO;
import com.tydic.bcm.personal.task.api.BcmIpmpSupplierUserSyncTaskService;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmIpmpSupplierUserSyncTaskService"})
public class BcmIpmpSupplierUserSyncTaskServiceImpl
implements BcmIpmpSupplierUserSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmIpmpSupplierUserSyncTaskServiceImpl.class);
    private final BcmSyncLogMapper bcmSyncLogMapper;
    private final TChnipmpSupplierUserMapper chnipmpSupplierUserMapper;
    @Value(value="${SYNC_SUPPLIER_USER_URL:}")
    private String syncSupplierUserUrl;
    @Value(value="${DEAL_COUNT:100}")
    private Integer dealCount;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncIpmpSupplierUser"})
    public void syncIpmpSupplierUser() {
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType("IPMP_SUPPLIER_USER");
        BcmSyncLogPO bcmSyncLogPO = this.bcmSyncLogMapper.getModelBy(syncLogPO);
        Date pushDate = bcmSyncLogPO != null ? bcmSyncLogPO.getLastDate() : null;
        int pageNo = 1;
        while (true) {
            boolean success;
            List<TChnipmpSupplierUserPO> existSupplierUser;
            Page page = new Page(pageNo, this.dealCount.intValue());
            TChnipmpSupplierUserExtendPO supplierUser = new TChnipmpSupplierUserExtendPO();
            supplierUser.setDealResult("PENDING");
            supplierUser.setGtPushDate(pushDate);
            List<TChnipmpSupplierUserPO> needDealSupplierUserList = this.chnipmpSupplierUserMapper.queryAllByLimit(supplierUser, (Page<TChnipmpSupplierUserPO>)page);
            if (CollectionUtil.isEmpty(needDealSupplierUserList)) break;
            List<String> userIds = needDealSupplierUserList.stream().map(TChnipmpSupplierUserPO::getUserId).collect(Collectors.toList());
            HashMap existSupplierUserMap = new HashMap();
            if (pushDate != null && CollectionUtil.isNotEmpty(existSupplierUser = this.chnipmpSupplierUserMapper.queryLastByUserId(userIds, pushDate))) {
                existSupplierUserMap.putAll(existSupplierUser.stream().collect(Collectors.toMap(TChnipmpSupplierUserPO::getUserId, Function.identity())));
            }
            ArrayList<TChnipmpSupplierUserPO> sendList = new ArrayList<TChnipmpSupplierUserPO>();
            ArrayList<TChnipmpSupplierUserPO> resultList = new ArrayList<TChnipmpSupplierUserPO>();
            for (TChnipmpSupplierUserPO need : needDealSupplierUserList) {
                need.setDealTime(new Date());
                TChnipmpSupplierUserPO supplierUserPO = (TChnipmpSupplierUserPO)existSupplierUserMap.get(need.getUserId());
                if (!need.equals(supplierUserPO)) {
                    sendList.add(need);
                    need.setDealResult("SUCCESS");
                } else {
                    need.setDealResult("SKIP");
                }
                resultList.add(need);
            }
            if (CollectionUtil.isNotEmpty(sendList) && !(success = this.doAbilityMethod(sendList))) {
                List failIds = sendList.stream().map(TChnipmpSupplierUserPO::getId).collect(Collectors.toList());
                resultList.forEach(tChnipmpSupplierUserPO -> {
                    if (failIds.contains(tChnipmpSupplierUserPO.getId())) {
                        tChnipmpSupplierUserPO.setDealResult("FAIL");
                    }
                });
            }
            if (!CollectionUtil.isNotEmpty(resultList)) continue;
            this.chnipmpSupplierUserMapper.insertOrUpdateBatch(resultList);
        }
        this.finishSync(bcmSyncLogPO != null ? bcmSyncLogPO.getId() : null);
    }

    private boolean doAbilityMethod(List<TChnipmpSupplierUserPO> successPOList) {
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("\u540c\u6b65\u4f9b\u5e94\u5546\u7528\u6237\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)this.syncSupplierUserUrl, (String)reqStr);
        log.info("\u540c\u6b65\u4f9b\u5e94\u5546\u7528\u6237\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        BaseRspBo baseRspBo = (BaseRspBo)JSON.parseObject((String)rspStr, BaseRspBo.class);
        return "0".equals(baseRspBo.getCode());
    }

    private void finishSync(Long syncLogId) {
        if (syncLogId != null) {
            BcmSyncLogPO bcmSyncLogPO = new BcmSyncLogPO();
            bcmSyncLogPO.setId(syncLogId);
            bcmSyncLogPO.setLastDate(new Date());
            this.bcmSyncLogMapper.updateById(bcmSyncLogPO);
        } else {
            BcmSyncLogPO saveSyncLog = new BcmSyncLogPO();
            saveSyncLog.setDataType("IPMP_SUPPLIER_USER");
            saveSyncLog.setLastDate(new Date());
            this.bcmSyncLogMapper.insert(saveSyncLog);
        }
    }

    public BcmIpmpSupplierUserSyncTaskServiceImpl(BcmSyncLogMapper bcmSyncLogMapper, TChnipmpSupplierUserMapper chnipmpSupplierUserMapper) {
        this.bcmSyncLogMapper = bcmSyncLogMapper;
        this.chnipmpSupplierUserMapper = chnipmpSupplierUserMapper;
    }
}

