/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.dao.BcmGuwpOrgInfoMapper;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.po.BcmGuwpOrgInfoPO;
import com.tydic.bcm.personal.po.BcmGuwpOrgInfoQueryPO;
import com.tydic.bcm.personal.po.BcmGuwpOrgInfoUpdatePO;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.task.api.BcmOrgSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncOrgReqBO;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncOrgRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmOrgSyncTaskService"})
public class BcmOrgSyncTaskServiceImpl
implements BcmOrgSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmOrgSyncTaskServiceImpl.class);
    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;
    @Autowired
    private BcmGuwpOrgInfoMapper bcmGuwpOrgInfoMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;
    @Value(value="${SYNC_ORG_URL:url}")
    private String syncOrgUrl;
    private static final Integer delPage = 1;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncOrg"})
    public BcmGuwpSyncOrgRspBO syncOrg(@RequestBody BcmGuwpSyncOrgReqBO reqBO) {
        BcmGuwpSyncOrgRspBO rspBO = new BcmGuwpSyncOrgRspBO();
        BcmGuwpOrgInfoQueryPO qryPO = new BcmGuwpOrgInfoQueryPO();
        qryPO.setDealResult("PENDING");
        Page page = new Page(delPage.intValue(), this.dealSize.intValue());
        List<BcmGuwpOrgInfoPO> pageList = this.bcmGuwpOrgInfoMapper.getPageList(qryPO, (Page<BcmGuwpOrgInfoPO>)page);
        if (ObjectUtil.isEmpty(pageList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Date lastDate = pageList.get(0).getPushTime();
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType("GUWP_ORG");
        BcmSyncLogPO bcmSyncLogPO = this.bcmSyncLogMapper.getModelBy(syncLogPO);
        int syncNum = 0;
        if (ObjectUtil.isNotEmpty((Object)bcmSyncLogPO)) {
            qryPO.setPushStartTime(bcmSyncLogPO.getLastDate());
            while (true) {
                Page pageNow;
                if (ObjectUtil.isEmpty(pageList = this.bcmGuwpOrgInfoMapper.getPageList(qryPO, (Page<BcmGuwpOrgInfoPO>)(pageNow = new Page(delPage.intValue(), this.dealSize.intValue()))))) {
                    BcmSyncLogPO updateLogPO = new BcmSyncLogPO();
                    updateLogPO.setId(bcmSyncLogPO.getId());
                    updateLogPO.setLastDate(lastDate);
                    this.bcmSyncLogMapper.updateById(updateLogPO);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    rspBO.setSyncNum(Integer.valueOf(syncNum));
                    return rspBO;
                }
                ArrayList<BcmGuwpOrgInfoPO> successPOList = new ArrayList<BcmGuwpOrgInfoPO>();
                ArrayList<Long> skipIdList = new ArrayList<Long>();
                List<Long> orgIdList = pageList.stream().map(BcmGuwpOrgInfoPO::getOrgId).collect(Collectors.toList());
                Map<Long, BcmGuwpOrgInfoPO> oldOrgMap = this.getOldOrgMap(bcmSyncLogPO.getLastDate(), orgIdList);
                for (BcmGuwpOrgInfoPO newOrgPO : pageList) {
                    BcmGuwpOrgInfoPO oldOrgPO;
                    if (newOrgPO.equals(oldOrgPO = oldOrgMap.get(newOrgPO.getOrgId()))) {
                        skipIdList.add(newOrgPO.getId());
                        continue;
                    }
                    successPOList.add(newOrgPO);
                }
                if (ObjectUtil.isNotEmpty(skipIdList)) {
                    this.changeDealResult(skipIdList, "SKIP");
                }
                if (!ObjectUtil.isNotEmpty(successPOList)) continue;
                this.doAbilityMethod(successPOList, this.syncOrgUrl);
                syncNum += successPOList.size();
            }
        }
        while (true) {
            Page pageNow;
            if (ObjectUtil.isEmpty(pageList = this.bcmGuwpOrgInfoMapper.getPageList(qryPO, (Page<BcmGuwpOrgInfoPO>)(pageNow = new Page(delPage.intValue(), this.dealSize.intValue()))))) {
                BcmSyncLogPO insertLogPO = new BcmSyncLogPO();
                insertLogPO.setId(BcmIdUtil.nextId());
                insertLogPO.setDataType("GUWP_ORG");
                insertLogPO.setLastDate(lastDate);
                this.bcmSyncLogMapper.insert(insertLogPO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setSyncNum(Integer.valueOf(syncNum));
                return rspBO;
            }
            this.doAbilityMethod(pageList, this.syncOrgUrl);
            syncNum += pageList.size();
        }
    }

    private Map<Long, BcmGuwpOrgInfoPO> getOldOrgMap(Date lastDate, List<Long> orgIdList) {
        if (CollectionUtil.isEmpty(orgIdList)) {
            return Collections.emptyMap();
        }
        BcmGuwpOrgInfoQueryPO qryOldPO = new BcmGuwpOrgInfoQueryPO();
        qryOldPO.setDealResult("SUCCESS");
        qryOldPO.setPushTime(lastDate);
        qryOldPO.setOrgIdList(orgIdList);
        List<BcmGuwpOrgInfoPO> oldOrgPOList = this.bcmGuwpOrgInfoMapper.getList(qryOldPO);
        if (CollectionUtil.isEmpty(oldOrgPOList)) {
            return Collections.emptyMap();
        }
        return oldOrgPOList.stream().collect(Collectors.toMap(BcmGuwpOrgInfoPO::getOrgId, Function.identity(), (e1, e2) -> e2));
    }

    private void doAbilityMethod(List<BcmGuwpOrgInfoPO> successPOList, String url) {
        List<Long> idList = successPOList.stream().map(BcmGuwpOrgInfoPO::getId).collect(Collectors.toList());
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("\u540c\u6b65\u673a\u6784\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)url, (String)reqStr);
        log.info("\u540c\u6b65\u673a\u6784\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        BaseRspBo baseRspBo = BcmRuUtil.jss(rspStr, BaseRspBo.class);
        if (baseRspBo == null) {
            this.changeDealResult(idList, "FAIL");
        } else if ("0".equals(baseRspBo.getCode())) {
            this.changeDealResult(idList, "SUCCESS");
        } else {
            this.changeDealResult(idList, "FAIL");
        }
    }

    private void changeDealResult(List<Long> ids, String dealResult) {
        BcmGuwpOrgInfoUpdatePO setPO = new BcmGuwpOrgInfoUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        BcmGuwpOrgInfoUpdatePO wherePO = new BcmGuwpOrgInfoUpdatePO();
        wherePO.setIdList(ids);
        this.bcmGuwpOrgInfoMapper.updateBy(setPO, wherePO);
    }
}

