/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBdInoutbusiclassFmisMapper;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBdInoutbusiclassFmisPO;
import com.tydic.bcm.personal.po.BcmBdInoutbusiclassFmisUpdatePO;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryPaymentProjectInfoPO;
import com.tydic.bcm.personal.task.api.BcmPaymentProjectSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncPaymentProjectReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncPaymentProjectRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmPaymentProjectSyncTaskService"})
public class BcmPaymentProjectSyncTaskServiceImpl
implements BcmPaymentProjectSyncTaskService {
    @Autowired
    private BcmBdInoutbusiclassFmisMapper bcmBdInoutbusiclassFmisMapper;
    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;
    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;
    private static final Integer delPage = 1;
    @Value(value="${virtual.finance.org}")
    private String virtualFinanceOrg;
    @Value(value="${DEAL_COUNT:100}")
    private Integer dealCount;
    private static final Long defaultUserId = 1L;
    private static final String defaultUserName = "\u7cfb\u7edf\u7ba1\u7406\u5458";

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncPaymentProject"})
    public BcmFmisSyncPaymentProjectRspBO syncPaymentProject(@RequestBody BcmFmisSyncPaymentProjectReqBO reqBO) {
        BcmFmisSyncPaymentProjectRspBO rspBO = new BcmFmisSyncPaymentProjectRspBO();
        BcmBdInoutbusiclassFmisPO qryPO = new BcmBdInoutbusiclassFmisPO();
        qryPO.setDealResult("PENDING");
        Page page = new Page(delPage.intValue(), this.dealCount.intValue());
        List<BcmBdInoutbusiclassFmisPO> list = this.bcmBdInoutbusiclassFmisMapper.getPageList(qryPO, (Page<BcmBdInoutbusiclassFmisPO>)page);
        if (ObjectUtil.isEmpty(list)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        int syncNum = 0;
        while (true) {
            Page pageNow;
            List<BcmBdInoutbusiclassFmisPO> pageList;
            if (ObjectUtil.isEmpty(pageList = this.bcmBdInoutbusiclassFmisMapper.getPageList(qryPO, (Page<BcmBdInoutbusiclassFmisPO>)(pageNow = new Page(delPage.intValue(), this.dealCount.intValue()))))) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setSyncNum(Integer.valueOf(syncNum));
                return rspBO;
            }
            List<String> projectIdList = pageList.stream().map(BcmBdInoutbusiclassFmisPO::getPkInoutbusiclass).collect(Collectors.toList());
            List<String> orgCodeList = pageList.stream().map(BcmBdInoutbusiclassFmisPO::getPkOrg).collect(Collectors.toList());
            BcmQueryPaymentProjectInfoPO qryProjectPO = new BcmQueryPaymentProjectInfoPO();
            qryProjectPO.setProjectIdList(projectIdList);
            qryProjectPO.setOrgIdList(orgCodeList);
            qryProjectPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            List<BcmPaymentProjectInfoPO> projectInfoPOS = this.bcmPaymentProjectInfoMapper.getList(qryProjectPO);
            ArrayList<BcmPaymentProjectInfoPO> batchInsertPOList = new ArrayList<BcmPaymentProjectInfoPO>();
            if (ObjectUtil.isNotEmpty(projectInfoPOS)) {
                Map updateMap = projectInfoPOS.stream().collect(Collectors.toMap(info -> info.getProjectId() + "-" + info.getFinancialOrgId(), Function.identity()));
                for (BcmBdInoutbusiclassFmisPO item : pageList) {
                    BcmOrgOrgsFmisPO nowOrgPO = this.bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty((Object)nowOrgPO) && !this.virtualFinanceOrg.equals(item.getPkOrg())) {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    if (!updateMap.containsKey(item.getPkInoutbusiclass() + "-" + item.getPkOrg())) {
                        BcmPaymentProjectInfoPO insertPO = this.setInsertPO(item, nowOrgPO);
                        batchInsertPOList.add(insertPO);
                        this.updateStatus(item, "SUCCESS");
                        continue;
                    }
                    BcmPaymentProjectInfoPO sourcePO = (BcmPaymentProjectInfoPO)updateMap.get(item.getPkInoutbusiclass() + "-" + item.getPkOrg());
                    BcmPaymentProjectInfoPO setPO = new BcmPaymentProjectInfoPO();
                    setPO.setProjectName(item.getName());
                    setPO.setProjectCode(item.getCode());
                    setPO.setStatus(item.getEnablestate());
                    setPO.setFinancialOrgId(item.getPkOrg());
                    this.virtualFinanceOrg(setPO, nowOrgPO);
                    if (!setPO.equals(sourcePO)) {
                        setPO.setUpdateUserId(defaultUserId);
                        setPO.setUpdateUserName(defaultUserName);
                        setPO.setUpdateTime(new Date());
                        if (this.virtualFinanceOrg.equals(item.getPkOrg())) {
                            setPO.setPublicFlag(2);
                        } else {
                            setPO.setPublicFlag(1);
                        }
                        BcmPaymentProjectInfoPO wherePO = new BcmPaymentProjectInfoPO();
                        wherePO.setId(sourcePO.getId());
                        this.bcmPaymentProjectInfoMapper.updateBy(setPO, wherePO);
                        this.updateStatus(item, "SUCCESS");
                        continue;
                    }
                    this.updateStatus(item, "SKIP");
                }
            } else {
                for (BcmBdInoutbusiclassFmisPO item : pageList) {
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    BcmOrgOrgsFmisPO nowOrgPO = this.bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty((Object)nowOrgPO) && !this.virtualFinanceOrg.equals(item.getPkOrg())) {
                        this.updateStatus(item, "FAIL");
                        continue;
                    }
                    BcmPaymentProjectInfoPO insertPO = this.setInsertPO(item, nowOrgPO);
                    batchInsertPOList.add(insertPO);
                    this.updateStatus(item, "SUCCESS");
                }
            }
            if (!ObjectUtil.isNotEmpty(batchInsertPOList)) continue;
            int insertNum = this.bcmPaymentProjectInfoMapper.insertBatch(batchInsertPOList);
            syncNum += insertNum;
        }
    }

    private void updateStatus(BcmBdInoutbusiclassFmisPO item, String dealResult) {
        BcmBdInoutbusiclassFmisUpdatePO fmisSetPO = new BcmBdInoutbusiclassFmisUpdatePO();
        fmisSetPO.setDealResult(dealResult);
        fmisSetPO.setDealTime(new Date());
        BcmBdInoutbusiclassFmisUpdatePO fmisWherePO = new BcmBdInoutbusiclassFmisUpdatePO();
        fmisWherePO.setId(item.getId());
        this.bcmBdInoutbusiclassFmisMapper.updateBy(fmisSetPO, fmisWherePO);
    }

    private BcmPaymentProjectInfoPO setInsertPO(BcmBdInoutbusiclassFmisPO item, BcmOrgOrgsFmisPO nowOrgPO) {
        BcmPaymentProjectInfoPO insertPO = new BcmPaymentProjectInfoPO();
        insertPO.setId(BcmIdUtil.nextId());
        insertPO.setProjectId(item.getPkInoutbusiclass());
        insertPO.setProjectCode(item.getCode());
        insertPO.setProjectName(item.getName());
        insertPO.setStatus(item.getEnablestate());
        this.virtualFinanceOrg(insertPO, nowOrgPO);
        insertPO.setCreateUserId(defaultUserId);
        insertPO.setCreateUserName(defaultUserName);
        insertPO.setCreateTime(new Date());
        insertPO.setUpdateUserId(defaultUserId);
        insertPO.setUpdateUserName(defaultUserName);
        insertPO.setUpdateTime(new Date());
        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        if (this.virtualFinanceOrg.equals(item.getPkOrg())) {
            insertPO.setPublicFlag(2);
        } else {
            insertPO.setPublicFlag(1);
        }
        return insertPO;
    }

    private void virtualFinanceOrg(BcmPaymentProjectInfoPO bcmPaymentProjectInfoPO, BcmOrgOrgsFmisPO nowOrgPO) {
        if (nowOrgPO != null) {
            bcmPaymentProjectInfoPO.setFinancialOrgId(nowOrgPO.getPkOrg());
            bcmPaymentProjectInfoPO.setFinancialOrgCode(nowOrgPO.getCode());
            bcmPaymentProjectInfoPO.setFinancialOrgName(nowOrgPO.getName());
        } else {
            bcmPaymentProjectInfoPO.setFinancialOrgId(this.virtualFinanceOrg);
            bcmPaymentProjectInfoPO.setFinancialOrgCode(this.virtualFinanceOrg);
            bcmPaymentProjectInfoPO.setFinancialOrgName("\u865a\u62df\u8d22\u52a1\u7ec4\u7ec7");
        }
    }
}

