/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.dao.BcmUserOrgGuwpMapper;
import com.tydic.bcm.personal.po.BcmUserOrgGuwpPO;
import com.tydic.bcm.personal.po.BcmUserOrgGuwpQueryPO;
import com.tydic.bcm.personal.po.BcmUserOrgGuwpUpdatePO;
import com.tydic.bcm.personal.task.api.BcmPositionSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncPositionReqBO;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncPositionRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmPositionSyncTaskService"})
public class BcmPositionSyncTaskServiceImpl
implements BcmPositionSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmPositionSyncTaskServiceImpl.class);
    @Autowired
    private BcmUserOrgGuwpMapper bcmUserOrgGuwpMapper;
    @Value(value="${DEAL_POSITION_COUNT:100}")
    private Integer dealCount;
    @Value(value="${SYNC_CUST_PART_ALL_URL:}")
    private String syncCustPartAllUrl;
    @Value(value="${FINISH_PART_SYNC:}")
    private String finishPartSync;
    private static final Integer delPage = 1;

    @Async(value="position-sync-thread-pool")
    @PostMapping(value={"syncPosition"})
    public BcmGuwpSyncPositionRspBO syncPosition(@RequestBody BcmGuwpSyncPositionReqBO reqBO) {
        BcmGuwpSyncPositionRspBO rspBO = new BcmGuwpSyncPositionRspBO();
        BcmUserOrgGuwpQueryPO qryPO = new BcmUserOrgGuwpQueryPO();
        qryPO.setDealResult("PENDING");
        Page page = new Page(delPage.intValue(), this.dealCount.intValue());
        List<BcmUserOrgGuwpPO> pageList = this.bcmUserOrgGuwpMapper.getPageList(qryPO, (Page<BcmUserOrgGuwpPO>)page);
        if (ObjectUtil.isEmpty(pageList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        int syncNum = 0;
        while (true) {
            Page pageNow;
            if (ObjectUtil.isEmpty(pageList = this.bcmUserOrgGuwpMapper.getPageList(qryPO, (Page<BcmUserOrgGuwpPO>)(pageNow = new Page(delPage.intValue(), this.dealCount.intValue()))))) {
                JSONObject reqStr = new JSONObject();
                reqStr.put("batchId", (Object)this.formatDateTime(new Date()));
                log.info("\u540c\u6b65\u7ed3\u675f\u4e4b\u540e\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u4f20\u7ed3\u675f\u6807\u8bc6\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr.toJSONString());
                String rspStr = HttpUtil.post((String)this.finishPartSync, (String)reqStr.toJSONString());
                log.info("\u540c\u6b65\u7ed3\u675f\u4e4b\u540e\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u4f20\u7ed3\u675f\u6807\u8bc6\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setSyncNum(Integer.valueOf(syncNum));
                return rspBO;
            }
            this.doAbilityMethod(pageList, this.syncCustPartAllUrl);
            syncNum += pageList.size();
        }
    }

    private void doAbilityMethod(List<BcmUserOrgGuwpPO> successPOList, String url) {
        List<Long> idList = successPOList.stream().map(BcmUserOrgGuwpPO::getId).collect(Collectors.toList());
        JSONObject reqStr = new JSONObject();
        reqStr.put("batchId", (Object)this.formatDateTime(new Date()));
        reqStr.put("syncList", successPOList);
        log.info("\u7528\u6237\u517c\u804c\u540c\u6b65\u4efb\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)url, (String)reqStr.toJSONString());
        log.info("\u7528\u6237\u517c\u804c\u540c\u6b65\u4efb\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        BaseRspBo baseRspBo = BcmRuUtil.jss(rspStr, BaseRspBo.class);
        if (baseRspBo == null) {
            this.changeDealResult(idList, "FAIL");
        } else if ("0".equals(baseRspBo.getCode())) {
            this.changeDealResult(idList, "SUCCESS");
        } else {
            this.changeDealResult(idList, "FAIL");
        }
    }

    private void changeDealResult(List<Long> ids, String dealResult) {
        BcmUserOrgGuwpUpdatePO setPO = new BcmUserOrgGuwpUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        BcmUserOrgGuwpUpdatePO wherePO = new BcmUserOrgGuwpUpdatePO();
        wherePO.setIdList(ids);
        this.bcmUserOrgGuwpMapper.updateBy(setPO, wherePO);
    }

    private String formatDateTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }
}

