/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBillTellerMapper;
import com.tydic.bcm.personal.dao.BcmSmUserMapper;
import com.tydic.bcm.personal.po.BcmBillTellerPO;
import com.tydic.bcm.personal.po.BcmQueryBillTellerPO;
import com.tydic.bcm.personal.po.BcmQuerySmUserPO;
import com.tydic.bcm.personal.po.BcmSmUserPO;
import com.tydic.bcm.personal.task.api.BcmSmUserSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmSmUserSyncTaskReqBO;
import com.tydic.bcm.personal.task.bo.BcmSmUserSyncTaskRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmSmUserSyncTaskService"})
public class BcmSmUserSyncTaskServiceImpl
implements BcmSmUserSyncTaskService {
    @Autowired
    private BcmSmUserMapper bcmSmUserMapper;
    @Autowired
    private BcmBillTellerMapper bcmBillTellerMapper;
    @Value(value="${dealSize:100}")
    private Integer dealSize;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncSmUser"})
    public BcmSmUserSyncTaskRspBO syncSmUser(@RequestBody BcmSmUserSyncTaskReqBO reqBO) {
        this.sync();
        return BcmRuUtil.success(BcmSmUserSyncTaskRspBO.class);
    }

    private void sync() {
        Page<BcmSmUserPO> syncPage = this.getSmUser();
        List syncList = syncPage.getResult();
        if (CollectionUtils.isEmpty((Collection)syncList)) {
            return;
        }
        ArrayList<Long> successIdList = new ArrayList<Long>(syncList.size());
        Map<String, BcmBillTellerPO> thanMap = this.getBillTellerMap(syncList);
        if (CollectionUtils.isEmpty(thanMap)) {
            this.addBillTeller(syncList);
            successIdList.addAll(syncList.stream().map(BcmSmUserPO::getId).collect(Collectors.toList()));
        } else {
            ArrayList<Long> skipIdList = new ArrayList<Long>(syncList.size());
            ArrayList<BcmSmUserPO> addList = new ArrayList<BcmSmUserPO>(syncList.size());
            ArrayList<BcmBillTellerPO> updateList = new ArrayList<BcmBillTellerPO>(syncList.size());
            for (BcmSmUserPO smUserPO : syncList) {
                BcmBillTellerPO than = thanMap.get(smUserPO.getCuserId());
                if (than == null) {
                    addList.add(smUserPO);
                    successIdList.add(smUserPO.getId());
                    continue;
                }
                BcmBillTellerPO newThan = this.setBillTeller(smUserPO);
                Long id = than.getId();
                than.setId(null);
                than.setCreateTime(null);
                than.setUpdateTime(null);
                than.setBillTellerId(null);
                if (than.hashCode() != newThan.hashCode()) {
                    newThan.setId(id);
                    newThan.setUpdateTime(smUserPO.getPushTime());
                    updateList.add(newThan);
                    successIdList.add(smUserPO.getId());
                    continue;
                }
                skipIdList.add(smUserPO.getId());
            }
            if (!CollectionUtils.isEmpty(addList)) {
                this.addBillTeller(addList);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.bcmBillTellerMapper.updateBatch(updateList);
            }
            if (!CollectionUtils.isEmpty(skipIdList)) {
                this.updateSmUser(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
            }
        }
        if (!CollectionUtils.isEmpty(successIdList)) {
            this.updateSmUser(successIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (syncPage.getTotalPages() > 1) {
            this.sync();
        }
    }

    private void addBillTeller(List<BcmSmUserPO> syncList) {
        ArrayList<BcmBillTellerPO> list = new ArrayList<BcmBillTellerPO>(syncList.size());
        for (BcmSmUserPO smUserPO : syncList) {
            BcmBillTellerPO po = this.setBillTeller(smUserPO);
            po.setBillTellerId(smUserPO.getCuserId());
            po.setId(smUserPO.getId());
            po.setCreateTime(smUserPO.getPushTime());
            po.setUpdateTime(smUserPO.getPushTime());
            list.add(po);
        }
        this.bcmBillTellerMapper.insertBatch(list);
    }

    private Page<BcmSmUserPO> getSmUser() {
        BcmSmUserPO bcmSmUserPO = new BcmSmUserPO();
        bcmSmUserPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        Page page = new Page(1, this.dealSize.intValue());
        List<BcmSmUserPO> pageList = this.bcmSmUserMapper.getPageList(bcmSmUserPO, (Page<BcmSmUserPO>)page);
        page.setResult(pageList);
        return page;
    }

    private BcmBillTellerPO setBillTeller(BcmSmUserPO smUserPO) {
        BcmBillTellerPO po = new BcmBillTellerPO();
        po.setBillTellerCode(smUserPO.getUserCode());
        po.setBillTellerName(smUserPO.getUserName());
        po.setBillTellerOrgId(smUserPO.getOaOrg());
        po.setBillTellerOrgCode(smUserPO.getOaOrg());
        po.setBillTellerOrgName(smUserPO.getOrgName());
        po.setBillOrgId(smUserPO.getOaDept());
        po.setBillOrgCode(smUserPO.getOaDept());
        po.setBillOrgName(smUserPO.getDeptName());
        po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        return po;
    }

    private Map<String, BcmBillTellerPO> getBillTellerMap(List<BcmSmUserPO> syncList) {
        BcmQueryBillTellerPO bcmQueryBillTellerPO = new BcmQueryBillTellerPO();
        bcmQueryBillTellerPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryBillTellerPO.setBillTellerIdList(syncList.stream().map(BcmSmUserPO::getCuserId).collect(Collectors.toList()));
        List<BcmBillTellerPO> list = this.bcmBillTellerMapper.getList(bcmQueryBillTellerPO);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(BcmBillTellerPO::getBillTellerId, o -> o, (k1, k2) -> k2));
    }

    private void updateSmUser(List<Long> idList, String dealResult) {
        BcmQuerySmUserPO bcmQuerySmUserPO = new BcmQuerySmUserPO();
        bcmQuerySmUserPO.setIdList(idList);
        bcmQuerySmUserPO.setDealResult(dealResult);
        bcmQuerySmUserPO.setDealTime(new Date());
        this.bcmSmUserMapper.updateBatch(bcmQuerySmUserPO);
    }
}

