/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.BcmUserInfoIpspMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.BcmUserInfoIpspPO;
import com.tydic.bcm.personal.po.BcmUserInfoIpspQueryPO;
import com.tydic.bcm.personal.po.BcmUserInfoIpspUpdatePO;
import com.tydic.bcm.personal.task.api.BcmUserSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncUserReqBO;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncUserRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.task.api.BcmUserSyncTaskService"})
public class BcmUserSyncTaskServiceImpl
implements BcmUserSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmUserSyncTaskServiceImpl.class);
    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;
    @Autowired
    private BcmUserInfoIpspMapper bcmUserInfoIpspMapper;
    @Value(value="${DEAL_USER_COUNT:100}")
    private Integer dealCount;
    @Value(value="${SYNC_USER_ALL_URL:}")
    private String syncUserAllUrl;
    private static final Integer delPage = 1;

    @Async(value="global-thread-pool")
    @PostMapping(value={"syncUser"})
    public BcmGuwpSyncUserRspBO syncUser(@RequestBody BcmGuwpSyncUserReqBO reqBO) {
        BcmGuwpSyncUserRspBO rspBO = new BcmGuwpSyncUserRspBO();
        BcmUserInfoIpspQueryPO qryPO = new BcmUserInfoIpspQueryPO();
        qryPO.setDealResult("PENDING");
        Page page = new Page(delPage.intValue(), this.dealCount.intValue());
        List<BcmUserInfoIpspPO> pageList = this.bcmUserInfoIpspMapper.getPageList(qryPO, (Page<BcmUserInfoIpspPO>)page);
        if (ObjectUtil.isEmpty(pageList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Date lastDate = pageList.get(0).getPushTime();
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType("GUWP_USER");
        BcmSyncLogPO bcmSyncLogPO = this.bcmSyncLogMapper.getModelBy(syncLogPO);
        int syncNum = 0;
        if (ObjectUtil.isNotEmpty((Object)bcmSyncLogPO)) {
            qryPO.setPushStartTime(bcmSyncLogPO.getLastDate());
            while (true) {
                Page pageNow;
                if (ObjectUtil.isEmpty(pageList = this.bcmUserInfoIpspMapper.getPageList(qryPO, (Page<BcmUserInfoIpspPO>)(pageNow = new Page(delPage.intValue(), this.dealCount.intValue()))))) {
                    BcmSyncLogPO updateLogPO = new BcmSyncLogPO();
                    updateLogPO.setId(bcmSyncLogPO.getId());
                    updateLogPO.setLastDate(lastDate);
                    this.bcmSyncLogMapper.updateById(updateLogPO);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    rspBO.setSyncNum(Integer.valueOf(syncNum));
                    return rspBO;
                }
                ArrayList<BcmUserInfoIpspPO> successPOList = new ArrayList<BcmUserInfoIpspPO>();
                ArrayList<Long> skipIdList = new ArrayList<Long>();
                List<Long> userIdList = pageList.stream().map(BcmUserInfoIpspPO::getUserId).collect(Collectors.toList());
                Map<Long, BcmUserInfoIpspPO> oldUserMap = this.getOldUserMap(bcmSyncLogPO.getLastDate(), userIdList);
                for (BcmUserInfoIpspPO newUserPO : pageList) {
                    BcmUserInfoIpspPO oldUserPO;
                    if (newUserPO.equals(oldUserPO = oldUserMap.get(newUserPO.getUserId()))) {
                        skipIdList.add(newUserPO.getId());
                        continue;
                    }
                    successPOList.add(newUserPO);
                }
                if (ObjectUtil.isNotEmpty(skipIdList)) {
                    this.changeDealResult(skipIdList, "SKIP");
                }
                if (!ObjectUtil.isNotEmpty(successPOList)) continue;
                this.doAbilityMethod(successPOList, this.syncUserAllUrl);
                syncNum += successPOList.size();
            }
        }
        while (true) {
            Page pageNow;
            if (ObjectUtil.isEmpty(pageList = this.bcmUserInfoIpspMapper.getPageList(qryPO, (Page<BcmUserInfoIpspPO>)(pageNow = new Page(delPage.intValue(), this.dealCount.intValue()))))) {
                BcmSyncLogPO insertLogPO = new BcmSyncLogPO();
                insertLogPO.setId(BcmIdUtil.nextId());
                insertLogPO.setDataType("GUWP_USER");
                insertLogPO.setLastDate(lastDate);
                this.bcmSyncLogMapper.insert(insertLogPO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setSyncNum(Integer.valueOf(syncNum));
                return rspBO;
            }
            this.doAbilityMethod(pageList, this.syncUserAllUrl);
            syncNum += pageList.size();
        }
    }

    private Map<Long, BcmUserInfoIpspPO> getOldUserMap(Date lastDate, List<Long> userIdList) {
        if (CollectionUtil.isEmpty(userIdList)) {
            return Collections.emptyMap();
        }
        BcmUserInfoIpspQueryPO qryOldPO = new BcmUserInfoIpspQueryPO();
        qryOldPO.setDealResult("SUCCESS");
        qryOldPO.setPushTime(lastDate);
        qryOldPO.setUserIdList(userIdList);
        List<BcmUserInfoIpspPO> oldUserPOList = this.bcmUserInfoIpspMapper.getList(qryOldPO);
        if (CollectionUtil.isEmpty(oldUserPOList)) {
            return Collections.emptyMap();
        }
        return oldUserPOList.stream().collect(Collectors.toMap(BcmUserInfoIpspPO::getUserId, Function.identity(), (e1, e2) -> e2));
    }

    private void doAbilityMethod(List<BcmUserInfoIpspPO> successPOList, String url) {
        List<Long> idList = successPOList.stream().map(BcmUserInfoIpspPO::getId).collect(Collectors.toList());
        String reqStr = JSONObject.toJSONString(successPOList);
        log.info("\u540c\u6b65\u7528\u6237\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = HttpUtil.post((String)url, (String)reqStr);
        log.info("\u540c\u6b65\u7528\u6237\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        BaseRspBo baseRspBo = BcmRuUtil.jss(rspStr, BaseRspBo.class);
        if (baseRspBo == null) {
            this.changeDealResult(idList, "FAIL");
        } else if ("0".equals(baseRspBo.getCode())) {
            this.changeDealResult(idList, "SUCCESS");
        } else {
            this.changeDealResult(idList, "FAIL");
        }
    }

    private void changeDealResult(List<Long> ids, String dealResult) {
        BcmUserInfoIpspUpdatePO setPO = new BcmUserInfoIpspUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        BcmUserInfoIpspUpdatePO wherePO = new BcmUserInfoIpspUpdatePO();
        wherePO.setIdList(ids);
        this.bcmUserInfoIpspMapper.updateBy(setPO, wherePO);
    }
}

