/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.BewgFscBillInvoiceSaveService;
import com.tydic.dyc.fsc.bo.BewgFscBillInvoiceSaveReqBO;
import com.tydic.dyc.fsc.bo.BewgFscBillInvoiceSaveRspBO;
import com.tydic.dyc.fsc.bo.BewgFscInvoiceInfoBO;
import com.tydic.dyc.fsc.bo.DycInvoiceItemBO;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceSaveAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSaveAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSaveAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcLoginNameCompanAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginNameCompanAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginNameCompanAbilityRspBO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BewgFscBillInvoiceSaveServiceImpl
implements BewgFscBillInvoiceSaveService {
    private static final Logger log = LoggerFactory.getLogger(BewgFscBillInvoiceSaveServiceImpl.class);
    @Autowired
    private FscBillInvoiceSaveAbilityService fscBillInvoiceSaveAbilityService;
    @Autowired
    private UmcLoginNameCompanAbilityService umcLoginNameCompanAbilityService;

    public BewgFscBillInvoiceSaveRspBO dealBillInvoiceSave(BewgFscBillInvoiceSaveReqBO reqBO) {
        this.validateParam(reqBO);
        this.setLoginValue(reqBO);
        FscBillInvoiceSaveAbilityReqBO fscBillInvoiceSaveAbilityReqBO = new FscBillInvoiceSaveAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscBillInvoiceSaveAbilityReqBO);
        FscBillInvoiceSaveAbilityRspBO fscBillInvoiceSaveAbilityRspBO = this.fscBillInvoiceSaveAbilityService.dealInvoiceSave(fscBillInvoiceSaveAbilityReqBO);
        if (!"0000".equals(fscBillInvoiceSaveAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(fscBillInvoiceSaveAbilityRspBO.getRespDesc());
        }
        return new BewgFscBillInvoiceSaveRspBO();
    }

    private void setLoginValue(BewgFscBillInvoiceSaveReqBO reqBO) {
        if (StringUtils.hasText((String)reqBO.getName()) && null == reqBO.getUserId()) {
            UmcLoginNameCompanAbilityReqBO abilityReqBO = new UmcLoginNameCompanAbilityReqBO();
            abilityReqBO.setLoginName(reqBO.getName());
            log.debug("\u8d22\u52a1\u56de\u8c03\u8bbe\u7f6e\u767b\u9646\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)abilityReqBO));
            UmcLoginNameCompanAbilityRspBO abilityRspBO = this.umcLoginNameCompanAbilityService.qryLoginList(abilityReqBO);
            log.debug("\u8d22\u52a1\u56de\u8c03\u8bbe\u7f6e\u767b\u9646\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)abilityRspBO));
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                // empty if block
            }
            reqBO.setOrgId(abilityRspBO.getOrgId());
            reqBO.setOrgName(abilityRspBO.getOrgName());
            reqBO.setCompanyId(abilityRspBO.getCompanyId());
            reqBO.setCompanyName(abilityRspBO.getCompanyName());
            reqBO.setUserId(abilityRspBO.getUserId());
            reqBO.setName(abilityRspBO.getName());
        }
    }

    private void validateParam(BewgFscBillInvoiceSaveReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getName())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscInvoiceInfoBOs())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BewgFscInvoiceInfoBO bo : reqBO.getFscInvoiceInfoBOs()) {
            if (!StringUtils.hasText((String)bo.getBillDate())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.billDate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == bo.getTaxAmt()) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.taxAmt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == bo.getAmt()) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.amt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == bo.getUntaxAmt()) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.untaxAmt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getInvoiceNo())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getInvoiceCode())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getBuyName())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.buyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getTaxNo())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.taxNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getBank())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.bank\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)bo.getAddress())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.address\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)bo.getInvoiceItemBOS())) {
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (DycInvoiceItemBO bo2 : bo.getInvoiceItemBOS()) {
                if (null == bo2.getFscOrderItemId()) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.fscOrderItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)bo2.getSkuName())) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.skuName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)bo2.getSpec())) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.spec\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == bo2.getTaxAmt()) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.taxAmt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)bo2.getUnit())) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.unit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)bo2.getTaxCode())) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.taxCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == bo2.getNum()) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.num\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == bo2.getPrice()) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.price\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == bo2.getAmt()) {
                    throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.amt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != bo2.getUntaxAmt()) continue;
                throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010fscInvoiceInfoBOs.invoiceItemBOS.untaxAmt\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

