/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.BewgFscBillOrderCheckService;
import com.tydic.dyc.fsc.bo.BewgFscBillOrderCheckReqBO;
import com.tydic.dyc.fsc.bo.BewgFscBillOrderCheckRspBO;
import com.tydic.dyc.fsc.bo.DycrelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BewgFscBillOrderCheckServiceImpl
implements BewgFscBillOrderCheckService {
    private static final Logger log = LoggerFactory.getLogger(BewgFscBillOrderCheckServiceImpl.class);
    private static final Integer BUND = 1;
    private static final Integer TAB_ID = 80013;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    public BewgFscBillOrderCheckRspBO dealOrderCheck(BewgFscBillOrderCheckReqBO reqBO) {
        BewgFscBillOrderCheckRspBO bewgFscBillOrderCheckRspBO = new BewgFscBillOrderCheckRspBO();
        if (reqBO.getRelOrderList().size() == 1) {
            bewgFscBillOrderCheckRspBO.setBundlFlag(BUND);
            return bewgFscBillOrderCheckRspBO;
        }
        this.val(reqBO);
        List relOrderList = reqBO.getRelOrderList();
        List acceptIdList = relOrderList.stream().map(DycrelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBo = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBo.setInspectionVoucherIdList(acceptIdList);
        uocInspectionDetailsListPageQueryReqBo.setIsAfterSales(Boolean.valueOf(false));
        uocInspectionDetailsListPageQueryReqBo.setTabId(TAB_ID);
        uocInspectionDetailsListPageQueryReqBo.setPageSize(-1);
        uocInspectionDetailsListPageQueryReqBo.setIsUpStream(Boolean.valueOf(false));
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocInspectionDetailsListPageQueryReqBo));
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBo);
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inspectionDetailsList));
        if (!"0000".equals(inspectionDetailsList.getRespCode())) {
            throw new ZTBusinessException(inspectionDetailsList.getRespDesc());
        }
        List uocInspectionDetailsListBos = inspectionDetailsList.getRows();
        if (CollectionUtils.isEmpty((Collection)uocInspectionDetailsListBos)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u8fd4\u56de\u9a8c\u6536\u5355\u5217\u8868\u4e3a\u7a7a");
        }
        Map<Long, DycrelOrderBO> longDycRelOrderBoMap = this.assembleMap(uocInspectionDetailsListBos, reqBO);
        this.checkOrderParam(longDycRelOrderBoMap, reqBO);
        bewgFscBillOrderCheckRspBO.setBundlFlag(BUND);
        return bewgFscBillOrderCheckRspBO;
    }

    private void val(BewgFscBillOrderCheckReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRelOrderList())) {
            throw new ZTBusinessException("\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
    }

    private Map<Long, DycrelOrderBO> assembleMap(List<UocInspectionDetailsListBO> uocInspectionDetailsListBos, BewgFscBillOrderCheckReqBO reqBO) {
        HashMap<Long, DycrelOrderBO> dycRelOrderBoHashMap = new HashMap<Long, DycrelOrderBO>(16);
        for (UocInspectionDetailsListBO row : uocInspectionDetailsListBos) {
            DycrelOrderBO dycrelOrderBo = new DycrelOrderBO();
            dycrelOrderBo.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
            dycrelOrderBo.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
            dycrelOrderBo.setSupplierCode(row.getSupNo());
            dycrelOrderBo.setPurchaserCode(row.getPurNo());
            dycrelOrderBo.setPurchaseOrderNo(row.getPurchaseVoucherNo());
            dycrelOrderBo.setSaleOrderNo(row.getSaleVoucherNo());
            dycrelOrderBo.setTradeMode(row.getTradeMode());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getSaleVoucherNo());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getPurchaseVoucherNo());
            }
            dycRelOrderBoHashMap.put(dycrelOrderBo.getAcceptOrderId(), dycrelOrderBo);
        }
        return dycRelOrderBoHashMap;
    }

    private void checkOrderParam(Map<Long, DycrelOrderBO> longDycRelOrderBOMap, BewgFscBillOrderCheckReqBO reqBO) {
        DycrelOrderBO dycrelOrderBO = longDycRelOrderBOMap.get(((DycrelOrderBO)reqBO.getRelOrderList().get(0)).getAcceptOrderId());
        if (null == dycrelOrderBO) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + ((DycrelOrderBO)reqBO.getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (Map.Entry<Long, DycrelOrderBO> longDycRelOrderBoEntry : longDycRelOrderBOMap.entrySet()) {
            if (dycrelOrderBO.getTradeMode().equals(longDycRelOrderBoEntry.getValue().getTradeMode())) continue;
            throw new ZTBusinessException("\u8ba2\u5355\u4f9b\u5e94\u6a21\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
        }
    }
}

