/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.BewgFscBillOrderInvoiceConformService;
import com.tydic.dyc.fsc.bo.BewgFscBillOrderInvoiceConformReqBO;
import com.tydic.dyc.fsc.bo.BewgFscBillOrderInvoiceConformRspBO;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceConformAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceConformAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceConformAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcLoginNameCompanAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginNameCompanAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginNameCompanAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BewgFscBillOrderInvoiceConformServiceImpl
implements BewgFscBillOrderInvoiceConformService {
    private static final Logger log = LoggerFactory.getLogger(BewgFscBillOrderInvoiceConformServiceImpl.class);
    @Autowired
    private FscBillOrderInvoiceConformAbilityService fscBillOrderInvoiceConformAbilityService;
    @Autowired
    private UmcLoginNameCompanAbilityService umcLoginNameCompanAbilityService;

    public BewgFscBillOrderInvoiceConformRspBO dealOrderInvoiceConform(BewgFscBillOrderInvoiceConformReqBO reqBO) {
        BewgFscBillOrderInvoiceConformRspBO rsp = new BewgFscBillOrderInvoiceConformRspBO();
        this.validateParam(reqBO);
        this.setLoginValue(reqBO);
        FscBillOrderInvoiceConformAbilityReqBO fscBillOrderInvoiceConformAbilityReqBO = new FscBillOrderInvoiceConformAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscBillOrderInvoiceConformAbilityReqBO);
        FscBillOrderInvoiceConformAbilityRspBO fscBillOrderInvoiceConformAbilityRspBO = this.fscBillOrderInvoiceConformAbilityService.dealOrderInvoiceConform(fscBillOrderInvoiceConformAbilityReqBO);
        if (!"0000".equals(fscBillOrderInvoiceConformAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(fscBillOrderInvoiceConformAbilityRspBO.getRespDesc());
        }
        return new BewgFscBillOrderInvoiceConformRspBO();
    }

    private void setLoginValue(BewgFscBillOrderInvoiceConformReqBO reqBO) {
        if (StringUtils.hasText((String)reqBO.getName()) && null == reqBO.getUserId()) {
            UmcLoginNameCompanAbilityReqBO abilityReqBO = new UmcLoginNameCompanAbilityReqBO();
            abilityReqBO.setLoginName(reqBO.getName());
            log.debug("\u8d22\u52a1\u56de\u8c03\u8bbe\u7f6e\u767b\u9646\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)abilityReqBO));
            UmcLoginNameCompanAbilityRspBO abilityRspBO = this.umcLoginNameCompanAbilityService.qryLoginList(abilityReqBO);
            log.debug("\u8d22\u52a1\u56de\u8c03\u8bbe\u7f6e\u767b\u9646\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)abilityRspBO));
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                // empty if block
            }
            reqBO.setOrgId(abilityRspBO.getOrgId());
            reqBO.setOrgName(abilityRspBO.getOrgName());
            reqBO.setCompanyId(abilityRspBO.getCompanyId());
            reqBO.setCompanyName(abilityRspBO.getCompanyName());
            reqBO.setUserId(abilityRspBO.getUserId());
            reqBO.setName(abilityRspBO.getName());
        }
    }

    private void validateParam(BewgFscBillOrderInvoiceConformReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u6536\u7968\u786e\u8ba4API\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getName())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55API\u5165\u53c2\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAuditResult()) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u6536\u7968\u786e\u8ba4API\u5165\u53c2\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

