/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.BewgFscInPayBillCallbackService;
import com.tydic.dyc.fsc.bo.BewgFscInPayBillCallbackReqBO;
import com.tydic.dyc.fsc.bo.BewgFscInPayBillCallbackRspBO;
import com.tydic.fsc.pay.ability.api.FscInPayBillCallbackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscInPayBillCallbackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscInPayBillCallbackAbilityRspBO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.umc.general.ability.api.UmcLoginNameCompanAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginNameCompanAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginNameCompanAbilityRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BewgFscInPayBillCallbackServiceImpl
implements BewgFscInPayBillCallbackService {
    private static final Logger log = LoggerFactory.getLogger(BewgFscInPayBillCallbackServiceImpl.class);
    @Autowired
    private FscInPayBillCallbackAbilityService fscInPayBillCallbackAbilityService;
    @Autowired
    private UmcLoginNameCompanAbilityService umcLoginNameCompanAbilityService;

    public BewgFscInPayBillCallbackRspBO dealInPayBillCallback(BewgFscInPayBillCallbackReqBO reqBO) {
        this.validateParam(reqBO);
        this.setLoginValue(reqBO);
        FscInPayBillCallbackAbilityReqBO fscInPayBillCallbackAbilityReqBO = new FscInPayBillCallbackAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscInPayBillCallbackAbilityReqBO);
        try {
            fscInPayBillCallbackAbilityReqBO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff01" + reqBO.getPayTime());
        }
        FscInPayBillCallbackAbilityRspBO fscInPayBillCallbackAbilityRspBO = this.fscInPayBillCallbackAbilityService.dealInPayBillCallback(fscInPayBillCallbackAbilityReqBO);
        if (!"0000".equals(fscInPayBillCallbackAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(fscInPayBillCallbackAbilityRspBO.getRespDesc());
        }
        return new BewgFscInPayBillCallbackRspBO();
    }

    private void setLoginValue(BewgFscInPayBillCallbackReqBO reqBO) {
        if (StringUtils.hasText((String)reqBO.getName()) && null == reqBO.getUserId()) {
            UmcLoginNameCompanAbilityReqBO abilityReqBO = new UmcLoginNameCompanAbilityReqBO();
            abilityReqBO.setLoginName(reqBO.getName());
            log.debug("\u8d22\u52a1\u56de\u8c03\u8bbe\u7f6e\u767b\u9646\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)abilityReqBO));
            UmcLoginNameCompanAbilityRspBO abilityRspBO = this.umcLoginNameCompanAbilityService.qryLoginList(abilityReqBO);
            log.debug("\u8d22\u52a1\u56de\u8c03\u8bbe\u7f6e\u767b\u9646\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)abilityRspBO));
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                // empty if block
            }
            reqBO.setOrgId(abilityRspBO.getOrgId());
            reqBO.setOrgName(abilityRspBO.getOrgName());
            reqBO.setCompanyId(abilityRspBO.getCompanyId());
            reqBO.setCompanyName(abilityRspBO.getCompanyName());
            reqBO.setUserId(abilityRspBO.getUserId());
            reqBO.setName(abilityRspBO.getName());
        }
    }

    private void validateParam(BewgFscInPayBillCallbackReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5185\u90e8\u4ed8\u6b3e\u56de\u8c03API\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getName())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5185\u90e8\u4ed8\u6b3e\u56de\u8c03API\u5165\u53c2\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAuditResult()) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5185\u90e8\u4ed8\u6b3e\u56de\u8c03API\u5165\u53c2\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBO.getPayTime())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5e94\u7528-\u5185\u90e8\u4ed8\u6b3e\u56de\u8c03API\u5165\u53c2\u3010payTime\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

