/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.tydic.dyc.fsc.api.DycFscGetInvoiceDataAbilityService;
import com.tydic.dyc.fsc.bo.DycFscGetInvoiceDataAbilityReqBO;
import com.tydic.dyc.fsc.bo.DycFscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycFscGetInvoiceDataAbilityServiceImpl
implements DycFscGetInvoiceDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycFscGetInvoiceDataAbilityServiceImpl.class);
    private static final Long JD_ID = 100055L;
    private static final Integer RECEIVE_TYPE_PURCHASER = 1;
    private static final Integer RECEIVE_TYPE_OPERATION = 2;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private FscGetInvoiceDataAbilityService fscGetInvoiceDataAbilityService;

    public DycFscGetInvoiceDataAbilityRspBO getInvoiceData(DycFscGetInvoiceDataAbilityReqBO reqBO) {
        List fscOrders;
        if (log.isDebugEnabled()) {
            log.debug("==========\u83b7\u53d6\u7535\u5546\u53d1\u7968\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb==========");
        }
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(FscConstants.BewgFscInvoiceOrderState.STATE_01);
        fscComOrderListQueryAbilityReqBO.setOrderStates(states);
        ArrayList<Integer> orderFlow = new ArrayList<Integer>();
        orderFlow.add(FscConstants.OrderFlow.INVOICE);
        fscComOrderListQueryAbilityReqBO.setOrderFlows(orderFlow);
        fscComOrderListQueryAbilityReqBO.setOrderSource(FscOrderSourceEnum.ELECTRIC_MARKET.getCode());
        fscComOrderListQueryAbilityReqBO.setPageSize(Integer.valueOf(-1));
        FscComOrderListQueryAbilityRspBO queryAbilityRspBO = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(queryAbilityRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u4e3a\u83b7\u53d6\u53d1\u7968\u6570\u636e\u5931\u8d25\uff1a{}", (Object)queryAbilityRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)(fscOrders = queryAbilityRspBO.getRows()))) {
            for (FscComOrderListBO fscOrder : fscOrders) {
                FscGetInvoiceDataAbilityReqBO fscGetInvoiceDataAbilityReqBO = new FscGetInvoiceDataAbilityReqBO();
                Long orgId = FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrder.getReceiveType()) ? fscOrder.getPurchaserId() : fscOrder.getProOrgId();
                fscGetInvoiceDataAbilityReqBO.setFscOrderId(fscOrder.getFscOrderId());
                fscGetInvoiceDataAbilityReqBO.setSupplierId(fscOrder.getSupplierId());
                fscGetInvoiceDataAbilityReqBO.setProOrgId(orgId);
                fscGetInvoiceDataAbilityReqBO.setReceiveType(fscOrder.getReceiveType());
                fscGetInvoiceDataAbilityReqBO.setMakeType(fscOrder.getMakeType());
                FscGetInvoiceDataAbilityRspBO invoiceData = this.fscGetInvoiceDataAbilityService.getInvoiceData(fscGetInvoiceDataAbilityReqBO);
                if ("0000".equals(invoiceData.getRespCode())) continue;
                log.error("\u7ed3\u7b97\u5355\u3010{}\u3011\u83b7\u53d6\u53d1\u7968\u5931\u8d25", (Object)fscOrder.getFscOrderId());
            }
        } else {
            log.error("\u672a\u67e5\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u6570\u636e");
        }
        DycFscGetInvoiceDataAbilityRspBO rspBO = new DycFscGetInvoiceDataAbilityRspBO();
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

