/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.cfc.ability.api.CfcQryImportTemplateListAbilityService;
import com.tydic.cfc.ability.bo.CfcImportTemplateBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityRspBO;
import com.tydic.dyc.fsc.api.DycFscExportBillUploadModelService;
import com.tydic.dyc.fsc.api.DycFscInvoiceForOrderExcelExportService;
import com.tydic.dyc.fsc.bo.CellData;
import com.tydic.dyc.fsc.bo.DycFscExportBillUploadModelReqBO;
import com.tydic.dyc.fsc.bo.DycFscExportBillUploadModelRspBO;
import com.tydic.dyc.fsc.bo.DycFscOrderInvoiceBO;
import com.tydic.dyc.fsc.bo.DycFscOrderitemDetailBO;
import com.tydic.dyc.fsc.bo.DycInvoiceForOrderExcelExportReqBO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycFscInvoiceForOrderExcelExportServiceImpl
implements DycFscInvoiceForOrderExcelExportService {
    private static final Logger log = LoggerFactory.getLogger(DycFscInvoiceForOrderExcelExportServiceImpl.class);
    @Autowired
    private CfcQryImportTemplateListAbilityService cfcQryImportTemplateListAbilityService;
    @Autowired
    private DycFscExportBillUploadModelService dycFscExportBillUploadModelService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletResponse response, DycInvoiceForOrderExcelExportReqBO reqBO) {
        DycFscExportBillUploadModelReqBO dycFscExportBillUploadModelReqBO = (DycFscExportBillUploadModelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycFscExportBillUploadModelReqBO.class);
        DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO = this.dycFscExportBillUploadModelService.exportBillUploadModel(dycFscExportBillUploadModelReqBO);
        CfcQryImportTemplateListAbilityReqBO cfcQryImportTemplateListAbilityReqBO = new CfcQryImportTemplateListAbilityReqBO();
        cfcQryImportTemplateListAbilityReqBO.setImportTemplateNo("DDJSDFPXXSC");
        CfcQryImportTemplateListAbilityRspBO cfcQryImportTemplateListAbilityRspBO = this.cfcQryImportTemplateListAbilityService.qryImportTemplateList(cfcQryImportTemplateListAbilityReqBO);
        String urlLocation = ((CfcImportTemplateBO)cfcQryImportTemplateListAbilityRspBO.getRows().get(0)).getImportTemplateUrl();
        InputStream is = null;
        HttpURLConnection urlConnection = null;
        try {
            List<CellData> itemDataListRow2;
            List<CellData> orderDataListRow1;
            XSSFSheet sheet;
            URL url = new URL(urlLocation);
            urlConnection = (HttpURLConnection)url.openConnection();
            is = urlConnection.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(is);
            if (!Objects.isNull(dycFscExportBillUploadModelRspBO.getDycFscOrderInvoiceBO())) {
                sheet = workbook.getSheetAt(1);
                orderDataListRow1 = this.getCellData(1, 0, 9, workbook);
                itemDataListRow2 = this.getCellData(1, 1, 9, workbook);
                this.insertInvoiceToSheet(0, dycFscExportBillUploadModelRspBO, sheet, orderDataListRow1, itemDataListRow2);
            }
            if (CollectionUtils.isNotEmpty((Collection)dycFscExportBillUploadModelRspBO.getFscOrderItemDetailBOS())) {
                sheet = workbook.getSheetAt(2);
                orderDataListRow1 = this.getCellData(2, 0, 18, workbook);
                itemDataListRow2 = this.getCellData(2, 1, 18, workbook);
                this.insertDetailToSheet(0, dycFscExportBillUploadModelRspBO, sheet, orderDataListRow1, itemDataListRow2);
            }
            response.reset();
            response.setContentType("application/x-msdownload");
            String fileName = "\u7ed3\u7b97-\u5bfc\u51fa\u5f00\u7968\u4e0a\u4f20\u8be6\u60c5\u6a21\u677f.xlsx";
            String fileNameURL = URLEncoder.encode(fileName, "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileNameURL + ";filename*=utf-8''" + fileNameURL);
            ServletOutputStream output = response.getOutputStream();
            workbook.write((OutputStream)output);
            urlConnection.disconnect();
            is.close();
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void insertInvoiceToSheet(int startRowIndex, DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO, XSSFSheet sheet, List<CellData> orderDataListRow1, List<CellData> orderDataListRow2) {
        CellData cellData;
        XSSFCell cell;
        int i;
        DycFscOrderInvoiceBO dycFscOrderInvoiceBO = dycFscExportBillUploadModelRspBO.getDycFscOrderInvoiceBO();
        if (Objects.isNull(sheet.getRow(startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        XSSFRow startRow = sheet.getRow(startRowIndex);
        startRow.setHeight(orderDataListRow1.get(0).getRowHeight());
        for (i = 0; i < orderDataListRow1.size(); ++i) {
            if (Objects.isNull(orderDataListRow1.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            cell = startRow.getCell(i);
            cellData = orderDataListRow1.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
        }
        if (Objects.isNull(sheet.getRow(++startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        startRow = sheet.getRow(startRowIndex);
        block12: for (i = 0; i < orderDataListRow2.size(); ++i) {
            if (Objects.isNull(orderDataListRow2.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            cell = startRow.getCell(i);
            cellData = orderDataListRow2.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
            switch (i) {
                case 0: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getOrderNo());
                    continue block12;
                }
                case 1: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getInvoiceTypeStr());
                    continue block12;
                }
                case 2: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getBuyName());
                    continue block12;
                }
                case 3: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getTaxNo());
                    continue block12;
                }
                case 4: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getAddress());
                    continue block12;
                }
                case 5: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getPhone());
                    continue block12;
                }
                case 6: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getBank());
                    continue block12;
                }
                case 7: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getAccount());
                    continue block12;
                }
                case 8: {
                    cell.setCellValue(dycFscOrderInvoiceBO.getTotalCharge().toString());
                    continue block12;
                }
            }
        }
    }

    private void insertDetailToSheet(int startRowIndex, DycFscExportBillUploadModelRspBO dycFscExportBillUploadModelRspBO, XSSFSheet sheet, List<CellData> orderDataListRow1, List<CellData> orderDataListRow2) {
        List fscOrderItemDetailBOS = dycFscExportBillUploadModelRspBO.getFscOrderItemDetailBOS();
        if (Objects.isNull(sheet.getRow(startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        XSSFRow startRow = sheet.getRow(startRowIndex);
        startRow.setHeight(orderDataListRow1.get(0).getRowHeight());
        for (int i = 0; i < orderDataListRow1.size(); ++i) {
            if (Objects.isNull(orderDataListRow1.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            XSSFCell cell = startRow.getCell(i);
            CellData cellData = orderDataListRow1.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
        }
        for (DycFscOrderitemDetailBO fscOrderItemDetailBO : fscOrderItemDetailBOS) {
            if (Objects.isNull(sheet.getRow(++startRowIndex))) {
                sheet.createRow(startRowIndex);
            }
            startRow = sheet.getRow(startRowIndex);
            block18: for (int i = 0; i < orderDataListRow2.size(); ++i) {
                if (Objects.isNull(orderDataListRow2.get(i))) continue;
                if (Objects.isNull(startRow.getCell(i))) {
                    startRow.createCell(i);
                }
                XSSFCell cell = startRow.getCell(i);
                CellData cellData = orderDataListRow2.get(i);
                cell.setCellStyle((CellStyle)cellData.getStyle());
                cell.setCellValue(cellData.getData());
                startRow.setHeight(cellData.getRowHeight());
                sheet.setColumnWidth(i, cellData.getColumnWeight());
                switch (i) {
                    case 0: {
                        cell.setCellValue(fscOrderItemDetailBO.getOrderNo());
                        continue block18;
                    }
                    case 4: {
                        cell.setCellValue(fscOrderItemDetailBO.getOrderCode());
                        continue block18;
                    }
                    case 5: {
                        cell.setCellValue(fscOrderItemDetailBO.getPurchaserName());
                        continue block18;
                    }
                    case 6: {
                        cell.setCellValue(fscOrderItemDetailBO.getProductId());
                        continue block18;
                    }
                    case 8: {
                        cell.setCellValue(fscOrderItemDetailBO.getSkuName());
                        continue block18;
                    }
                    case 9: {
                        cell.setCellValue(fscOrderItemDetailBO.getSpecModel());
                        continue block18;
                    }
                    case 10: {
                        cell.setCellValue(fscOrderItemDetailBO.getUnit());
                        continue block18;
                    }
                    case 11: {
                        cell.setCellValue(fscOrderItemDetailBO.getNum().toString());
                        continue block18;
                    }
                    case 12: {
                        cell.setCellValue(fscOrderItemDetailBO.getPrice().toString());
                        continue block18;
                    }
                    case 13: {
                        cell.setCellValue(fscOrderItemDetailBO.getUntaxPrice().toString());
                        continue block18;
                    }
                    case 14: {
                        cell.setCellValue(fscOrderItemDetailBO.getAmt().toString());
                        continue block18;
                    }
                    case 15: {
                        cell.setCellValue(fscOrderItemDetailBO.getUntaxAmt().toString());
                        continue block18;
                    }
                    case 16: {
                        cell.setCellValue(fscOrderItemDetailBO.getTaxAmt().toString());
                        continue block18;
                    }
                    case 17: {
                        cell.setCellValue(fscOrderItemDetailBO.getTaxRate().toString());
                        continue block18;
                    }
                }
            }
        }
    }

    private List<CellData> getCellData(int sheetIndex, int rowIndex, int columnSize, XSSFWorkbook workbook) {
        LinkedList<CellData> cellDataList = new LinkedList<CellData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (int i = 0; i < columnSize; ++i) {
            CellData cellData;
            XSSFRow row = sheet.getRow(rowIndex);
            XSSFCell cell = row.getCell(i);
            if (!Objects.isNull(cell)) {
                XSSFCellStyle cellStyle = cell.getCellStyle();
                short rowHeight = row.getHeight();
                int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
                cell.setCellType(CellType.STRING);
                String cellValue = cell.getStringCellValue();
                cellData = new CellData(rowHeight, columnWidth, cellStyle, cellValue);
            } else {
                cellData = null;
            }
            cellDataList.add(cellData);
        }
        return cellDataList;
    }
}

