/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.tydic.cfc.ability.api.CfcQryImportTemplateListAbilityService;
import com.tydic.cfc.ability.bo.CfcImportTemplateBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryImportTemplateListAbilityRspBO;
import com.tydic.dyc.fsc.api.DycFscInvoiceForServiceFeeExcelExportService;
import com.tydic.dyc.fsc.bo.CellData;
import com.tydic.dyc.fsc.bo.DycInvoiceForServiceFeeExcelExportReqBO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycFscInvoiceForServiceFeeExcelExportServiceImpl
implements DycFscInvoiceForServiceFeeExcelExportService {
    private static final Logger log = LoggerFactory.getLogger(DycFscInvoiceForServiceFeeExcelExportServiceImpl.class);
    @Autowired
    private CfcQryImportTemplateListAbilityService cfcQryImportTemplateListAbilityService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletResponse response, DycInvoiceForServiceFeeExcelExportReqBO reqBO) {
        CfcQryImportTemplateListAbilityReqBO cfcQryImportTemplateListAbilityReqBO = new CfcQryImportTemplateListAbilityReqBO();
        cfcQryImportTemplateListAbilityReqBO.setImportTemplateNo("FYJSDFPXXSC");
        CfcQryImportTemplateListAbilityRspBO cfcQryImportTemplateListAbilityRspBO = this.cfcQryImportTemplateListAbilityService.qryImportTemplateList(cfcQryImportTemplateListAbilityReqBO);
        String urlLocation = ((CfcImportTemplateBO)cfcQryImportTemplateListAbilityRspBO.getRows().get(0)).getImportTemplateUrl();
        InputStream is = null;
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(urlLocation);
            urlConnection = (HttpURLConnection)url.openConnection();
            is = urlConnection.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(is);
            XSSFSheet sheet = workbook.getSheetAt(0);
            List<CellData> orderDataListRow1 = this.getCellData(0, 0, 9, workbook);
            List<CellData> itemDataListRow2 = this.getCellData(0, 1, 9, workbook);
            this.insertInvoiceToSheet(0, reqBO, sheet, orderDataListRow1, itemDataListRow2);
            response.reset();
            response.setContentType("application/x-msdownload");
            String fileName = "\u7b97-\u5bfc\u51fa\u5f00\u7968\u4e0a\u4f20\u8be6\u60c5\u6a21\u677f.xlsx";
            String fileNameURL = URLEncoder.encode(fileName, "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileNameURL + ";filename*=utf-8''" + fileNameURL);
            ServletOutputStream output = response.getOutputStream();
            workbook.write((OutputStream)output);
            urlConnection.disconnect();
            is.close();
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void insertInvoiceToSheet(int startRowIndex, DycInvoiceForServiceFeeExcelExportReqBO reqBO, XSSFSheet sheet, List<CellData> orderDataListRow1, List<CellData> orderDataListRow2) {
        CellData cellData;
        XSSFCell cell;
        int i;
        if (Objects.isNull(sheet.getRow(startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        XSSFRow startRow = sheet.getRow(startRowIndex);
        startRow.setHeight(orderDataListRow1.get(0).getRowHeight());
        for (i = 0; i < orderDataListRow1.size(); ++i) {
            if (Objects.isNull(orderDataListRow1.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            cell = startRow.getCell(i);
            cellData = orderDataListRow1.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
        }
        if (Objects.isNull(sheet.getRow(++startRowIndex))) {
            sheet.createRow(startRowIndex);
        }
        startRow = sheet.getRow(startRowIndex);
        block6: for (i = 0; i < orderDataListRow2.size(); ++i) {
            if (Objects.isNull(orderDataListRow2.get(i))) continue;
            if (Objects.isNull(startRow.getCell(i))) {
                startRow.createCell(i);
            }
            cell = startRow.getCell(i);
            cellData = orderDataListRow2.get(i);
            cell.setCellStyle((CellStyle)cellData.getStyle());
            cell.setCellValue(cellData.getData());
            startRow.setHeight(cellData.getRowHeight());
            sheet.setColumnWidth(i, cellData.getColumnWeight());
            switch (i) {
                case 0: {
                    cell.setCellValue(reqBO.getFscOrderNo());
                    continue block6;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    cell.setCellValue("");
                    continue block6;
                }
                case 4: {
                    cell.setCellValue(reqBO.getSupplierName());
                    continue block6;
                }
            }
        }
    }

    private List<CellData> getCellData(int sheetIndex, int rowIndex, int columnSize, XSSFWorkbook workbook) {
        LinkedList<CellData> cellDataList = new LinkedList<CellData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (int i = 0; i < columnSize; ++i) {
            CellData cellData;
            XSSFRow row = sheet.getRow(rowIndex);
            XSSFCell cell = row.getCell(i);
            if (!Objects.isNull(cell)) {
                XSSFCellStyle cellStyle = cell.getCellStyle();
                short rowHeight = row.getHeight();
                int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
                cell.setCellType(CellType.STRING);
                String cellValue = cell.getStringCellValue();
                cellData = new CellData(rowHeight, columnWidth, cellStyle, cellValue);
            } else {
                cellData = null;
            }
            cellDataList.add(cellData);
        }
        return cellDataList;
    }
}

