/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.util;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxUtils {
    private static final Logger log = LoggerFactory.getLogger(TaxUtils.class);
    private static final Integer DIVIDE_SCALE = 8;
    private static final Integer DEFAULT_SCALE = 2;

    public static BigDecimal calTaxAmt(BigDecimal amt, BigDecimal taxRate, Integer scale) {
        if (null == scale) {
            scale = DEFAULT_SCALE;
        }
        return amt.divide(BigDecimal.ONE.add(taxRate), (int)DIVIDE_SCALE, 4).multiply(taxRate).setScale((int)scale, 4);
    }

    public static BigDecimal calTaxAmt(BigDecimal amt, BigDecimal taxRate) {
        return amt.divide(BigDecimal.ONE.add(taxRate), (int)DIVIDE_SCALE, 4).multiply(taxRate).setScale((int)DEFAULT_SCALE, 0);
    }
}

