var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));

$(document).ready(function () {
    $('#jumpBtn').on('click', function () {
        jumpEvent();
    });
    $('#repayBtn').on('click', function () {
        repayEvent();
    });

    if (payOrderInfo) {
        init();
    } else {
        payOrderInfo = {
            orderId: util.getQueryString('orderId')
        };
        var data = {};
        data.params = {
            orderId: payOrderInfo.orderId
        };
        data.params.service = '/cashierDesk/queryCashierDesk';
        data.successF = function (returnData) {
            payOrderInfo.realFee = returnData.realFee;
            payOrderInfo.redirectUrl = returnData.redirectUrl;
            init();
        };
        loadingMask('正在加载支付结果...');
        util.ajax(data);
    }
});

var init = function () {
    $('#orderId').text(payOrderInfo.orderId);
    $('#realFee').text(payOrderInfo.realFee / 100.00);

    var payStatus = util.getQueryString('payStatus');
    if (payStatus == 'SUCCESS') {
        $('#payResult .icon-result').addClass('icon-result-succ');
        $('#payResult .result-control .result-title').text('支付成功');
        $('#jumpDesc').text('跳转回商户');
        $('#jumpBtn').removeClass('btn-red').addClass('btn-green').show();
    } else {
        var rspName = util.getQueryString('rspName');
        $('#payResult .icon-result').addClass('icon-result-false');
        $('#payResult .result-control .result-title').text('支付失败');
        $('#jumpDesc').text('跳转到收银台');
        $('#jumpBtn').removeClass('btn-green').addClass('btn-red').show();
        if (!isEmpty(rspName)) {
            var failReason = '<div class="result-desc">原因：' + rspName + '</div>';
            $("#payResult .result-title").after(failReason);
        }
        $('#repayBtn').show();
    }
    var countDown = setInterval(function () {
        var curTime = parseInt($('#countDown').text()) - 1;
        $('#countDown').text(curTime);
        if (curTime == 0) {
            clearInterval(countDown);
            if (payStatus == 'SUCCESS') {
                jumpEvent();//立即跳转
            } else {
                repayEvent();//重新支付
            }
        }
    }, 1000);
};

var jumpEvent = function () {
    if (payOrderInfo.redirectUrl && payOrderInfo.redirectUrl != '') {
        sessionStorage.removeItem('payOrderInfo');
        location.replace(payOrderInfo.redirectUrl);
    } else {
        util.dialog.alert('接入业务系统未提供跳转地址');
    }
};
var repayEvent = function () {
    location.replace('cashierDesk.html?orderId=' + payOrderInfo.orderId);
};
