/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config.quartz;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.config.quartz.PayProRefundCallBaceJob;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.icbc.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefundCallBackSender {
    private static final Logger log = LoggerFactory.getLogger(RefundCallBackSender.class);
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    private final Map<String, Integer> TIMES_MAP = new HashMap<String, Integer>();
    private final String CALL_BACK_JOB_GROUP = "JOB_GROUP_CALL_BACK";
    private final String CALL_BACK_TRIGGER_GROUP = "TRIGGER_GROUP_CALL_BACK";
    private final String CALL_BACK_JOB_PREFIX = "JOB_CALL_BACK_";
    private final String CALL_BACK_TRIGGER_PREFIX = "TRIGGER_CALL_BACK_";

    @PostConstruct
    private void init() {
        if (this.payPropertiesVo.isUseMulitpleCallBack()) {
            String mulitpleCallBackConfig = this.payPropertiesVo.getValueByKey("mulitple.callback.times.data");
            String[] split = mulitpleCallBackConfig.split(",");
            for (int i = 0; i < split.length; ++i) {
                this.TIMES_MAP.put("" + (i + 1), Integer.valueOf(split[i]));
            }
            log.info("\u56de\u8c03\u65f6\u95f4\u95f4\u9694\u914d\u7f6e\u89e3\u6790\u6210\u529f\uff0c\u503c\u4e3a\uff1a" + JSON.toJSONString(this.TIMES_MAP));
            this.payPropertiesVo.setValue("mulitple.callback.times", split.length + "");
            log.info("\u6839\u636e\u56de\u8c03\u65f6\u95f4\u95f4\u9694\u914d\u7f6e\u7b97\u51fa\u914d\u7f6e\u9700\u8981\u56de\u8c03\u6b21\u6570\u4e3a\uff1a" + split.length);
        } else {
            log.info("\u672c\u6b21\u542f\u52a8\uff0c\u4e0d\u9700\u8981\u4f7f\u7528\u591a\u6b21\u56de\u8c03");
        }
    }

    public PayProBaseRspBo sendTask(String orderId) {
        log.info("\u8ba2\u5355\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u8ba2\u5355ID\uff1a", (Object)orderId);
        PayProBaseRspBo retBo = new PayProBaseRspBo();
        if (StringUtils.isEmpty((String)orderId)) {
            log.error("\u591a\u6b21\u56de\u8c03\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\uff0corderId\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u591a\u6b21\u56de\u8c03\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\uff0corderId\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        PorderPo orderPo = this.payOrderAtomService.queryByOrderId(Long.parseLong(orderId));
        int noticedTime = orderPo.getCurrentNoticeTime();
        String relSuffix = orderId + "_" + (noticedTime + 1);
        String jobName = "JOB_CALL_BACK_" + relSuffix;
        String triggerName = "TRIGGER_CALL_BACK_" + relSuffix;
        JobDetail job = JobBuilder.newJob(PayProRefundCallBaceJob.class).withIdentity(jobName, "JOB_GROUP_CALL_BACK").usingJobData("orderId", orderId).usingJobData("time", noticedTime + 1 + "").build();
        int triggerTime = this.TIMES_MAP.get(noticedTime + 1 + "");
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, "TRIGGER_GROUP_CALL_BACK").startAt(DateBuilder.futureDate((int)triggerTime, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).build();
        try {
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error("\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\u4e86", (Throwable)e);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\u4e86:" + e.getMessage());
            return retBo;
        }
        log.info("\u8ba2\u5355\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\u6210\u529f,\u8ba2\u5355id\u4e3a\uff1a" + orderId);
        orderPo.setCurrentNoticeTime(noticedTime + 1);
        int update = this.payOrderAtomService.update(orderPo);
        if (update < 1) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u591a\u6b21\u56de\u8c03\u89e6\u53d1\u6210\u529f\uff0c\u4f46\u589e\u52a0\u56de\u8c03\u6b21\u6570\u5931\u8d25\uff1a\u66f4\u65b0\u6570\u636e\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        log.info("\u8ba2\u5355\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1\u6210\u529f\uff0c\u63d0\u5347\u56de\u8c03\u6b21\u6570\u6210\u529f,\u8ba2\u5355id\u4e3a\uff1a" + orderId);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }
}

