/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.atom.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.uec.atom.UecReplyListQryAtomService;
import com.tydic.uec.atom.bo.UecReplyListQryAtomReqBO;
import com.tydic.uec.atom.bo.UecReplyListQryAtomRspBO;
import com.tydic.uec.common.bo.reply.ReplyBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.ReplyThumbUpRecMapper;
import com.tydic.uec.dao.UnionQuerySqlMapper;
import com.tydic.uec.dao.po.ReplyThumbUpRecPO;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecReplyListQryAtomServiceImpl
implements UecReplyListQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UecReplyListQryAtomServiceImpl.class);
    private final UnionQuerySqlMapper unionQuerySqlMapper;
    private final ReplyThumbUpRecMapper replyThumbUpRecMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecReplyListQryAtomServiceImpl(UnionQuerySqlMapper unionQuerySqlMapper, ReplyThumbUpRecMapper replyThumbUpRecMapper, RedisUtil redisUtil) {
        this.unionQuerySqlMapper = unionQuerySqlMapper;
        this.replyThumbUpRecMapper = replyThumbUpRecMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecReplyListQryAtomRspBO qryReplyList(UecReplyListQryAtomReqBO reqBO) {
        UecReplyListQryAtomRspBO rspBO;
        String redisQryKey = this.getReplyListRedisKey(reqBO);
        Long redisListSize = null;
        boolean saveRedis = false;
        if (redisQryKey != null && (redisListSize = this.redisUtil.zGetSize(redisQryKey)) != null) {
            saveRedis = true;
            rspBO = this.returnReplyListFromRedis(redisQryKey, redisListSize.intValue(), reqBO);
            if (rspBO != null) {
                return rspBO;
            }
        }
        rspBO = new UecReplyListQryAtomRspBO();
        ReplyBO paramBO = new ReplyBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)paramBO);
        Page replyPage = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.unionQuerySqlMapper.qryReplyList(paramBO));
        if (replyPage.getResult().size() > 0) {
            if (saveRedis && (long)((reqBO.getPageNo() - 1) * reqBO.getPageSize()) > redisListSize) {
                saveRedis = false;
            }
            HashSet upperReplyIdTuples = null;
            HashMap childReplyIdMap = null;
            HashMap replyInfoMap = null;
            if (saveRedis) {
                upperReplyIdTuples = Sets.newHashSetWithExpectedSize((int)reqBO.getPageSize());
                childReplyIdMap = Maps.newHashMapWithExpectedSize((int)reqBO.getPageSize());
                replyInfoMap = Maps.newHashMapWithExpectedSize((int)(reqBO.getPageSize() * 10));
            }
            this.handleReplyListProcess(upperReplyIdTuples, childReplyIdMap, replyInfoMap, replyPage.getResult(), UecCommonConstant.YES_FLAG.equals(reqBO.getSortByLikeCount()), reqBO.getMemIdExt());
            if (saveRedis) {
                this.saveReplyListIntoRedis(redisQryKey, redisListSize.intValue(), replyPage.getResult().size(), (int)replyPage.getTotal(), upperReplyIdTuples, childReplyIdMap, replyInfoMap);
            }
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotalRecords((int)replyPage.getTotal());
        rspBO.setTotalPages(replyPage.getPages());
        rspBO.setRows(replyPage.getResult());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u56de\u590d\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private String getReplyListRedisKey(UecReplyListQryAtomReqBO reqBO) {
        boolean checkParam;
        String redisKey = null;
        boolean bl = checkParam = UecCommonConstant.StateEnum.YES.value.equals(reqBO.getReplyState()) && StringUtils.isBlank((CharSequence)reqBO.getObjMemId()) && (StringUtils.isNotBlank((CharSequence)reqBO.getObjId()) || StringUtils.isNotBlank((CharSequence)reqBO.getMemId()));
        if (checkParam) {
            if (StringUtils.isBlank((CharSequence)reqBO.getObjId()) && StringUtils.isNotBlank((CharSequence)reqBO.getMemId())) {
                redisKey = "uec_reply_list_" + reqBO.getSysCode() + "_memId#" + reqBO.getMemId();
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getObjId()) && reqBO.getObjType() != null && StringUtils.isBlank((CharSequence)reqBO.getMemId())) {
                redisKey = "uec_reply_list_" + reqBO.getSysCode() + "_objType#" + reqBO.getObjType() + "_objId#" + reqBO.getObjId();
            }
        }
        return redisKey;
    }

    private UecReplyListQryAtomRspBO returnReplyListFromRedis(String redisKey, int redisListSize, UecReplyListQryAtomReqBO reqBO) {
        int pageSize;
        boolean resortByLike = UecCommonConstant.YES_FLAG.equals(reqBO.getSortByLikeCount());
        int pageNo = reqBO.getPageNo();
        if ((pageNo - 1) * (pageSize = reqBO.getPageSize().intValue()) < redisListSize) {
            boolean notInPage;
            Object hashCount = this.redisUtil.hashGet("uec_reply_list_", redisKey + "_totalRecords");
            if (hashCount == null) {
                return null;
            }
            int totalCount = (Integer)hashCount;
            int totalPage = (totalCount - 1) / pageSize + 1;
            boolean bl = notInPage = pageNo < totalPage && pageNo * pageSize > redisListSize || pageNo == totalPage && totalCount - (totalPage - 1) * pageSize != redisListSize - (pageNo - 1) * pageSize;
            if (notInPage) {
                return null;
            }
            Set<Object> upperReplyIds = this.redisUtil.zGet(redisKey, (pageNo - 1) * pageSize, pageNo * pageSize - 1, true);
            if (CollectionUtils.isEmpty(upperReplyIds)) {
                return null;
            }
            List<ReplyBO> replyList = this.convertRedisObjects(redisKey, upperReplyIds, false);
            if (replyList.size() != upperReplyIds.size()) {
                return null;
            }
            if (this.recurChildReplyList(replyList, resortByLike, reqBO.getMemIdExt())) {
                return null;
            }
            UecReplyListQryAtomRspBO rspBO = new UecReplyListQryAtomRspBO();
            rspBO.setPageNo(pageNo);
            rspBO.setTotalRecords(totalCount);
            rspBO.setTotalPages(totalPage);
            rspBO.setRows(replyList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u56de\u590d\u5217\u8868\u6210\u529f");
            return rspBO;
        }
        return null;
    }

    private List<ReplyBO> convertRedisObjects(String redisKey, Set<Object> replyIds, boolean isChild) {
        List<Object> hashObjects = this.redisUtil.hashMultiGet("uec_reply_list_", replyIds);
        if (CollectionUtils.isEmpty(hashObjects) || hashObjects.size() != replyIds.size()) {
            if (isChild) {
                this.redisUtil.hashDel("uec_reply_child_ids_", redisKey);
            } else {
                this.redisUtil.zRemove(redisKey, replyIds.toArray());
            }
            return new ArrayList<ReplyBO>();
        }
        ArrayList<ReplyBO> replyList = new ArrayList<ReplyBO>(hashObjects.size());
        try {
            for (Object e : hashObjects) {
                if (e == null) continue;
                replyList.add((ReplyBO)e);
            }
        }
        catch (ClassCastException e) {
            log.error("\u56de\u590d\u5217\u8868\u67e5\u8be2\u670d\u52a1\u7f13\u5b58\u5bf9\u8c61\u8f6c\u56de\u590d\u5bf9\u8c61\u5f02\u5e38");
            this.redisUtil.hashDel("uec_reply_list_", replyIds.toArray());
        }
        if (replyList.size() != replyIds.size()) {
            if (isChild) {
                this.redisUtil.hashDel("uec_reply_child_ids_", redisKey);
            } else {
                this.redisUtil.zRemove(redisKey, replyIds.toArray());
            }
        }
        return replyList;
    }

    private boolean recurChildReplyList(List<ReplyBO> replyList, boolean resortByLike, Long currentMemId) {
        for (ReplyBO upperReply : replyList) {
            Object childHashSet;
            if (upperReply.getThumbUpCount() > 0) {
                this.getUserLikeType(currentMemId, upperReply);
            }
            if ((childHashSet = this.redisUtil.hashGet("uec_reply_child_ids_", upperReply.getReplyId())) == null) {
                upperReply.setChildReplyList(new ArrayList());
                continue;
            }
            Set childReplyIds = (Set)childHashSet;
            List<ReplyBO> childReplyList = this.convertRedisObjects(upperReply.getReplyId(), childReplyIds, true);
            if (childReplyList.size() != childReplyIds.size()) {
                return true;
            }
            upperReply.setChildReplyList(childReplyList);
            if (CollectionUtils.isEmpty(childReplyList) || !this.recurChildReplyList(childReplyList, resortByLike, currentMemId)) continue;
            return true;
        }
        if (resortByLike) {
            replyList.sort(Comparator.comparingInt(ReplyBO::getThumbUpCount).reversed());
        }
        return false;
    }

    private void handleReplyListProcess(Set<ZSetOperations.TypedTuple<Object>> upperReplyIdTuples, Map<String, Object> childReplyIdMap, Map<String, Object> replyInfoMap, List<ReplyBO> replyList, boolean resortByLike, Long currentMemId) {
        boolean saveRedis = upperReplyIdTuples != null;
        boolean addUpperReply = CollectionUtils.isEmpty(upperReplyIdTuples);
        for (ReplyBO replyBO : replyList) {
            if (resortByLike) {
                ReplyThumbUpRecPO thumbUpRecParam = new ReplyThumbUpRecPO();
                thumbUpRecParam.setReplyId(Long.parseLong(replyBO.getReplyId()));
                thumbUpRecParam.setState(UecCommonConstant.StateEnum.YES.value);
                thumbUpRecParam.setThumbUpType(UecCommonConstant.ThumbUpEnum.YES.value);
                replyBO.setThumbUpCount(Integer.valueOf(this.replyThumbUpRecMapper.getCountBy(thumbUpRecParam)));
            } else {
                replyBO.setThumbUpCount(Integer.valueOf(0));
            }
            if (replyBO.getThumbUpCount() > 0) {
                this.getUserLikeType(currentMemId, replyBO);
            }
            if (saveRedis) {
                if (addUpperReply) {
                    upperReplyIdTuples.add((ZSetOperations.TypedTuple<Object>)new DefaultTypedTuple((Object)replyBO.getReplyId(), Double.valueOf(replyBO.getReplyTime().getTime())));
                } else {
                    Set childIds = (Set)childReplyIdMap.get(replyBO.getUpperReplyId().toString());
                    childIds.add(replyBO.getReplyId());
                }
                replyInfoMap.put(replyBO.getReplyId(), replyBO);
            }
            if (CollectionUtils.isEmpty((Collection)replyBO.getChildReplyList())) continue;
            if (saveRedis) {
                childReplyIdMap.put(replyBO.getReplyId(), Sets.newHashSetWithExpectedSize((int)30));
            }
            this.handleReplyListProcess(upperReplyIdTuples, childReplyIdMap, replyInfoMap, replyBO.getChildReplyList(), resortByLike, currentMemId);
        }
        if (resortByLike) {
            replyList.sort(Comparator.comparingInt(ReplyBO::getThumbUpCount).reversed());
        }
    }

    private void saveReplyListIntoRedis(String redisKey, int redisListSize, int saveSize, int totalCount, Set<ZSetOperations.TypedTuple<Object>> upperReplyIdTuples, Map<String, Object> childReplyIdMap, Map<String, Object> replyInfoMap) {
        if (redisListSize + saveSize > 30) {
            this.redisUtil.zRemoveRange(redisKey, 0L, redisListSize + saveSize - 30 - 1);
        }
        this.redisUtil.zAddTuple(redisKey, upperReplyIdTuples, UecRedisConstant.getExpireMinutes(10, 10));
        this.redisUtil.hashMapSet("uec_reply_child_ids_", childReplyIdMap, UecRedisConstant.getExpireMinutes(10, 60));
        replyInfoMap.put(redisKey + "_totalRecords", totalCount);
        this.redisUtil.hashMapSet("uec_reply_list_", replyInfoMap, UecRedisConstant.getExpireMinutes(10, 30));
    }

    private void getUserLikeType(Long currentMemId, ReplyBO replyBO) {
        if (currentMemId != null) {
            Set<Object> likeMemIds = this.redisUtil.sGet("uec_reply_like_" + replyBO.getReplyId());
            if (!CollectionUtils.isEmpty(likeMemIds)) {
                Optional<Object> isLike = likeMemIds.stream().filter(memId -> String.valueOf(memId).equals(String.valueOf(currentMemId))).findAny();
                replyBO.setUserLikeType(isLike.isPresent() ? UecCommonConstant.YES_FLAG : null);
            } else {
                ReplyThumbUpRecPO thumbUpRecParam = new ReplyThumbUpRecPO();
                thumbUpRecParam.setReplyId(Long.parseLong(replyBO.getReplyId()));
                thumbUpRecParam.setState(UecCommonConstant.StateEnum.YES.value);
                thumbUpRecParam.setThumbUpType(UecCommonConstant.ThumbUpEnum.YES.value);
                thumbUpRecParam.setMemId(currentMemId.toString());
                int thumbUpCount = this.replyThumbUpRecMapper.getCountBy(thumbUpRecParam);
                if (thumbUpCount > 0) {
                    replyBO.setUserLikeType(UecCommonConstant.YES_FLAG);
                    this.redisUtil.sSet("uec_reply_like_" + replyBO.getReplyId(), UecRedisConstant.getExpireMinutes(10, 60), currentMemId.toString());
                } else {
                    replyBO.setUserLikeType(null);
                }
            }
        }
    }
}

