/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uec.atom.UecEvaluateUpdateAtomService;
import com.tydic.uec.atom.bo.UecEvaluateUpdateAtomReqBO;
import com.tydic.uec.atom.bo.UecEvaluateUpdateAtomRspBO;
import com.tydic.uec.busi.UecEvaluateAuditBusiService;
import com.tydic.uec.busi.bo.UecEvaluateAuditBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateAuditBusiRspBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.exception.BusinessException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UecEvaluateAuditBusiServiceImpl
implements UecEvaluateAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(UecEvaluateAuditBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UecEvaluateUpdateAtomService uecEvaluateUpdateAtomService;
    @Autowired
    private EvaMapper evaMapper;

    @Override
    public UecEvaluateAuditBusiRspBO dealEvaluateAudit(UecEvaluateAuditBusiReqBO busiReqBO) {
        busiReqBO.getEvaIds().forEach(evaId -> {
            Boolean finish = this.getApprovalResult(busiReqBO, (Long)evaId);
            if (finish.booleanValue()) {
                UecEvaluateUpdateAtomReqBO atomReqBO = new UecEvaluateUpdateAtomReqBO();
                atomReqBO.setEvaId((Long)evaId);
                if (busiReqBO.getAuditResult() == 1) {
                    atomReqBO.setEvaState(UecCommonConstant.StateEnum.YES.value);
                } else {
                    atomReqBO.setEvaState(UecCommonConstant.StateEnum.NO.value);
                }
                UecEvaluateUpdateAtomRspBO atomRspBO = this.uecEvaluateUpdateAtomService.updateEvaluateInfo(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
                }
            }
        });
        UecEvaluateAuditBusiRspBO busiRspBO = new UecEvaluateAuditBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u5ba1\u6279\u6210\u529f");
        return busiRspBO;
    }

    private Boolean getApprovalResult(UecEvaluateAuditBusiReqBO reqBO, Long evaId) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(evaId);
        auditReqBO.setObjId(objIdList);
        Integer objType = UecCommonConstant.AuditObjType.ORDER_AUDIT;
        String stepId = this.evaMapper.selectStepId(evaId, objType);
        auditReqBO.setStepId(stepId);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new BusinessException(auditRspBO.getRespCode(), auditRspBO.getRespDesc());
        }
        return auditRspBO.getNoneInstanceBO().getFinish();
    }
}

