/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uec.atom.UecEvaCreateCheckService;
import com.tydic.uec.atom.bo.UecEvaCreateCheckReqBO;
import com.tydic.uec.atom.bo.UecEvaCreateCheckRspBO;
import com.tydic.uec.busi.UecEvaluateCreateBusiService;
import com.tydic.uec.busi.bo.UecEvaluateCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateCreateBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaAddInfo;
import com.tydic.uec.common.bo.eva.EvaExtBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.common.bo.eva.EvaPicBO;
import com.tydic.uec.common.bo.eva.EvaStarLevelBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaBaseExtMapper;
import com.tydic.uec.dao.EvaExtMapper;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.dao.EvaPicMapper;
import com.tydic.uec.dao.EvaStarLevelMapper;
import com.tydic.uec.dao.po.EvaBaseExtPO;
import com.tydic.uec.dao.po.EvaExtPO;
import com.tydic.uec.dao.po.EvaPO;
import com.tydic.uec.dao.po.EvaPicPO;
import com.tydic.uec.dao.po.EvaStarLevelPO;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.CommonMethodUtil;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecEvaluateCreateBusiServiceImpl
implements UecEvaluateCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UecEvaluateCreateBusiServiceImpl.class);
    private final UecEvaCreateCheckService uecEvaCreateCheckService;
    private final EvaMapper evaMapper;
    private final EvaStarLevelMapper evaStarLevelMapper;
    private final EvaPicMapper evaPicMapper;
    private final EvaBaseExtMapper evaBaseExtMapper;
    private final EvaExtMapper evaExtMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;

    @Autowired
    public UecEvaluateCreateBusiServiceImpl(UecEvaCreateCheckService uecEvaCreateCheckService, EvaMapper evaMapper, EvaStarLevelMapper evaStarLevelMapper, EvaPicMapper evaPicMapper, EvaBaseExtMapper evaBaseExtMapper, EvaExtMapper evaExtMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.uecEvaCreateCheckService = uecEvaCreateCheckService;
        this.evaMapper = evaMapper;
        this.evaStarLevelMapper = evaStarLevelMapper;
        this.evaPicMapper = evaPicMapper;
        this.evaBaseExtMapper = evaBaseExtMapper;
        this.evaExtMapper = evaExtMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateCreateBusiRspBO createEvaluate(UecEvaluateCreateBusiReqBO reqBO) {
        Date upperEvaDate = this.checkEvaValid(reqBO);
        Long evaId = this.generateIdUtil.nextId();
        this.invokeUacNoTask(reqBO, evaId);
        EvaPO evaPO = new EvaPO();
        BeanUtils.copyProperties((Object)reqBO.getEvaBaseInfo(), (Object)evaPO);
        evaPO.setEvaId(evaId);
        this.evaMapper.insert(evaPO);
        if (StringUtils.isNotBlank((String)reqBO.getEvaContent())) {
            EvaBaseExtPO evaBaseExtPO = new EvaBaseExtPO();
            evaBaseExtPO.setEvaId(evaId);
            evaBaseExtPO.setEvaContent(reqBO.getEvaContent());
            this.evaBaseExtMapper.insert(evaBaseExtPO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getStarLevelList())) {
            this.insertStarLevelList(reqBO.getStarLevelList(), evaId);
        }
        if (!CollectionUtils.isEmpty(reqBO.getPicList())) {
            this.insertPicList(reqBO.getPicList(), evaId);
        }
        if (!CollectionUtils.isEmpty(reqBO.getExtList())) {
            this.insertExtList(reqBO.getExtList(), evaId);
        }
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getEvaBaseInfo().getEvaState())) {
            if (UecCommonConstant.EvaAct.EVALUATE.equals(reqBO.getEvaBaseInfo().getEvaAct())) {
                this.saveEvaInfoIntoRedis(reqBO, evaPO);
            } else if (UecCommonConstant.EvaAct.ADD_EVALUATE.equals(reqBO.getEvaBaseInfo().getEvaAct())) {
                this.addUpperEvaToRedis(reqBO, evaId.toString(), upperEvaDate);
            }
        }
        if (UecCommonConstant.EvaAct.ADD_EVALUATE.equals(reqBO.getEvaBaseInfo().getEvaAct())) {
            this.redisUtil.del("uec_eva_detail_" + reqBO.getEvaBaseInfo().getSysCode() + reqBO.getEvaBaseInfo().getBusiSn(), "uec_eva_detail_" + reqBO.getEvaBaseInfo().getSysCode() + "_busiSn#" + reqBO.getEvaBaseInfo().getBusiSn());
        }
        UecEvaluateCreateBusiRspBO rspBO = new UecEvaluateCreateBusiRspBO();
        rspBO.setEvaId(evaId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u8bc4\u4ef7\u6210\u529f");
        return rspBO;
    }

    private Date checkEvaValid(UecEvaluateCreateBusiReqBO reqBO) {
        Date upperEvaDate = null;
        if (UecCommonConstant.EvaAct.ADD_EVALUATE.equals(reqBO.getEvaBaseInfo().getEvaAct())) {
            UecEvaCreateCheckReqBO checkReqBO = new UecEvaCreateCheckReqBO();
            checkReqBO.setAddEva(true);
            checkReqBO.setUpperEvaId(reqBO.getEvaBaseInfo().getUpperEvaId());
            UecEvaCreateCheckRspBO checkRspBO = this.uecEvaCreateCheckService.checkEvaValid(checkReqBO);
            if (!"0000".equals(checkRspBO.getRespCode())) {
                throw new BusinessException(checkRspBO.getRespCode(), checkRspBO.getRespDesc());
            }
            upperEvaDate = checkRspBO.getUpperEvaDate();
        } else if (UecCommonConstant.EvaAct.SHOW.equals(reqBO.getEvaBaseInfo().getEvaAct())) {
            UecEvaCreateCheckReqBO checkReqBO = new UecEvaCreateCheckReqBO();
            checkReqBO.setAddEva(false);
            checkReqBO.setUpperEvaId(reqBO.getEvaBaseInfo().getUpperEvaId());
            UecEvaCreateCheckRspBO checkRspBO = this.uecEvaCreateCheckService.checkEvaValid(checkReqBO);
            if (!"0000".equals(checkRspBO.getRespCode())) {
                throw new BusinessException(checkRspBO.getRespCode(), checkRspBO.getRespDesc());
            }
            upperEvaDate = checkRspBO.getUpperEvaDate();
        } else {
            reqBO.getEvaBaseInfo().setUpperEvaId(null);
        }
        return upperEvaDate;
    }

    private void insertStarLevelList(List<EvaStarLevelBO> starLevelList, Long evaId) {
        ArrayList<EvaStarLevelPO> insertList = new ArrayList<EvaStarLevelPO>(starLevelList.size());
        for (EvaStarLevelBO evaStarLevel : starLevelList) {
            EvaStarLevelPO insertPo = new EvaStarLevelPO();
            BeanUtils.copyProperties((Object)evaStarLevel, (Object)insertPo);
            insertPo.setId(this.generateIdUtil.nextId());
            insertPo.setEvaId(evaId);
            insertList.add(insertPo);
        }
        this.evaStarLevelMapper.insertBatch(insertList);
    }

    private void insertPicList(List<EvaPicBO> picList, Long evaId) {
        ArrayList<EvaPicPO> insertList = new ArrayList<EvaPicPO>(picList.size());
        for (EvaPicBO evaPic : picList) {
            EvaPicPO insertPo = new EvaPicPO();
            BeanUtils.copyProperties((Object)evaPic, (Object)insertPo);
            insertPo.setId(this.generateIdUtil.nextId());
            insertPo.setEvaId(evaId);
            insertList.add(insertPo);
        }
        this.evaPicMapper.insertBatch(insertList);
    }

    private void insertExtList(List<EvaExtBO> extList, Long evaId) {
        ArrayList<EvaExtPO> insertList = new ArrayList<EvaExtPO>(extList.size());
        for (EvaExtBO evaExt : extList) {
            EvaExtPO insertPo = new EvaExtPO();
            BeanUtils.copyProperties((Object)evaExt, (Object)insertPo);
            insertPo.setId(this.generateIdUtil.nextId());
            insertPo.setEvaId(evaId);
            insertList.add(insertPo);
        }
        this.evaExtMapper.insertBatch(insertList);
    }

    private void saveEvaInfoIntoRedis(UecEvaluateCreateBusiReqBO reqBO, EvaPO evaPO) {
        String memKey = "uec_eva_list_" + evaPO.getSysCode() + "_memId#" + evaPO.getMemId();
        String objSuffix = evaPO.getSysCode() + "_objType#" + evaPO.getObjType() + "_objId#" + evaPO.getObjId();
        String objKey = "uec_eva_list_" + objSuffix;
        EvaListQryInfo evaInfo = new EvaListQryInfo();
        BeanUtils.copyProperties((Object)evaPO, (Object)evaInfo);
        evaInfo.setEvaId(evaPO.getEvaId().toString());
        evaInfo.setIsAddEva(UecCommonConstant.YES_FLAG);
        evaInfo.setEvaTime(new Date());
        evaInfo.setBrowseCount(Integer.valueOf(0));
        evaInfo.setLikeCount(Integer.valueOf(0));
        evaInfo.setReplyCount(Integer.valueOf(0));
        if (StringUtils.isNotBlank((String)evaInfo.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(evaInfo.getIsAnonymous())) {
            evaInfo.setMemName(evaInfo.getMemName().substring(0, 1) + "***" + evaInfo.getMemName().substring(evaInfo.getMemName().length() - 1));
        }
        if (UecCommonConstant.YES_FLAG.equals(evaInfo.getIsContentHide())) {
            evaInfo.setEvaContent("\u7528\u6237\u5df2\u9690\u85cf\u8be5\u8bc4\u4ef7\u5185\u5bb9");
        } else {
            evaInfo.setEvaContent(reqBO.getEvaContent());
        }
        evaInfo.setPicList(CollectionUtils.isEmpty(reqBO.getPicList()) ? new ArrayList() : reqBO.getPicList());
        if (!CollectionUtils.isEmpty(reqBO.getStarLevelList())) {
            evaInfo.setStarLevel(reqBO.getStarLevelList().get(0));
            this.redisUtil.hashDel("eva_total_count", objSuffix + "_like");
        }
        this.redisUtil.hashSet("uec_eva_list_", evaInfo.getEvaId(), evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
        this.redisUtil.hashAdd("uec_eva_list_", memKey + "_totalRecords", 1.0);
        this.redisUtil.hashAdd("uec_eva_list_", objKey + "_totalRecords", 1.0);
        this.redisUtil.hashAdd("eva_total_count", objSuffix, 1.0);
        Long memKeySize = this.redisUtil.zGetSize(memKey);
        Long objKeySize = this.redisUtil.zGetSize(objKey);
        if (memKeySize != null && memKeySize > 0L) {
            this.redisUtil.zAdd(memKey, evaInfo.getEvaId(), System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(20, 10));
        }
        if (objKeySize != null && objKeySize > 0L) {
            this.redisUtil.zAdd(objKey, evaInfo.getEvaId(), System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(20, 10));
        }
    }

    private void addUpperEvaToRedis(UecEvaluateCreateBusiReqBO reqBO, String evaId, Date upperEvaDate) {
        Object hashValue = this.redisUtil.hashGet("uec_eva_list_", reqBO.getEvaBaseInfo().getUpperEvaId().toString());
        if (hashValue != null) {
            Date currentDate = new Date();
            EvaListQryInfo evaInfo = (EvaListQryInfo)hashValue;
            EvaAddInfo evaAddInfo = new EvaAddInfo();
            evaAddInfo.setIntervalDays(Integer.valueOf(CommonMethodUtil.getDay(upperEvaDate, currentDate)));
            evaAddInfo.setEvaId(evaId);
            evaAddInfo.setEvaTime(currentDate);
            if (UecCommonConstant.YES_FLAG.equals(reqBO.getEvaBaseInfo().getIsContentHide())) {
                evaAddInfo.setEvaContent("\u7528\u6237\u5df2\u9690\u85cf\u8be5\u8bc4\u4ef7\u5185\u5bb9");
            } else {
                evaAddInfo.setEvaContent(reqBO.getEvaContent());
            }
            evaAddInfo.setPicList(reqBO.getPicList());
            evaInfo.setAddEvaInfo(evaAddInfo);
            evaInfo.setIsAddEva(UecCommonConstant.NO_FLAG);
            this.redisUtil.hashSet("uec_eva_list_", reqBO.getEvaBaseInfo().getUpperEvaId().toString(), evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
        }
    }

    private void invokeUacNoTask(UecEvaluateCreateBusiReqBO busiReqBO, Long evaId) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("evaAuditMenuId");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(UecCommonConstant.AuditObjType.ORDER_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(evaId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(evaId.toString());
        approvalObjBO.setObjName("\u8bc4\u4ef7\u5ba1\u6279");
        approvalObjBO.setObjType(UecCommonConstant.AuditObjType.ORDER_AUDIT);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (!uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue() && !uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            busiReqBO.getEvaBaseInfo().setEvaState(UecCommonConstant.StateEnum.APPROVING.value);
        } else {
            busiReqBO.getEvaBaseInfo().setEvaState(UecCommonConstant.StateEnum.YES.value);
        }
    }
}

