/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.uic.atom.api.UicDealApprovalAtomService;
import com.tydic.uic.busi.api.UicInsureApproveBusiService;
import com.tydic.uic.busi.bo.UicAddOrderPolicyInfoReqBO;
import com.tydic.uic.busi.bo.UicAddPolicyInfoReqBO;
import com.tydic.uic.busi.bo.UicAddVehicleRiskReqBO;
import com.tydic.uic.busi.bo.UicInsureApproveBusiReqBO;
import com.tydic.uic.busi.bo.UicInsureApproveBusiRspBO;
import com.tydic.uic.busi.bo.UicInvoiceInfoReqBO;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.dao.UicInsuranceMapper;
import com.tydic.uic.dao.UicInvoiceAddressMapper;
import com.tydic.uic.dao.UicInvoiceMapper;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.po.EacRuTaskPO;
import com.tydic.uic.po.UicCarPO;
import com.tydic.uic.po.UicInvoiceAddressPO;
import com.tydic.uic.po.UicInvoicePO;
import com.tydic.uic.po.UicOrderPO;
import com.tydic.uic.po.UicOrderRelationPO;
import com.tydic.uic.utils.HttpUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UicInsureApproveBusiServiceImpl
implements UicInsureApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicInsureApproveBusiServiceImpl.class);
    @Autowired
    private UicOrderMapper uicOrderMapper;
    @Autowired
    private UicDealApprovalAtomService uicDealApprovalAtomService;
    @Autowired
    private UicInvoiceMapper uicInvoiceMapper;
    @Autowired
    private UicCarMapper uicCarMapper;
    @Autowired
    private UicInvoiceAddressMapper uicInvoiceAddressMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;
    @Autowired
    private UicInsuranceMapper uicInsuranceMapper;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Value(value="${ESB_ACCESS_IP}")
    private String ADDRESS;
    private static final String SERVICE = "/OSN/api/addorderpolicy/v1";
    private static final String CODE_SUCCESS = "0";

    @Override
    public UicInsureApproveBusiRspBO insureApprove(UicInsureApproveBusiReqBO reqBO) {
        int i;
        EacRuTaskPO ruTaskPO;
        UicInsureApproveBusiRspBO rspBO = new UicInsureApproveBusiRspBO();
        EacApproveAbilityReqBO approveAbilityReqBO = new EacApproveAbilityReqBO();
        ArrayList<EacApproveAbilityReqInfoBO> data = new ArrayList<EacApproveAbilityReqInfoBO>();
        EacApproveAbilityReqInfoBO infoBO = new EacApproveAbilityReqInfoBO();
        Long taskId = this.uicOrderMapper.selectTaskId(reqBO.getOrderId(), reqBO.getUserId());
        infoBO.setTaskId(taskId);
        infoBO.setApproveAdvice(reqBO.getApproveOpinion());
        infoBO.setApproveResult(reqBO.getApproveResult() == 0 ? "pass" : "reject");
        data.add(infoBO);
        approveAbilityReqBO.setData(data);
        log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveAbilityReqBO));
        EacApproveAbilityRspBO approveAbilityRspBO = this.eacRuTaskAbilityService.approve(approveAbilityReqBO);
        log.info("\u5ba1\u6279\u6d41\u7a0b\u6d41\u8f6c\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)approveAbilityRspBO));
        EacApproveAbilityRspInfoBO rspInfoBO = (EacApproveAbilityRspInfoBO)approveAbilityRspBO.getData().get(0);
        if ("true".equals(rspInfoBO.getLinkJudge()) && rspInfoBO.getIsFinish().booleanValue()) {
            ruTaskPO = new EacRuTaskPO();
            ruTaskPO.setBusinessId(String.valueOf(reqBO.getOrderId()));
            ruTaskPO.setStatus("2");
            int i1 = this.uicOrderMapper.updateEac(ruTaskPO);
            ruTaskPO.setStatus("1");
            ruTaskPO.setTaskId(taskId);
            int n = this.uicOrderMapper.updateEacUserId(ruTaskPO);
        }
        if ("undetermined".equals(rspInfoBO.getLinkJudge())) {
            ruTaskPO = new EacRuTaskPO();
            ruTaskPO.setBusinessId(String.valueOf(reqBO.getOrderId()));
            ruTaskPO.setTaskId(taskId);
            if (reqBO.getApproveResult() == 1) {
                ruTaskPO.setStatus("2");
            } else {
                ruTaskPO.setStatus("1");
            }
            int i2 = this.uicOrderMapper.updateEacUserId(ruTaskPO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5ba1\u6279\u6210\u529f,\u5f85\u5176\u4ed6\u5ba1\u6279\u4eba\u5904\u7406");
            return rspBO;
        }
        UicOrderPO uicOrderPO = new UicOrderPO();
        uicOrderPO.setOrderId(reqBO.getOrderId());
        uicOrderPO.setAuditResult(reqBO.getApproveResult());
        uicOrderPO.setAuditAdvice(reqBO.getApproveOpinion());
        if (reqBO.getApproveResult() == 0) {
            uicOrderPO.setApproveStatus(2);
        }
        if (reqBO.getApproveResult() == 1) {
            uicOrderPO.setApproveStatus(3);
            uicOrderPO.setStatus(5);
        }
        if (1 != (i = this.uicOrderMapper.updateByPrimaryKeySelective(uicOrderPO))) {
            throw new ZTBusinessException("\u66f4\u65b0\u62a5\u5355\u8868\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6295\u4fdd\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void newOrderInsurance(UicInsureApproveBusiReqBO reqBO) {
        UicOrderPO uicOrderPO = this.uicOrderMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicCarPO uicCarPO = new UicCarPO();
        uicCarPO.setCarNo(uicOrderPO.getCarNo());
        List<UicCarPO> uicCarPOS = this.uicCarMapper.selectByCarNo(uicCarPO);
        List<UicOrderRelationPO> uicOrderRelationPOS = this.uicOrderRelationMapper.selectByList(reqBO.getOrderId());
        UicInvoicePO uicInvoicePO = this.uicInvoiceMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicInvoiceAddressPO uicInvoiceAddressPO = this.uicInvoiceAddressMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicAddOrderPolicyInfoReqBO infoReqBO = new UicAddOrderPolicyInfoReqBO();
        infoReqBO.setMerchOrderNo(uicOrderPO.getOrderNo());
        infoReqBO.setPlateNo(uicOrderPO.getCarNo());
        infoReqBO.setMerchVehicleInfoNo(uicCarPOS.get(0).getCarId() + "");
        infoReqBO.setInsuranceCompany(this.uicInsuranceMapper.selectByCompany());
        infoReqBO.setOrderStatus(1);
        UicInvoiceInfoReqBO infoReqBO1 = new UicInvoiceInfoReqBO();
        if (CODE_SUCCESS.equals(uicInvoicePO.getInvoiceType())) {
            infoReqBO1.setInvoiceType(1);
        } else {
            infoReqBO1.setInvoiceType(2);
        }
        infoReqBO1.setTin(uicInvoicePO.getTaxpayerId());
        infoReqBO1.setCompanyName(uicOrderPO.getInsureOrgName());
        infoReqBO1.setRegisterAddress(uicInvoicePO.getAddress());
        infoReqBO1.setRegisterPhone(uicInvoicePO.getPhone());
        infoReqBO1.setDepositBank(uicInvoicePO.getBank());
        infoReqBO1.setBankAccount(uicInvoicePO.getAccount());
        infoReqBO1.setReceiverName(uicInvoiceAddressPO.getName());
        infoReqBO1.setReceiverPhone(uicInvoiceAddressPO.getTel());
        String address = uicInvoiceAddressPO.getProvinceName() + uicInvoiceAddressPO.getCityName() + uicInvoiceAddressPO.getCountyName() + uicInvoiceAddressPO.getTownName() + uicInvoiceAddressPO.getAddrDesc();
        infoReqBO1.setReceiverAddress(address);
        infoReqBO.setInvoiceInfo(infoReqBO1);
        ArrayList<UicAddPolicyInfoReqBO> intgPolicyInfoList = new ArrayList<UicAddPolicyInfoReqBO>();
        ArrayList<UicAddVehicleRiskReqBO> boList1 = new ArrayList<UicAddVehicleRiskReqBO>();
        ArrayList<UicAddVehicleRiskReqBO> boList2 = new ArrayList<UicAddVehicleRiskReqBO>();
        uicOrderRelationPOS.forEach(obj -> {
            UicAddVehicleRiskReqBO riskBO = new UicAddVehicleRiskReqBO();
            riskBO.setPlateNo(uicOrderPO.getCarNo());
            riskBO.setRiskCode(obj.getInsuranceCode());
            riskBO.setRiskName(obj.getInsuranceName());
            String sumInsured = obj.getSumInsured();
            if (sumInsured.contains("\u4e07")) {
                riskBO.setSumInsured(sumInsured.substring(0, sumInsured.lastIndexOf("\u4e07")) + "0000");
            } else {
                riskBO.setSumInsured(sumInsured);
            }
            riskBO.setAerDesc(obj.getAer() == 1 ? "\u662f" : "\u5426");
            if (obj.getInsuranceType() == 1 && !"1".equals(obj.getSumInsured())) {
                boList1.add(riskBO);
            }
            if (obj.getInsuranceType() == 2) {
                boList2.add(riskBO);
            }
        });
        UicAddPolicyInfoReqBO bo1 = new UicAddPolicyInfoReqBO();
        bo1.setPlateNo(uicOrderPO.getCarNo());
        bo1.setPolicyType(1);
        bo1.setVehicleRiskList(boList2);
        bo1.setPolicyStatus(1);
        intgPolicyInfoList.add(bo1);
        UicAddPolicyInfoReqBO bo2 = new UicAddPolicyInfoReqBO();
        bo2.setPlateNo(uicOrderPO.getCarNo());
        bo2.setPolicyType(2);
        bo2.setVehicleRiskList(boList1);
        bo2.setPolicyStatus(1);
        intgPolicyInfoList.add(bo2);
        infoReqBO.setIntgPolicyInfoList(intgPolicyInfoList);
        log.info("\u8bf7\u6c42\u5730\u5740: " + this.ADDRESS + SERVICE);
        log.info("\u8bf7\u6c42\u53c2\u6570: " + JSON.toJSONString((Object)infoReqBO));
        String s = HttpUtil.doPost(this.ADDRESS + SERVICE, JSON.toJSONString((Object)infoReqBO));
        log.info("\u8bf7\u6c42\u51fa\u53c2\uff1a" + s);
        JSONObject obj2 = JSON.parseObject((String)s);
        if (!s.contains("code") || !CODE_SUCCESS.equals(obj2.getString("code"))) {
            throw new ZTBusinessException(obj2.getString("\u65b0\u589e\u8ba2\u5355\u4fdd\u9669\u5931\u8d25"));
        }
    }
}

