/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.uic.busi.api.UicQueryCarListBusiService;
import com.tydic.uic.busi.bo.UicQueryCarListBusiReqBO;
import com.tydic.uic.busi.bo.UicQueryCarListBusiRspBO;
import com.tydic.uic.car.ability.bo.UicCarInfoBO;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.po.UicCarPO;
import com.tydic.uic.utils.UicTransFieldUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UicQueryCarListBusiServiceImpl
implements UicQueryCarListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicQueryCarListBusiServiceImpl.class);
    @Autowired
    private UicCarMapper uicCarMapper;

    @Override
    public UicQueryCarListBusiRspBO queryCarList(UicQueryCarListBusiReqBO reqBO) {
        UicQueryCarListBusiRspBO rspBO = new UicQueryCarListBusiRspBO();
        UicCarPO uicCarPO = new UicCarPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uicCarPO);
        if (reqBO.getFlag().booleanValue()) {
            uicCarPO.setOrgId(null);
        }
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.uicCarMapper.selectByConditionByPage(uicCarPO));
        log.info("page " + page.getPageNum() + "recordsTotal " + page.getTotal() + "total " + page.getPages());
        rspBO.setPageNo(page.getPageNum());
        rspBO.setTotal(page.getPages());
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        rspBO.setRows(this.trans(page.getResult()));
        rspBO.setRespDesc("\u8f66\u8f86\u7ba1\u7406\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private List<UicCarInfoBO> trans(List<UicCarPO> uicCarPOS) {
        if (CollectionUtils.isEmpty(uicCarPOS)) {
            return null;
        }
        String s = JSON.toJSONString(uicCarPOS);
        List uicCarInfoBOS = JSONArray.parseArray((String)s).toJavaList(UicCarInfoBO.class);
        uicCarInfoBOS.forEach(obj -> {
            obj.setStatusStr(obj.getStatus() == null ? "" : UicTransFieldUtil.tranUicCarStatus(obj.getStatus()));
            obj.setDisplacementTypeStr(obj.getDisplacementType() == null ? "" : UicTransFieldUtil.tranPassengerCarType(obj.getDisplacementType()));
            if (StringUtils.isEmpty((Object)obj.getApproveStatus()) || 3 == obj.getApproveStatus()) {
                obj.setFlag(Boolean.valueOf(true));
            } else {
                obj.setFlag(Boolean.valueOf(false));
            }
        });
        return uicCarInfoBOS;
    }
}

