/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.uic.busi.api.UicQueryInsuranceListBusiService;
import com.tydic.uic.busi.bo.UicQueryInsuranceListBusiReqBO;
import com.tydic.uic.busi.bo.UicQueryInsuranceListBusiRspBO;
import com.tydic.uic.dao.UicInsuranceMapper;
import com.tydic.uic.insurance.ability.bo.UicCoverageOptionBO;
import com.tydic.uic.insurance.ability.bo.UicInsuranceBO;
import com.tydic.uic.po.UicInsurancePO;
import com.tydic.uic.utils.UicTransFieldUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicQueryInsuranceListBusiServiceImpl
implements UicQueryInsuranceListBusiService {
    @Autowired
    private UicInsuranceMapper uicInsuranceMapper;

    @Override
    public UicQueryInsuranceListBusiRspBO queryInsuranceList(UicQueryInsuranceListBusiReqBO reqBO) {
        UicQueryInsuranceListBusiRspBO rspBO = new UicQueryInsuranceListBusiRspBO();
        UicInsurancePO uicInsurancePO = new UicInsurancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uicInsurancePO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.uicInsuranceMapper.selectListPage(uicInsurancePO));
        rspBO.setPageNo(page.getPageNum());
        rspBO.setTotal(page.getPages());
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        rspBO.setRows(this.trans(page.getResult()));
        rspBO.setRespDesc("\u9669\u79cd\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private List<UicInsuranceBO> trans(List<UicInsurancePO> uicInsurancePOS) {
        if (CollectionUtils.isEmpty(uicInsurancePOS)) {
            return null;
        }
        String s = JSON.toJSONString(uicInsurancePOS);
        List uicInsuranceBOS = JSONArray.parseArray((String)s).toJavaList(UicInsuranceBO.class);
        uicInsuranceBOS.forEach(obj -> {
            obj.setForceFlagStr(obj.getForceFlag() == null ? "" : UicTransFieldUtil.tranUicCaseClose(obj.getForceFlag()));
            obj.setStatusStr(obj.getStatus() == null ? "" : UicTransFieldUtil.tranUicCarStatus(obj.getStatus()));
            if (obj.getInsuranceType() == 1 && !StringUtils.isBlank((String)obj.getOptions())) {
                String[] split = obj.getOptions().split(",");
                ArrayList<UicCoverageOptionBO> list = new ArrayList<UicCoverageOptionBO>();
                for (int i = 0; i < split.length; ++i) {
                    UicCoverageOptionBO bo = new UicCoverageOptionBO();
                    bo.setId("1");
                    bo.setName(split[i]);
                    list.add(bo);
                }
                obj.setOptionList(list);
            }
        });
        return uicInsuranceBOS;
    }
}

