/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacRuTaskAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import com.tydic.uic.atom.api.UicStartApprovalProcessAtomService;
import com.tydic.uic.busi.api.UicSubmitInsureBusiService;
import com.tydic.uic.busi.bo.UicSubmitInsureBusiReqBO;
import com.tydic.uic.busi.bo.UicSubmitInsureBusiRspBO;
import com.tydic.uic.dao.UicAttachmentMapper;
import com.tydic.uic.dao.UicInvoiceAddressMapper;
import com.tydic.uic.dao.UicInvoiceMapper;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.po.EacRuTaskPO;
import com.tydic.uic.po.UicAttachmentPO;
import com.tydic.uic.po.UicInvoiceAddressPO;
import com.tydic.uic.po.UicInvoicePO;
import com.tydic.uic.po.UicOrderPO;
import com.tydic.uic.po.UicOrderRelationPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicSubmitInsureBusiServiceImpl
implements UicSubmitInsureBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicSubmitInsureBusiServiceImpl.class);
    @Autowired
    private UicOrderMapper uicOrderMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;
    @Autowired
    private UicInvoiceMapper uicInvoiceMapper;
    @Autowired
    private UicInvoiceAddressMapper uicInvoiceAddressMapper;
    @Autowired
    private UicAttachmentMapper uicAttachmentMapper;
    @Autowired
    private UicStartApprovalProcessAtomService uicStartApprovalProcessAtomService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    public static final String PROCESS = "\u6295\u4fdd\u63d0\u4ea4\u5ba1\u6279";

    @Override
    public UicSubmitInsureBusiRspBO submitInsure(UicSubmitInsureBusiReqBO reqBO) {
        UicSubmitInsureBusiRspBO rspBO = new UicSubmitInsureBusiRspBO();
        if (reqBO.getOrderId() != null) {
            log.info("\u518d\u6b21\u6295\u4fdd " + reqBO.getOrderId());
            UicSubmitInsureBusiReqBO busiReqBO = this.approveStart(reqBO);
            this.updateOrder(busiReqBO);
        } else {
            log.info("\u7b2c\u4e00\u6b21\u6295\u4fdd " + reqBO.getOrderId());
            Long orderId = Sequence.getInstance().nextId();
            reqBO.setOrderId(orderId);
            UicSubmitInsureBusiReqBO busiReqBO = this.approveStart(reqBO);
            this.insertOrder(busiReqBO);
        }
        this.insertAll(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6295\u4fdd\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }

    private UicSubmitInsureBusiReqBO approveStart(UicSubmitInsureBusiReqBO reqBO) {
        EacStartProjectAbilityReqBO startProjectReqBO = new EacStartProjectAbilityReqBO();
        ArrayList<String> busumesslist = new ArrayList<String>();
        busumesslist.add(String.valueOf(reqBO.getOrderId()));
        startProjectReqBO.setBusinessIdList(busumesslist);
        startProjectReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        startProjectReqBO.setBusinessType("1");
        log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)startProjectReqBO));
        EacStartProjectAbilityRspBO startProjectAbilityRspBO = this.eacProjectAbilityService.startProject(startProjectReqBO);
        log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)startProjectAbilityRspBO));
        if (!startProjectAbilityRspBO.getRespCode().equals("0000")) {
            throw new ZTBusinessException(startProjectAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)startProjectAbilityRspBO.getData())) {
            throw new ZTBusinessException("\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2\u4e3a\u7a7a");
        }
        EacStartProjectAbilityRspInfoBO rspInfoBO = (EacStartProjectAbilityRspInfoBO)startProjectAbilityRspBO.getData().get(0);
        List taskList = rspInfoBO.getTaskList();
        taskList.forEach(obj -> {
            EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
            BeanUtils.copyProperties((Object)obj, (Object)eacRuTaskPO);
            Long nextId = Sequence.getInstance().nextId();
            eacRuTaskPO.setStatus("0");
            eacRuTaskPO.setId(nextId);
            int i = this.uicOrderMapper.insertSelectiveEac(eacRuTaskPO);
            if (i < 1) {
                throw new ZTBusinessException("\u65b0\u589e\u4efb\u52a1\u5217\u8868\u4fe1\u606f\u5931\u8d25");
            }
        });
        reqBO.setStepId(String.valueOf(rspInfoBO.getApproveInstId()));
        reqBO.setAuditOrderId(((EacRuTaskAbilityBO)taskList.get(0)).getTaskId());
        return reqBO;
    }

    private void insertAll(UicSubmitInsureBusiReqBO reqBO) {
        this.insertOrderDetail(reqBO);
        this.insertInvoice(reqBO);
        this.insertAddress(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentInfos())) {
            this.insertAttachemnt(reqBO);
        }
    }

    private void insertOrder(UicSubmitInsureBusiReqBO reqBO) {
        UicOrderPO uicOrderPO = new UicOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uicOrderPO);
        uicOrderPO.setOrderNo(Sequence.getInstance().nextId() + "");
        uicOrderPO.setApproveStatus(1);
        uicOrderPO.setStatus(1);
        uicOrderPO.setCreateTime(new Date());
        uicOrderPO.setCreateUserId(reqBO.getUserId());
        uicOrderPO.setCreateUserName(reqBO.getUserName());
        uicOrderPO.setInsureOrgId(reqBO.getOrgId());
        uicOrderPO.setInsureOrgName(reqBO.getOrgName());
        uicOrderPO.setGenerateFlag(0);
        int i = this.uicOrderMapper.insertSelective(uicOrderPO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u4fdd\u5355\u8868\u5931\u8d25");
        }
    }

    private void updateOrder(UicSubmitInsureBusiReqBO reqBO) {
        UicOrderPO uicOrderPO = new UicOrderPO();
        uicOrderPO.setOrderId(reqBO.getOrderId());
        uicOrderPO.setApproveStatus(1);
        uicOrderPO.setStatus(1);
        uicOrderPO.setCreateUserId(reqBO.getUserId());
        uicOrderPO.setCreateUserName(reqBO.getUserName());
        uicOrderPO.setInsureOrgId(reqBO.getOrgId());
        uicOrderPO.setInsureOrgName(reqBO.getOrgName());
        uicOrderPO.setRemark(reqBO.getRemark());
        uicOrderPO.setDeliveryTime(reqBO.getDeliveryTime());
        uicOrderPO.setStepId(reqBO.getStepId());
        uicOrderPO.setAuditOrderId(reqBO.getAuditOrderId());
        int i = this.uicOrderMapper.updateByPrimaryKeySelective(uicOrderPO);
        if (1 != i) {
            throw new ZTBusinessException("\u4fee\u6539\u4fdd\u5355\u8868\u5931\u8d25");
        }
        this.uicOrderRelationMapper.deleteByPrimaryKey(reqBO.getOrderId());
    }

    private void insertOrderDetail(UicSubmitInsureBusiReqBO reqBO) {
        List<UicOrderRelationPO> poList = reqBO.getInsureItems().stream().map(obj -> {
            UicOrderRelationPO uicOrderRelationPO = new UicOrderRelationPO();
            BeanUtils.copyProperties((Object)obj, (Object)uicOrderRelationPO);
            uicOrderRelationPO.setOrderId(reqBO.getOrderId());
            uicOrderRelationPO.setId(Sequence.getInstance().nextId());
            return uicOrderRelationPO;
        }).collect(Collectors.toList());
        int i = this.uicOrderRelationMapper.insertBatch(poList);
        if (i != poList.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u6295\u4fdd\u660e\u7ec6\u8868\u5931\u8d25");
        }
    }

    private void insertInvoice(UicSubmitInsureBusiReqBO reqBO) {
        UicInvoicePO uicInvoicePO = new UicInvoicePO();
        BeanUtils.copyProperties((Object)reqBO.getInvoiceInfo(), (Object)uicInvoicePO);
        uicInvoicePO.setInvoiceId(Sequence.getInstance().nextId());
        uicInvoicePO.setInvoiceType(String.valueOf(reqBO.getInvoiceInfo().getInvoiceType()));
        uicInvoicePO.setOrderId(reqBO.getOrderId());
        int i = this.uicInvoiceMapper.insertSelective(uicInvoicePO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u4fdd\u9669\u53d1\u7968\u8868\u5931\u8d25");
        }
    }

    private void insertAddress(UicSubmitInsureBusiReqBO reqBO) {
        UicInvoiceAddressPO uicInvoiceAddressPO = new UicInvoiceAddressPO();
        BeanUtils.copyProperties((Object)reqBO.getInvoiceAddressInfo(), (Object)uicInvoiceAddressPO);
        uicInvoiceAddressPO.setId(Sequence.getInstance().nextId());
        uicInvoiceAddressPO.setOrderId(reqBO.getOrderId());
        int i = this.uicInvoiceAddressMapper.insertSelective(uicInvoiceAddressPO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u4fdd\u5355\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8868\u5931\u8d25");
        }
    }

    private void insertAttachemnt(UicSubmitInsureBusiReqBO reqBO) {
        List<UicAttachmentPO> collect = reqBO.getAttachmentInfos().stream().map(obj -> {
            UicAttachmentPO uicAttachmentPO = new UicAttachmentPO();
            uicAttachmentPO.setAttachmentUrl(obj.getAttachmentUrl());
            uicAttachmentPO.setAttachmentName(obj.getAttachmentName());
            uicAttachmentPO.setRelateType(2);
            uicAttachmentPO.setRelateId(reqBO.getOrderId());
            uicAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
            return uicAttachmentPO;
        }).collect(Collectors.toList());
        int i = this.uicAttachmentMapper.insertBatch(collect);
        if (i != collect.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u9644\u4ef6\u4fe1\u606f\u8868\u5931\u8d25");
        }
    }
}

