/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.utils;

import com.google.common.collect.Lists;
import com.tydic.umc.security.utils.ExceptionHelper;
import com.tydic.umc.security.utils.Resources;
import com.tydic.umc.security.utils.UtilString;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilFile
extends Resources {
    private static Logger logger = LoggerFactory.getLogger(UtilFile.class);
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String getPathPart(String fileName) {
        int point = UtilFile.getPathLsatIndex(fileName);
        int length = fileName.length();
        if (point == -1) {
            return "";
        }
        if (point == length - 1) {
            int secondPoint = UtilFile.getPathLsatIndex(fileName, point - 1);
            if (secondPoint == -1) {
                return "";
            }
            return fileName.substring(0, secondPoint);
        }
        return fileName.substring(0, point);
    }

    public static String getNamePart(String fileName) {
        int point = UtilFile.getPathLsatIndex(fileName);
        int length = fileName.length();
        if (point == -1) {
            return fileName;
        }
        if (point == length - 1) {
            int secondPoint = UtilFile.getPathLsatIndex(fileName, point - 1);
            if (secondPoint == -1) {
                if (length == 1) {
                    return fileName;
                }
                return fileName.substring(0, point);
            }
            return fileName.substring(secondPoint, point);
        }
        return fileName.substring(point + 1, length);
    }

    public static String getTypePart(String fileName) {
        int point = fileName.lastIndexOf(46);
        int length = fileName.length();
        if (point == -1 || point == length - 1) {
            return "";
        }
        return fileName.substring(point, length);
    }

    private static int getPathLsatIndex(String fileName) {
        int point = fileName.lastIndexOf(47);
        if (point == -1) {
            point = fileName.lastIndexOf(92);
        }
        return point;
    }

    private static int getPathLsatIndex(String fileName, int fromIndex) {
        int point = fileName.lastIndexOf(47, fromIndex);
        if (point == -1) {
            point = fileName.lastIndexOf(92, fromIndex);
        }
        return point;
    }

    public static boolean exist(String path) {
        return new File(path).exists();
    }

    public static String read(InputStream is) throws IOException {
        return UtilFile.read(is, "utf-8");
    }

    public static String read(InputStream is, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder content = new StringBuilder();
        String data = null;
        while ((data = br.readLine()) != null) {
            content.append(data);
            content.append(LINE_SEPARATOR);
        }
        return content.toString();
    }

    public static long getSize(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                long size = 0L;
                File[] files = file.listFiles();
                if (files != null && files.length > 0) {
                    for (File f : files) {
                        size += UtilFile.getSize(f);
                    }
                }
                return size;
            }
            return file.length();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] readFile2Byte(String filePath) {
        byte[] buffer = null;
        FileInputStream fis = null;
        try {
            int n;
            File file = new File(filePath);
            fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
            if (fis == null) return buffer;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return buffer;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return buffer;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (fis != null) {
                IOUtils.closeQuietly(fis);
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return buffer;
    }

    public static String getContentType(String returnFileName) {
        String contentType = "application/octet-stream";
        if (returnFileName.lastIndexOf(".") < 0) {
            return contentType;
        }
        returnFileName = returnFileName.toLowerCase();
        if ((returnFileName = returnFileName.substring(returnFileName.lastIndexOf(".") + 1)).equals("html") || returnFileName.equals("htm") || returnFileName.equals("shtml")) {
            contentType = "text/html";
        } else if (returnFileName.equals("apk")) {
            contentType = "application/vnd.android.package-archive";
        } else if (returnFileName.equals("sis")) {
            contentType = "application/vnd.symbian.install";
        } else if (returnFileName.equals("sisx")) {
            contentType = "application/vnd.symbian.install";
        } else if (returnFileName.equals("exe")) {
            contentType = "application/x-msdownload";
        } else if (returnFileName.equals("msi")) {
            contentType = "application/x-msdownload";
        } else if (returnFileName.equals("css")) {
            contentType = "text/css";
        } else if (returnFileName.equals("xml")) {
            contentType = "text/xml";
        } else if (returnFileName.equals("gif")) {
            contentType = "image/gif";
        } else if (returnFileName.equals("jpeg") || returnFileName.equals("jpg")) {
            contentType = "image/jpeg";
        } else if (returnFileName.equals("js")) {
            contentType = "application/x-javascript";
        } else if (returnFileName.equals("atom")) {
            contentType = "application/atom+xml";
        } else if (returnFileName.equals("rss")) {
            contentType = "application/rss+xml";
        } else if (returnFileName.equals("mml")) {
            contentType = "text/mathml";
        } else if (returnFileName.equals("txt")) {
            contentType = "text/plain";
        } else if (returnFileName.equals("jad")) {
            contentType = "text/vnd.sun.j2me.app-descriptor";
        } else if (returnFileName.equals("wml")) {
            contentType = "text/vnd.wap.wml";
        } else if (returnFileName.equals("htc")) {
            contentType = "text/x-component";
        } else if (returnFileName.equals("png")) {
            contentType = "image/png";
        } else if (returnFileName.equals("tif") || returnFileName.equals("tiff")) {
            contentType = "image/tiff";
        } else if (returnFileName.equals("wbmp")) {
            contentType = "image/vnd.wap.wbmp";
        } else if (returnFileName.equals("ico")) {
            contentType = "image/x-icon";
        } else if (returnFileName.equals("jng")) {
            contentType = "image/x-jng";
        } else if (returnFileName.equals("bmp")) {
            contentType = "image/x-ms-bmp";
        } else if (returnFileName.equals("svg")) {
            contentType = "image/svg+xml";
        } else if (returnFileName.equals("jar") || returnFileName.equals("var") || returnFileName.equals("ear")) {
            contentType = "application/java-archive";
        } else if (returnFileName.equals("doc")) {
            contentType = "application/msword";
        } else if (returnFileName.equals("pdf")) {
            contentType = "application/pdf";
        } else if (returnFileName.equals("rtf")) {
            contentType = "application/rtf";
        } else if (returnFileName.equals("xls")) {
            contentType = "application/vnd.ms-excel";
        } else if (returnFileName.equals("ppt")) {
            contentType = "application/vnd.ms-powerpoint";
        } else if (returnFileName.equals("7z")) {
            contentType = "application/x-7z-compressed";
        } else if (returnFileName.equals("rar")) {
            contentType = "application/x-rar-compressed";
        } else if (returnFileName.equals("swf")) {
            contentType = "application/x-shockwave-flash";
        } else if (returnFileName.equals("rpm")) {
            contentType = "application/x-redhat-package-manager";
        } else if (returnFileName.equals("der") || returnFileName.equals("pem") || returnFileName.equals("crt")) {
            contentType = "application/x-x509-ca-cert";
        } else if (returnFileName.equals("xhtml")) {
            contentType = "application/xhtml+xml";
        } else if (returnFileName.equals("zip")) {
            contentType = "application/zip";
        } else if (returnFileName.equals("mid") || returnFileName.equals("midi") || returnFileName.equals("kar")) {
            contentType = "audio/midi";
        } else if (returnFileName.equals("mp3")) {
            contentType = "audio/mpeg";
        } else if (returnFileName.equals("ogg")) {
            contentType = "audio/ogg";
        } else if (returnFileName.equals("m4a")) {
            contentType = "audio/x-m4a";
        } else if (returnFileName.equals("ra")) {
            contentType = "audio/x-realaudio";
        } else if (returnFileName.equals("3gpp") || returnFileName.equals("3gp")) {
            contentType = "video/3gpp";
        } else if (returnFileName.equals("mp4")) {
            contentType = "video/mp4";
        } else if (returnFileName.equals("mpeg") || returnFileName.equals("mpg")) {
            contentType = "video/mpeg";
        } else if (returnFileName.equals("mov")) {
            contentType = "video/quicktime";
        } else if (returnFileName.equals("flv")) {
            contentType = "video/x-flv";
        } else if (returnFileName.equals("m4v")) {
            contentType = "video/x-m4v";
        } else if (returnFileName.equals("mng")) {
            contentType = "video/x-mng";
        } else if (returnFileName.equals("asx") || returnFileName.equals("asf")) {
            contentType = "video/x-ms-asf";
        } else if (returnFileName.equals("wmv")) {
            contentType = "video/x-ms-wmv";
        } else if (returnFileName.equals("avi")) {
            contentType = "video/x-msvideo";
        }
        return contentType;
    }

    public static String path(String path) {
        String p = UtilString.replace((String)path, (String)"\\", (String)"/");
        if (!UtilString.startsWithAny((CharSequence)(p = UtilString.join((Object[])UtilString.split((String)p, (String)"/"), (String)"/")), (CharSequence[])new CharSequence[]{"/"}) && UtilString.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"\\", "/"})) {
            p = p + "/";
        }
        if (!UtilString.endsWithAny((CharSequence)p, (CharSequence[])new CharSequence[]{"/"}) && UtilString.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"\\", "/"})) {
            p = p + "/";
        }
        if (path != null && path.startsWith("/")) {
            p = "/" + p;
        }
        return p;
    }

    public static List<String> findChildrenList(File dir, boolean searchDirs) {
        ArrayList files = Lists.newArrayList();
        for (String subFiles : dir.list()) {
            File file = new File(dir + "/" + subFiles);
            if ((!searchDirs || !file.isDirectory()) && (searchDirs || file.isDirectory())) continue;
            files.add(file.getName());
        }
        return files;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1 || fileName.lastIndexOf(".") == fileName.length() - 1) {
            return null;
        }
        return UtilString.lowerCase((String)fileName.substring(fileName.lastIndexOf(".") + 1));
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1) {
            return null;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static boolean copyFile(String srcFileName, String descFileName) {
        return UtilFile.copyFileCover(srcFileName, descFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileCover(String srcFileName, String descFileName, boolean coverlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 " + srcFileName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcFile.isFile()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c" + srcFileName + " \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6!");
            return false;
        }
        File descFile = new File(descFileName);
        if (descFile.exists()) {
            if (!coverlay) {
                logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!UtilFile.delFile(descFileName)) {
                logger.debug("\u5220\u9664\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5931\u8d25!");
                return false;
            }
        } else if (!descFile.getParentFile().exists()) {
            logger.debug("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u76ee\u5f55!");
            if (!descFile.getParentFile().mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        int readByte = 0;
        FileInputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new FileInputStream(srcFile);
            outs = new FileOutputStream(descFile);
            byte[] buf = new byte[1024];
            while ((readByte = ((InputStream)ins).read(buf)) != -1) {
                outs.write(buf, 0, readByte);
            }
            logger.debug("\u590d\u5236\u5355\u4e2a\u6587\u4ef6 " + srcFileName + " \u5230" + descFileName + "\u6210\u529f!");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (IOException oute) {
                    oute.printStackTrace();
                }
            }
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ine) {
                    ine.printStackTrace();
                }
            }
        }
    }

    public static boolean copyDirectory(String srcDirName, String descDirName) {
        return UtilFile.copyDirectoryCover(srcDirName, descDirName, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean copyDirectoryCover(String srcDirName, String descDirName, boolean coverlay) {
        File descDir;
        File srcDir = new File(srcDirName);
        if (!srcDir.exists()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c\u6e90\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcDir.isDirectory()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c" + srcDirName + " \u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55!");
            return false;
        }
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            if (!coverlay) {
                logger.debug("\u76ee\u6807\u76ee\u5f55\u590d\u5236\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!UtilFile.delFile(descDirNames)) {
                logger.debug("\u5220\u9664\u76ee\u5f55 " + descDirNames + " \u5931\u8d25!");
                return false;
            }
        } else {
            logger.debug("\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa!");
            if (!descDir.mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        boolean flag = true;
        File[] files = srcDir.listFiles();
        for (int i = 0; !(i >= files.length || files[i].isFile() && !(flag = UtilFile.copyFile(files[i].getAbsolutePath(), descDirName + files[i].getName())) || files[i].isDirectory() && !(flag = UtilFile.copyDirectory(files[i].getAbsolutePath(), descDirName + files[i].getName()))); ++i) {
        }
        if (!flag) {
            logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u5931\u8d25!");
            return false;
        }
        logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u6210\u529f!");
        return true;
    }

    public static boolean delFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            logger.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
            return true;
        }
        if (file.isFile()) {
            return UtilFile.deleteFile(fileName);
        }
        return UtilFile.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u6210\u529f!");
                return true;
            }
            logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u5931\u8d25!");
            return false;
        }
        logger.debug(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
        return true;
    }

    public static boolean deleteDirectory(String dirName) {
        File dirFile;
        String dirNames = dirName;
        if (!dirNames.endsWith(File.separator)) {
            dirNames = dirNames + File.separator;
        }
        if (!(dirFile = new File(dirNames)).exists() || !dirFile.isDirectory()) {
            logger.debug(dirNames + " \u76ee\u5f55\u4e0d\u5b58\u5728!");
            return true;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = UtilFile.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = UtilFile.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            logger.debug("\u5220\u9664\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        if (dirFile.delete()) {
            logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u6210\u529f!");
            return true;
        }
        logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u5931\u8d25!");
        return false;
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            logger.debug("\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descFileName.endsWith(File.separator)) {
            logger.debug(descFileName + " \u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55!");
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.debug("\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        try {
            if (file.createNewFile()) {
                logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f!");
                return true;
            }
            logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            return false;
        }
    }

    public static void writeFileByUTF8String(String filePathAndName, String buf) {
        try {
            UtilFile.writeFileByByte(filePathAndName, buf.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw ExceptionHelper.unchecked(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileByByte(String filePathAndName, byte[] buf) {
        FileOutputStream fos;
        block8: {
            UtilFile.createFile(filePathAndName);
            BufferedOutputStream bos = null;
            fos = null;
            File file = null;
            try {
                file = new File(filePathAndName);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(buf);
                if (bos == null) break block8;
            }
            catch (Exception e) {
                block9: {
                    try {
                        e.printStackTrace();
                        if (bos == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (bos != null) {
                            IOUtils.closeQuietly(bos);
                        }
                        if (fos != null) {
                            IOUtils.closeQuietly(fos);
                        }
                        throw throwable;
                    }
                    IOUtils.closeQuietly(bos);
                }
                if (fos != null) {
                    IOUtils.closeQuietly((OutputStream)fos);
                }
            }
            IOUtils.closeQuietly((OutputStream)bos);
        }
        if (fos != null) {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    public static void writeFileByUTF8String(String filePath, String fileName, String buf) {
        try {
            UtilFile.writeFileByByte(filePath, fileName, buf.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw ExceptionHelper.unchecked(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileByByte(String filePath, String fileName, byte[] buf) {
        block10: {
            FileOutputStream fos;
            block9: {
                BufferedOutputStream bos = null;
                fos = null;
                File file = null;
                try {
                    File dir = new File(filePath);
                    if (!dir.exists() && dir.isDirectory()) {
                        dir.mkdirs();
                    }
                    UtilFile.createFile(filePath + File.separator + fileName);
                    file = new File(filePath + File.separator + fileName);
                    fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos);
                    bos.write(buf);
                    if (bos == null) break block9;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block10;
                }
                finally {
                    if (bos != null) {
                        IOUtils.closeQuietly(bos);
                    }
                    if (fos != null) {
                        IOUtils.closeQuietly(fos);
                    }
                }
                IOUtils.closeQuietly((OutputStream)bos);
            }
            if (fos != null) {
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descDir.mkdirs()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u6210\u529f!");
            return true;
        }
        logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u5931\u8d25!");
        return false;
    }

    public static String downFile(File file, HttpServletRequest request, HttpServletResponse response) {
        return UtilFile.downFile(file, request, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downFile(File file, HttpServletRequest request, HttpServletResponse response, String fileName) {
        String error = null;
        if (file != null && file.exists()) {
            if (file.isFile()) {
                if (file.length() <= 0L) {
                    error = "\u8be5\u6587\u4ef6\u662f\u4e00\u4e2a\u7a7a\u6587\u4ef6\u3002";
                }
                if (!file.canRead()) {
                    error = "\u8be5\u6587\u4ef6\u6ca1\u6709\u8bfb\u53d6\u6743\u9650\u3002";
                }
            } else {
                error = "\u8be5\u6587\u4ef6\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\u3002";
            }
        } else {
            error = "\u6587\u4ef6\u5df2\u4e22\u5931\u6216\u4e0d\u5b58\u5728\uff01";
        }
        if (error != null) {
            logger.debug("---------------" + file + " " + error);
            return error;
        }
        long fileLength = file.length();
        long pastLength = 0L;
        int rangeSwitch = 0;
        long toLength = 0L;
        long contentLength = 0L;
        String rangeBytes = "";
        RandomAccessFile raf = null;
        ServletOutputStream os = null;
        OutputStream out = null;
        byte[] b = new byte[1024];
        if (request.getHeader("Range") != null) {
            response.setStatus(206);
            logger.debug("request.getHeader(\"Range\") = " + request.getHeader("Range"));
            rangeBytes = request.getHeader("Range").replaceAll("bytes=", "");
            if (rangeBytes.indexOf(45) == rangeBytes.length() - 1) {
                rangeSwitch = 1;
                rangeBytes = rangeBytes.substring(0, rangeBytes.indexOf(45));
                pastLength = Long.parseLong(rangeBytes.trim());
                contentLength = fileLength - pastLength;
            } else {
                rangeSwitch = 2;
                String temp0 = rangeBytes.substring(0, rangeBytes.indexOf(45));
                String temp2 = rangeBytes.substring(rangeBytes.indexOf(45) + 1, rangeBytes.length());
                pastLength = Long.parseLong(temp0.trim());
                toLength = Long.parseLong(temp2);
                contentLength = toLength - pastLength;
            }
        } else {
            contentLength = fileLength;
        }
        response.reset();
        if (pastLength != 0L) {
            response.setHeader("Accept-Ranges", "bytes");
            logger.debug("---------------\u4e0d\u662f\u4ece\u5f00\u59cb\u8fdb\u884c\u4e0b\u8f7d\uff01\u670d\u52a1\u5668\u5373\u5c06\u5f00\u59cb\u65ad\u70b9\u7eed\u4f20...");
            switch (rangeSwitch) {
                case 1: {
                    String contentRange = new StringBuffer("bytes ").append(new Long(pastLength).toString()).append("-").append(new Long(fileLength - 1L).toString()).append("/").append(new Long(fileLength).toString()).toString();
                    response.setHeader("Content-Range", contentRange);
                    break;
                }
                case 2: {
                    String contentRange = rangeBytes + "/" + new Long(fileLength).toString();
                    response.setHeader("Content-Range", contentRange);
                    break;
                }
            }
        } else {
            logger.debug("---------------\u662f\u4ece\u5f00\u59cb\u8fdb\u884c\u4e0b\u8f7d\uff01");
        }
        try {
            response.addHeader("Content-Disposition", "attachment; filename=\"" + UtilString.urlEncode(UtilString.isBlank((CharSequence)fileName) ? file.getName() : fileName) + "\"");
            response.setContentType(UtilFile.getContentType(file.getName()));
            response.addHeader("Content-Length", String.valueOf(contentLength));
            os = response.getOutputStream();
            out = new BufferedOutputStream((OutputStream)os);
            raf = new RandomAccessFile(file, "r");
            try {
                switch (rangeSwitch) {
                    case 0: 
                    case 1: {
                        raf.seek(pastLength);
                        int n = 0;
                        while ((n = raf.read(b, 0, 1024)) != -1) {
                            out.write(b, 0, n);
                        }
                        break;
                    }
                    case 2: {
                        long readLength;
                        raf.seek(pastLength);
                        int n = 0;
                        for (readLength = 0L; readLength <= contentLength - 1024L; readLength += 1024L) {
                            n = raf.read(b, 0, 1024);
                            out.write(b, 0, n);
                        }
                        if (readLength > contentLength) break;
                        n = raf.read(b, 0, (int)(contentLength - readLength));
                        out.write(b, 0, n);
                        break;
                    }
                }
                out.flush();
                logger.debug("---------------\u4e0b\u8f7d\u5b8c\u6210\uff01");
            }
            catch (IOException ie) {
                logger.warn("\u63d0\u9192\uff1a\u5411\u5ba2\u6237\u7aef\u4f20\u8f93\u65f6\u51fa\u73b0IO\u5f02\u5e38\uff0c\u4f46\u6b64\u5f02\u5e38\u662f\u5141\u8bb8\u7684\uff0c\u6709\u53ef\u80fd\u5ba2\u6237\u7aef\u53d6\u6d88\u4e86\u4e0b\u8f7d\uff0c\u5bfc\u81f4\u6b64\u5f02\u5e38\uff0c\u4e0d\u7528\u5173\u5fc3\uff01");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static InputStream byte2Input(byte[] byteData) {
        if (byteData.length > 0) {
            return new ByteArrayInputStream(byteData);
        }
        logger.info("byte\u6570\u7ec4\u8f6cInputStream \u6d41\u5f02\u5e38\uff0c\u4f20\u5165\u6570\u7ec4\u4e3a\u7a7a");
        return null;
    }

    public static byte[] input2byte(InputStream inStream) throws IOException {
        if (Objects.isNull(inStream)) {
            return new byte[0];
        }
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }
}

