/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryListAbilityService;
import com.tydic.contract.ability.bo.ContractQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryListAbilityRspBO;
import com.tydic.dyc.contract.api.DycContractQueryAgreeContractApprovalListService;
import com.tydic.dyc.contract.bo.DycContractQueryAgreeContractApprovalListReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryAgreeContractApprovalListRspBO;
import com.tydic.dyc.contract.constant.ContractConstant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycContractQueryAgreeContractApprovalListServiceImpl
implements DycContractQueryAgreeContractApprovalListService {
    private static final Logger log = LoggerFactory.getLogger(DycContractQueryAgreeContractApprovalListServiceImpl.class);
    @Autowired
    private ContractQryListAbilityService contractQryListAbilityService;

    public DycContractQueryAgreeContractApprovalListRspBO queryAgreeContractApprovalList(DycContractQueryAgreeContractApprovalListReqBO reqBO) {
        this.validate(reqBO);
        ContractQryListAbilityReqBO centerReqBO = (ContractQryListAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractQryListAbilityReqBO.class);
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            centerReqBO.setPageNo(reqBO.getPageNo());
        }
        if (reqBO.getPageSize() != null && reqBO.getPageSize() > 0) {
            centerReqBO.setPageSize(reqBO.getPageSize());
        }
        if (reqBO.getStatusList() == null || reqBO.getStatusList().equals("")) {
            log.info("\u6839\u636etabId\u67e5\u8be2\u5408\u540c\u72b6\u6001");
            centerReqBO.setContractStatusList(this.transTabIdToContractStatus(reqBO.getTabId()));
        } else {
            log.info("\u6839\u636e\u641c\u7d22\u6761\u4ef6\u67e5\u8be2\u5408\u540c\u72b6\u6001");
            ArrayList<Integer> contractStatusList = new ArrayList<Integer>();
            contractStatusList.add(Integer.valueOf(reqBO.getStatusList()));
            centerReqBO.setContractStatusList(contractStatusList);
        }
        ContractQryListAbilityRspBO centerRspBO = this.contractQryListAbilityService.qryContractList(centerReqBO);
        if ("0000".equals(centerRspBO.getRespCode())) {
            return (DycContractQueryAgreeContractApprovalListRspBO)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), DycContractQueryAgreeContractApprovalListRspBO.class);
        }
        throw new ZTBusinessException(centerRspBO.getRespDesc());
    }

    private List<Integer> transTabIdToContractStatus(Integer tabId) {
        ArrayList<Integer> contractStatusList = new ArrayList<Integer>();
        if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_NO_APPROVAL)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_APPROVED)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_ALL)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
        } else {
            throw new ZTBusinessException("\u8f93\u5165\u7684\u9875\u7b7eid\u6709\u8bef");
        }
        return contractStatusList;
    }

    private void validate(DycContractQueryAgreeContractApprovalListReqBO reqBO) {
        if (reqBO.getContractType() == null) {
            throw new ZTBusinessException("\u534f\u8bae\u5408\u540c\u5217\u8868\u67e5\u8be2-\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u5165\u9a7b\u5408\u540c\u5217\u8868\u67e5\u8be2-tabId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

