/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryListAbilityService;
import com.tydic.contract.ability.bo.ContractQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryListAbilityRspBO;
import com.tydic.dyc.contract.api.DycContractQueryOrderContractListService;
import com.tydic.dyc.contract.bo.DycContractQueryOrderContractListReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryOrderContractListRspBO;
import com.tydic.dyc.contract.constant.ContractConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycContractQueryOrderContractListServiceImpl
implements DycContractQueryOrderContractListService {
    @Autowired
    private ContractQryListAbilityService contractQryListAbilityService;

    public DycContractQueryOrderContractListRspBO queryOrderContractList(DycContractQueryOrderContractListReqBO reqBO) {
        ContractQryListAbilityRspBO centerRspBO;
        this.validate(reqBO);
        ContractQryListAbilityReqBO centerReqBO = (ContractQryListAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractQryListAbilityReqBO.class);
        centerReqBO.setContractType(ContractConstant.ContractType.ORDER_CONTRACT);
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            centerReqBO.setPageNo(reqBO.getPageNo());
        }
        if (reqBO.getPageSize() != null && reqBO.getPageSize() > 0) {
            centerReqBO.setPageSize(reqBO.getPageSize());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractStatusList())) {
            centerReqBO.setContractStatusList(this.transTabIdToContractStatus(reqBO.getTabId(), reqBO.getNeedUnsignTab()));
        }
        if (reqBO.getPurchaserId() == null) {
            centerReqBO.setPurchaserId(reqBO.getCompanyId());
        }
        if ("0000".equals((centerRspBO = this.contractQryListAbilityService.qryContractList(centerReqBO)).getRespCode())) {
            return (DycContractQueryOrderContractListRspBO)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), DycContractQueryOrderContractListRspBO.class);
        }
        throw new ZTBusinessException(centerRspBO.getRespDesc());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Integer> transTabIdToContractStatus(Integer tabId, Integer needUnsignTab) {
        ArrayList<Integer> contractStatusList = new ArrayList<Integer>();
        if (needUnsignTab == 1) {
            if (tabId.equals(ContractConstant.ContractTabId.TAB_ID_NO_EFFECT)) {
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
                return contractStatusList;
            } else if (tabId.equals(ContractConstant.ContractTabId.TAB_ID_NO_SIGN)) {
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
                return contractStatusList;
            } else if (tabId.equals(ContractConstant.ContractTabId.TAB_ID_EFFECT)) {
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
                return contractStatusList;
            } else {
                if (!tabId.equals(ContractConstant.ContractTabId.TAB_ID_FAILURE)) throw new ZTBusinessException("\u8f93\u5165\u7684\u9875\u7b7eid\u9519\u8bef");
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            }
            return contractStatusList;
        } else {
            if (needUnsignTab != 0) return contractStatusList;
            if (tabId.equals(ContractConstant.ContractTabId.TAB_ID_NO_EFFECT)) {
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
                return contractStatusList;
            } else if (tabId.equals(ContractConstant.ContractTabId.TAB_ID_NO_SIGN)) {
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
                return contractStatusList;
            } else if (tabId.equals(ContractConstant.ContractTabId.TAB_ID_EFFECT)) {
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
                return contractStatusList;
            } else {
                if (!tabId.equals(ContractConstant.ContractTabId.TAB_ID_FAILURE)) throw new ZTBusinessException("\u8f93\u5165\u7684\u9875\u7b7eid\u9519\u8bef");
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
                contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            }
        }
        return contractStatusList;
    }

    private void validate(DycContractQueryOrderContractListReqBO reqBO) {
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u5165\u9a7b\u5408\u540c\u5217\u8868\u67e5\u8be2-tabId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

