/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.util;

import java.math.BigDecimal;

public class ZoneMoneyUtils {
    public static BigDecimal yuanToFen(BigDecimal sourceFee) {
        return ZoneMoneyUtils.unitConvert(sourceFee, MoneyUnit.YUAN, MoneyUnit.FEN);
    }

    public static BigDecimal yuanToFen(Long sourceFee) {
        return ZoneMoneyUtils.yuanToFen(new BigDecimal(sourceFee));
    }

    public static BigDecimal yuanToFen(String sourceFee) {
        return ZoneMoneyUtils.yuanToFen(new BigDecimal(sourceFee));
    }

    public static long yuanToFenToLong(BigDecimal sourceFee) {
        return ZoneMoneyUtils.yuanToFen(sourceFee).longValue();
    }

    public static BigDecimal yuanToHao(BigDecimal sourceFee) {
        return ZoneMoneyUtils.unitConvert(sourceFee, MoneyUnit.YUAN, MoneyUnit.HAO);
    }

    public static BigDecimal yuanToHao(Long sourceFee) {
        return ZoneMoneyUtils.yuanToHao(new BigDecimal(sourceFee));
    }

    public static BigDecimal yuanToHao(String sourceFee) {
        return ZoneMoneyUtils.yuanToHao(new BigDecimal(sourceFee));
    }

    public static long yuanToHaoToLong(BigDecimal sourceFee) {
        return ZoneMoneyUtils.yuanToHao(sourceFee).longValue();
    }

    public static BigDecimal fenToYuan(BigDecimal sourceFee) {
        return ZoneMoneyUtils.unitConvert(sourceFee, MoneyUnit.FEN, MoneyUnit.YUAN);
    }

    public static BigDecimal fenToYuan(Long sourceFee) {
        return ZoneMoneyUtils.fenToYuan(new BigDecimal(sourceFee));
    }

    public static BigDecimal fenToYuan(String sourceFee) {
        return ZoneMoneyUtils.fenToYuan(new BigDecimal(sourceFee));
    }

    public static String fenToYuanToString(BigDecimal sourceFee) {
        return ZoneMoneyUtils.fenToYuan(sourceFee).toString();
    }

    public static BigDecimal fenToHao(BigDecimal sourceFee) {
        return ZoneMoneyUtils.unitConvert(sourceFee, MoneyUnit.FEN, MoneyUnit.HAO);
    }

    public static BigDecimal fenToHao(Long sourceFee) {
        return ZoneMoneyUtils.fenToHao(new BigDecimal(sourceFee));
    }

    public static BigDecimal fenToHao(String sourceFee) {
        return ZoneMoneyUtils.fenToHao(new BigDecimal(sourceFee));
    }

    public static Long fenToHaoToLong(BigDecimal sourceFee) {
        return ZoneMoneyUtils.fenToHao(sourceFee).longValue();
    }

    public static BigDecimal haoToYuan(BigDecimal sourceFee) {
        return ZoneMoneyUtils.unitConvert(sourceFee, MoneyUnit.HAO, MoneyUnit.YUAN);
    }

    public static BigDecimal haoToYuan(Long sourceFee) {
        return ZoneMoneyUtils.haoToYuan(new BigDecimal(sourceFee));
    }

    public static BigDecimal haoToYuan(String sourceFee) {
        return ZoneMoneyUtils.haoToYuan(new BigDecimal(sourceFee));
    }

    public static String haoToYuanToString(BigDecimal sourceFee) {
        return ZoneMoneyUtils.haoToYuan(sourceFee).toString();
    }

    public static BigDecimal haoToFen(BigDecimal sourceFee) {
        return ZoneMoneyUtils.unitConvert(sourceFee, MoneyUnit.HAO, MoneyUnit.FEN);
    }

    public static BigDecimal haoToFen(Long sourceFee) {
        return ZoneMoneyUtils.haoToFen(new BigDecimal(sourceFee));
    }

    public static BigDecimal haoToFen(String sourceFee) {
        return ZoneMoneyUtils.haoToFen(new BigDecimal(sourceFee));
    }

    public static Long haoToFenToLong(BigDecimal sourceFee) {
        return ZoneMoneyUtils.haoToFen(sourceFee).longValue();
    }

    private static BigDecimal unitConvert(BigDecimal sourceFee, MoneyUnit sourceUnit, MoneyUnit targetUnit) {
        if (sourceFee == null) {
            throw new IllegalArgumentException("\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff0c\u5165\u53c2\u6e90\u91d1\u989d\u4e0d\u80fd\u4e3a null !");
        }
        return sourceFee.multiply(new BigDecimal(sourceUnit.getTimes())).divide(new BigDecimal(targetUnit.getTimes()), 2, 1);
    }

    private static enum MoneyUnit {
        YUAN("10000"),
        JIAO("1000"),
        FEN("100"),
        LI("10"),
        HAO("1");

        private String times;

        private MoneyUnit(String times) {
            this.times = times;
        }

        public String getTimes() {
            return this.times;
        }
    }
}

