/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UocZoneFileUpLoad {
    private static final Logger log = LoggerFactory.getLogger(UocZoneFileUpLoad.class);
    private static final String PATH = "dyc-common/";
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public String upload(String fileNamePre, byte[] file, String fileType) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(file);
        String fileName = fileNamePre + fileType;
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        String fileUrl = null;
        String innerFileUrl = null;
        if ("OSS".equals(this.fileType)) {
            String httphead = "https://";
            if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png")) {
                httphead = "http://";
            }
            fileUrl = this.ossFileUrl + path;
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return fileUrl;
    }
}

