package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 协议支付配置
 * @author zhanghengrui
 * @date 2023/1/30 10:32
 */
@Data
public class AgrPayConfigBO implements Serializable {
    private static final long serialVersionUID = 461983782672686401L;

    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 账期
     */
    private Integer paymentDays;
    /**
     * 预付款
     */
    private BigDecimal prePay;
    /**
     * 预付款比例
     */
    private Integer prePayRatio;
    /**
     * 发货款
     */
    private BigDecimal matPay;
    /**
     * 发货款比例
     */
    private Integer matPayRatio;
    /**
     * 到货验收款
     */
    private BigDecimal proPay;
    /**
     * 到货验收款比例
     */
    private Integer proPayRatio;
    /**
     * 安装调试款
     */
    private BigDecimal verPay;
    /**
     * 安装调试款比例
     */
    private Integer verPayRatio;
    /**
     * 竣工验收金
     */
    private BigDecimal quaPay;
    /**
     * 竣工验收金比例
     */
    private Integer quaPayRatio;
    /**
     * 质保期满款
     */
    private BigDecimal pilPay;
    /**
     * 质保期满款比例
     */
    private Integer pilPayRatio;










}
