package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/1/31 10:59
 */
@Data
public class AgrAddChangeAgrSyncReqBO implements Serializable {
    private static final long serialVersionUID = -3501971207804480184L;

    /**
     *批次唯一Id
     */
    private Long batchUniqueId;
    /**
     *总批次数
     */
    private Integer totalBatchCount;
    /**
     *当前批次数
     */
    private Integer nowBatchCount;
    /**
     *协议ID
     */
    private Long agrId;
    /**
     * 同步类型
     *
     * 1.仅价格明细信息
     *
     * 2.仅主体信息
     *
     * 3.明细+主体信息
     */
    private Integer syncType;
    /**
     *协议主体信息
     */
    private AgrMainBO agrAgrMainBO;
    /**
     *协议支付配置信息
     */
    private AgrPayConfigBO agrPayConfigBO;
    /**
     *协议应用范围信息
     */
    private AgrAppScopeBO agrAppScopeBO;
    /**
     *协议价格明细信息
     */
    private List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOs;

}
