package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@Data
public class AgrMateriaPriceItemBO implements Serializable {
    private static final long serialVersionUID = 4589348263191187564L;

    /**
     * 协议主体历史Id
     */
    private Long agrMainHisId;
    /**
     * 协议物料价格明细历史Id
     */
    private Long agrMateriaPriceItemHisId;
    /**
     * 协议物料价格明细Id
     */
    private Long agrMateriaPriceItemId;
    /**
     * 协议id
     */
    private Long agrId;
    /**
     * 物料分类编码
     */
    private String catalogCode;
    /**
     * 物料分类名称
     */
    private String catalogName;
    /**
     * 物料编码
     */
    private String materialCode;
    /**
     * 物料名称
     */
    private String materialName;
    /**
     * 物料短描述
     */
    private String materialShortDesc;
    /**
     * 计量单位编码
     */
    private String measureCode;
    /**
     * 计量单位名称
     */
    private String measureName;
    /**
     * 计量单位小数位数
     */
    private String unitDigit;
    /**
     * 基础分类:生产，非生产，科研
     */
    private String basiClassify;
    /**
     * 物料规格型号信息
     */
    private String model;
    /**
     * 最小起订量
     */
    private BigDecimal moq;
    /**
     * 价格类型
     */
    private Integer priceType;
    /**
     * 省份名称
     */
    private String provinceName;
    /**
     * 省份编码
     */
    private String provinceCode;
    /**
     * 地市名称
     */
    private String cityName;
    /**
     * 地市编码
     */
    private String cityCode;
    /**
     * 专属价机构名称
     */
    private String exclusiveOrgName;
    /**
     * 专属价机构id
     */
    private Long exclusiveOrgId;
    /**
     * 专属价主数据机构id
     */
    private String exclusiveMainOrgId;
    /**
     * 阶梯开始数量
     */
    private BigDecimal startNum;
    /**
     * 阶梯开始数量
     */
    private BigDecimal stopNum;
    /**
     * 价格使用类型：1.销售价2.采购价
     */
    private String priceUseType;
    /**
     * 税率
     */
    private BigDecimal taxRate;
    /**
     * 采购单价,(含税)
     */
    private BigDecimal price;
    /**
     * 采购单价,(未含税)
     */
    private BigDecimal unTaxPrice;
    /**
     * 货期
     */
    private String supplyCycle;
    /**
     * 分组标识
     */
    private String groupByFlag;
    /**
     * 排序标识
     */
    private String orderByFlag;
    /**
     * 销售单价,(含税)
     */
    private BigDecimal salePrice;
    /**
     * 销售单价,(未含税)
     */
    private BigDecimal saleUnTaxPrice;
    /**
     * 是否是慧采自营
     */
    private Integer isAutarky;


    /**
     * 销售价协议物料价格明细Id
     */
    private Long agrSaleMateriaPriceItemId;

    /**
     *变更类型
     */
    private Integer changeType;

    /**
     *备注
     */
    private String remark;

    private String keyCode;

}
