package com.tydic.dyc.util;

import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import org.springframework.util.StringUtils;


/**
 * @author yinletian
 * @date 2023/2/7
 */
public class CommonUtil {
    /**
     * 生成唯一key
     * 价格类型_物料编码_专属id_省份_城市_开始数量_阶梯数量
     * 2_am003_X_hebei_baoding_X_X
     * @param bo
     * @return
     */
    public static String getKeyCode(AgrMateriaPriceItemBO bo){
        StringBuilder sb = new StringBuilder();
        sb.append(bo.getPriceType()).append("_")
                .append(bo.getMaterialCode()).append("_")
                .append(StringUtils.isEmpty(bo.getExclusiveOrgId()) ?"X":bo.getExclusiveOrgId()).append("_")
                .append(StringUtils.isEmpty(bo.getProvinceCode()) ?"X":bo.getExclusiveOrgId()).append("_")
                .append(StringUtils.isEmpty(bo.getCityCode())?"X":bo.getExclusiveOrgId()).append("_")
                .append(StringUtils.isEmpty(bo.getStartNum())?"X":bo.getExclusiveOrgId()).append("_")
                .append(StringUtils.isEmpty(bo.getStopNum())?"X":bo.getExclusiveOrgId());
        return sb.toString();
    }
}
