/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToBigDecimalSerializer
implements ObjectSerializer {
    private static final Logger log = LoggerFactory.getLogger(ToBigDecimalSerializer.class);
    public static final ToBigDecimalSerializer instance = new ToBigDecimalSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        log.info("ToBigDecimalSerializer->start-{}", object);
        BigDecimal bigDecimal = new BigDecimal(object.toString()).setScale(3, RoundingMode.HALF_UP);
        log.info("ToBigDecimalSerializer->end-{}", (Object)bigDecimal);
        log.info("ToBigDecimalSerializer->end-{}", (Object)bigDecimal.toPlainString());
        out.writeString(bigDecimal.toPlainString());
    }
}

