package com.tydic.dyc.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author yinletian
 * @date 2023/4/4
 */
@Slf4j
public class ToBigIntegerSerializer implements ObjectSerializer {
    public static final ToBigDecimalSerializer instance = new ToBigDecimalSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;

        if (object == null) {
            out.writeNull();
            return;
        }
        BigDecimal bigDecimal = new BigDecimal(object.toString()).setScale(0);
        out.writeString(bigDecimal.toPlainString());
    }
}
