package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrQryAgrMateriaPriceItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrMateriaPriceItemListServiceReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrMateriaPriceItemListServiceRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@HTServiceImpl
public class AgrQryAgrMateriaPriceItemListServiceImpl implements AgrQryAgrMateriaPriceItemListService {

    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;
    @Autowired
    private AgrModel agrModel;

    @Override
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryAgrMateriaPriceItemList(AgrQryAgrMateriaPriceItemListServiceReqBO reqBO) {
        //查询协议是否为自营
        BkAgrMainDo agrMainDo = new BkAgrMainDo();
        agrMainDo.setAgrId(reqBO.getAgrId());
        BkAgrMainDo agrMainBO = agrModel.qryMain(agrMainDo);

        AgrQryAgrMateriaPriceItemListServiceRspBO rspBO = new AgrQryAgrMateriaPriceItemListServiceRspBO();
        if(StringUtils.isEmpty(reqBO.getAgrMainHisId())){
            rspBO = agrMateriaPriceModel.qryMateriaPriceItem(reqBO);
        }else{
            rspBO = agrMateriaPriceModel.qryMateriaPriceItemHis(reqBO);
        }
        //自营补全销售价
        if(AgrConstant.IsAutarky.YES == agrMainBO.getIsAutarky()){
            rspBO.setRows(converParam(rspBO,reqBO));
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private  List<AgrMateriaPriceItemBO> converParam(AgrQryAgrMateriaPriceItemListServiceRspBO rspBO, AgrQryAgrMateriaPriceItemListServiceReqBO reqBO){

        List<AgrMateriaPriceItemBO> rows = rspBO.getRows();

        if(CollectionUtils.isEmpty(rows)){

            List<AgrMateriaPriceItemBO> collect = rows.stream().filter(obj -> obj.getPriceType() != 4).collect(Collectors.toList());
            List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS = new ArrayList<>();
            if(StringUtils.isEmpty(reqBO.getAgrMainHisId())) {
                agrMateriaPriceItemBOS = agrMateriaPriceModel.qrySelfSalePrice(collect);
            }else {
                agrMateriaPriceItemBOS = agrMateriaPriceModel.qrySelfSalePriceHis(collect);
            }

            Map<String,AgrMateriaPriceItemBO> maps = new HashMap<>();
            //统一价
            if(AgrConstant.PriceType.UNIFIED == reqBO.getPriceType()){
                agrMateriaPriceItemBOS.forEach(obj->{ maps.put(obj.getMaterialCode(),obj);});
            }
            //区域价
            if(AgrConstant.PriceType.REGION == reqBO.getPriceType()){
                agrMateriaPriceItemBOS.forEach(obj->{ maps.put(obj.getMaterialCode()+"_"+obj.getProvinceCode()+"_"+obj.getCityCode(),obj);});
            }
            //专属价
            if(AgrConstant.PriceType.EXCLUSIVE == reqBO.getPriceType()){
                agrMateriaPriceItemBOS.forEach(obj->{ maps.put(obj.getMaterialCode()+"_"+obj.getExclusiveMainOrgId()+"_",obj);});
            }

            rows.forEach(obj->{
                String str = null;
                if(AgrConstant.PriceType.UNIFIED == reqBO.getPriceType()){
                    str = obj.getMaterialCode();
                }
                if(AgrConstant.PriceType.REGION == reqBO.getPriceType()){
                    str = obj.getMaterialCode()+"_"+obj.getProvinceCode()+"_"+obj.getCityCode();
                }
                if(AgrConstant.PriceType.EXCLUSIVE == reqBO.getPriceType()){
                    str =obj.getMaterialCode()+"_"+obj.getExclusiveMainOrgId();
                }
                AgrMateriaPriceItemBO itemBO = maps.get(str);

                obj.setSalePrice(itemBO.getSalePrice());
                obj.setSaleUnTaxPrice(itemBO.getUnTaxPrice());
                obj.setAgrSaleMateriaPriceItemId(itemBO.getAgrSaleMateriaPriceItemId());
            });
        }
        return rows;
    }
}
