/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.service.agr.AgrAddNewAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddNewAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddNewAgrSyncRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainBO;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigBO;
import com.tydic.dyc.agr.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrAddNewAgrSyncService"})
public class AgrAddNewAgrSyncServiceImpl
implements AgrAddNewAgrSyncService {
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;

    @PostMapping(value={"addNewAgrSync"})
    public AgrAddNewAgrSyncRspBO addNewAgrSync(@RequestBody AgrAddNewAgrSyncReqBO agrAddNewAgrSyncReqBO) {
        AgrAddNewAgrSyncRspBO rspBO = new AgrAddNewAgrSyncRspBO();
        Integer syncNum = this.agrLogModel.checkSyncStatus(agrAddNewAgrSyncReqBO.getAgrId(), agrAddNewAgrSyncReqBO.getBatchUniqueId());
        if (syncNum.equals(agrAddNewAgrSyncReqBO.getTotalBatchCount())) {
            throw new ZTBusinessException("\u540c\u6b65\u5b8c\u6210");
        }
        Long agrId = IdUtil.nextId();
        rspBO.setAgrId(agrId);
        BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
        bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
        bkAgrBigDataLogDo.setBatchUniqueId(agrAddNewAgrSyncReqBO.getBatchUniqueId());
        bkAgrBigDataLogDo.setTotalBatchCount(agrAddNewAgrSyncReqBO.getTotalBatchCount());
        bkAgrBigDataLogDo.setNowBatchCount(agrAddNewAgrSyncReqBO.getNowBatchCount());
        bkAgrBigDataLogDo.setAgrId(agrId + "");
        bkAgrBigDataLogDo.setAgrCode(agrAddNewAgrSyncReqBO.getAgrAgrMainBO().getAgrCode());
        bkAgrBigDataLogDo.setContractCode(bkAgrBigDataLogDo.getContractCode());
        bkAgrBigDataLogDo.setDealStatus("2");
        bkAgrBigDataLogDo.setBatchOperType(1);
        bkAgrBigDataLogDo.setIsCopyMain(agrAddNewAgrSyncReqBO.getSyncType() == 1 ? 1 : 0);
        bkAgrBigDataLogDo.setCreateName(new Date().toString());
        this.agrLogModel.addLog(bkAgrBigDataLogDo);
        this.addData(agrAddNewAgrSyncReqBO, agrId);
        if (syncNum + 1 == agrAddNewAgrSyncReqBO.getTotalBatchCount()) {
            rspBO.setSyncFinishFlag(Integer.valueOf(1));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addData(AgrAddNewAgrSyncReqBO syncReqBO, Long agrId) {
        if (syncReqBO.getSyncType() == 2) {
            AgrMainBO agrAgrMainBO = syncReqBO.getAgrAgrMainBO();
            agrAgrMainBO.setAgrId(agrAgrMainBO.getAgrId());
            this.agrModel.insertAgrMain(agrAgrMainBO);
            AgrAppScopeBO agrAppScopeBO = syncReqBO.getAgrAppScopeBO();
            agrAppScopeBO.setAgrId(agrId);
            agrAppScopeBO.setAppScopeId(Long.valueOf(IdUtil.nextId()));
            this.agrModel.insertAgrAppScope(syncReqBO.getAgrAppScopeBO());
            AgrPayConfigBO agrPayConfigBO = syncReqBO.getAgrPayConfigBO();
            agrPayConfigBO.setAgrId(agrId);
            agrPayConfigBO.setPayCfgId(Long.valueOf(IdUtil.nextId()));
            this.agrModel.insertAgrPayConfig(syncReqBO.getAgrPayConfigBO());
        }
        List bos = syncReqBO.getAgrMateriaPriceItemBOs();
        bos.forEach(obj -> {
            obj.setAgrId(agrId);
            obj.setAgrMateriaPriceItemId(Long.valueOf(IdUtil.nextId()));
        });
        this.agrModel.insertMateriaPriceItemList(bos);
    }
}

