package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.version.AgrVersionModel;
import com.tydic.dyc.agr.service.agr.AgrQryAgrVersionListService;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrVersionListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrVersionListRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author yinletian
 * @date 2023/1/29
 */
@HTServiceImpl
public class AgrQryAgrVersionListServiceImpl implements AgrQryAgrVersionListService {
    @Autowired
    private AgrVersionModel agrVersionModel;
    @Override
    public AgrQryAgrVersionListRspBO qryAgrVersionList(AgrQryAgrVersionListReqBO reqBO) {

        AgrQryAgrVersionListRspBO rspBO = agrVersionModel.qryAgrVersionList(reqBO);

        //翻译状态
        rspBO.getRows().forEach(obj->{
            //1:价格管理、2:合同系统
           obj.setAgrSourceStr(obj.getAgrSource() == 1? "价格管理":"合同系统");
           obj.setAgrVersionStatusStr("EXPIRED".equals(obj.getAgrVersionStatus()) ?
                   "已失效": ("EFFECTIVE".equals(obj.getAgrVersionStatus()) ? "已生效":"待生效"));
        });

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
