package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.model.common.IUocCommonModel;
import com.tydic.dyc.agr.service.agr.AgrUpdateTodoInfoByIdService;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateTodoInfoByIdReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateTodoInfoByIdRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class AgrUpdateTodoInfoByIdServiceImpl implements AgrUpdateTodoInfoByIdService {
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public AgrUpdateTodoInfoByIdRspBo updateTodoInfoById(AgrUpdateTodoInfoByIdReqBo uocUpdateTodoInfoByIdReqBo) {
        validateArgs(uocUpdateTodoInfoByIdReqBo);
        UocTodo uocTodo = new UocTodo();
        BeanUtils.copyProperties(uocUpdateTodoInfoByIdReqBo,uocTodo);
        uocCommonModel.updateTodoById(uocTodo);
        AgrUpdateTodoInfoByIdRspBo rspBO = new AgrUpdateTodoInfoByIdRspBo();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
    private void validateArgs(AgrUpdateTodoInfoByIdReqBo uocUpdateTodoInfoByIdReqBo){
        if (null == uocUpdateTodoInfoByIdReqBo) {
            throw new ZTBusinessException("入参对象不能为空");
        }
        if (null == uocUpdateTodoInfoByIdReqBo.getTodoId()) {
            throw new ZTBusinessException("入参待办ID不能为空");
        }
    }
}
