package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.service.agr.AgrSaveOrSbumitAgrService;
import com.tydic.dyc.agr.service.agr.bo.AgrSaveOrSbumitAgrReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrSaveOrSbumitAgrRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * 协议保存/提交领域服务
 * @author zhanghengrui
 * @date 2023/1/30 10:20
 */
@HTServiceImpl
public class AgrSaveOrSbumitAgrServiceImpl implements AgrSaveOrSbumitAgrService {

    @Autowired
    private AgrModel agrModel;

    @Override
    public AgrSaveOrSbumitAgrRspBO operAgr(AgrSaveOrSbumitAgrReqBO agrSaveOrSbumitAgrReqBO) {

        // 协议同步
        AgrSaveOrSbumitAgrRspBO rspBO = agrModel.operAgr(agrSaveOrSbumitAgrReqBO);
        rspBO.setPickerConfigNo(agrSaveOrSbumitAgrReqBO.getOperType().toString());

        BkAgrMainDo bkAgrMainDo = new BkAgrMainDo();
        bkAgrMainDo.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
        BkAgrMainDo mainDo = agrModel.qryMain(bkAgrMainDo);
        if(!StringUtils.isEmpty(mainDo.getUpdateLoginId())) rspBO.setFlag(true);

        return rspBO;
    }
}
