package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.model.change.BkAgrMateriaPriceItemDo;
import com.tydic.dyc.agr.model.his.AgrHisModel;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrChangeBigDataLogDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrChangeCronJobService;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 定时任务
 * @author zhanghengrui
 * @date 2023/1/31 15:14
 */
@HTServiceImpl
@Slf4j
public class AgrChangeCronJobServiceImpl implements AgrChangeCronJobService {

    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;
    @Autowired
    private AgrHisModel agrHisModel;
    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;
    @Autowired
    private AgrModel agrModel;


    @Override
    public AgrChangeCronJobRspBO changeConJob(AgrChangeCronJobReqBO agrChangeCronJobReqBO) {

        AgrChangeCronJobRspBO agrChangeCronJobRspBO = new AgrChangeCronJobRspBO();

        // 1.查询变更批量数据处理日志表，得到需要处理的数据
        BkAgrChangeBigDataLogDo qryLogDo = new BkAgrChangeBigDataLogDo();
        qryLogDo.setDealStatus("1");
        qryLogDo.setAgrId(agrChangeCronJobReqBO.getAgrId());
        qryLogDo.setAgrChangeBigDataLogId(agrChangeCronJobReqBO.getAgrChangeLogId());
        log.info("定时任务查询变更日志入参："+JSON.toJSONString(qryLogDo));
        List<BkAgrChangeBigDataLogDo> bkAgrChangeBigDataLogDo = agrLogModel.qryChangeLogData(qryLogDo);

        // 2.根据变更日志表中记录转移数据:取其中一条
        BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo1 = bkAgrChangeBigDataLogDo.get(0);

        // 2.0 先把状态置为处理中，防止重复消费
        BkAgrChangeBigDataLogDo updateLogDo_1 = new BkAgrChangeBigDataLogDo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo1,updateLogDo_1);
        updateLogDo_1.setDealStatus("2");
        agrLogModel.updateDealStatus(updateLogDo_1);

        // 查询协议主体
        BkAgrMainDo qryMain = new BkAgrMainDo();
        qryMain.setAgrId(bkAgrChangeBigDataLogDo1.getAgrId());
        BkAgrMainDo bkAgrMainDo = agrModel.qryMain(qryMain);

        // 如果是价格库采购价变更
        if (bkAgrChangeBigDataLogDo1.getBatchOperType()==3) {
            // 2.1 根据协议id转移协议数据到历史表
            agrHisModel.transDataFromMain2His(bkAgrChangeBigDataLogDo1.getAgrId(),new ArrayList<>());

            // 2.2 根据批次得到变更临时表中的数据转移到主表
            agrChangeModel.transDataFromChangeTemp2Main(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId(),new ArrayList<>(),IdUtil.nextId(),null);
        }
        // 如果是价格库销售价变更
        else if (bkAgrChangeBigDataLogDo1.getBatchOperType()==4){
            agrChangeModel.addDataFromChangeTemp2Material(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId());
        }
        // 如果是合同新增
        else if (bkAgrChangeBigDataLogDo1.getBatchOperType()==1){

            List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS = agrMateriaPriceModel.qryMateriaPriceItem(bkAgrChangeBigDataLogDo1.getAgrId());

            agrChangeCronJobRspBO.setAgrUccAutoAgrPriceBO(makeData2Ucc(agrMateriaPriceItemBOS,bkAgrMainDo));
        }
        // 如果是合同变更
        else {
            // 2.0 查出变更了的明细：因为会存在同统一agrId多次变更，必须带上批次号
            List<BkAgrBigChangeItemDataWhileDo> bkWhileDos = agrChangeModel.qryChangeMaterial(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId());

            // 2.1 根据协议id转移协议数据到历史表
            agrHisModel.transDataFromMain2His(bkAgrChangeBigDataLogDo1.getAgrId(),bkWhileDos);

            // 2.2 根据批次得到变更临时表中的数据转移到主表
            Long newAgrId = IdUtil.nextId();
            List<BkAgrMateriaPriceItemDo> bkAgrChangeBigDataLogDos = agrChangeModel.transDataFromChangeTemp2Main(bkAgrChangeBigDataLogDo1.getAgrId(),
                    bkAgrChangeBigDataLogDo1.getBatchUniqueId(), bkWhileDos,newAgrId,agrChangeCronJobRspBO);

            // 2.3
            AgrUccAutoAgrPriceBO agrUccAutoAgrPriceBO = makeChangeData2Ucc(bkWhileDos, bkAgrMainDo, bkAgrChangeBigDataLogDos);

            agrChangeCronJobRspBO.setPickerConfigNo("3");

            agrChangeCronJobRspBO.setType(2);
            agrChangeCronJobRspBO.setAgrStatus(bkAgrMainDo.getAgrStatus());
            agrChangeCronJobRspBO.setAgrUccAutoAgrPriceBO(agrUccAutoAgrPriceBO);
            agrChangeCronJobRspBO.setAgrId(newAgrId);
        }


        // 2.3 处理状态置为失败或者成功
        BkAgrChangeBigDataLogDo updateLogDo_2 = new BkAgrChangeBigDataLogDo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo1,updateLogDo_2);
        updateLogDo_2.setDealStatus("3");
        agrLogModel.updateDealStatus(updateLogDo_2);

        // 同步es

        if(bkAgrChangeBigDataLogDo1.getBatchOperType()!=1) agrChangeCronJobRspBO.setAgrCode(bkAgrChangeBigDataLogDo1.getAgrCode());

        log.info("出参："+JSON.toJSONString(agrChangeCronJobRspBO));

        return agrChangeCronJobRspBO;
    }

    private AgrUccAutoAgrPriceBO makeData2Ucc(List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS,BkAgrMainDo bkAgrMainDo){

        AgrUccAutoAgrPriceBO agrUccAutoAgrPriceBO = new AgrUccAutoAgrPriceBO();

        BeanUtils.copyProperties(bkAgrMainDo,agrUccAutoAgrPriceBO);
        // 是否慧财自营
        agrUccAutoAgrPriceBO.setAgrType(bkAgrMainDo.getIsAutarky());
        agrUccAutoAgrPriceBO.setVendorId(bkAgrMainDo.getAgrSupOrgId());
        agrUccAutoAgrPriceBO.setVendorName(bkAgrMainDo.getAgrSupOrgName());
        agrUccAutoAgrPriceBO.setOperatorName(bkAgrMainDo.getGroupOperator());
        agrUccAutoAgrPriceBO.setEffTime(bkAgrMainDo.getEffDate());
        agrUccAutoAgrPriceBO.setExpTime(bkAgrMainDo.getExpDate());

        // 新增
        agrUccAutoAgrPriceBO.setOperType(1);
        agrUccAutoAgrPriceBO.setBatchUniqueId(IdUtil.nextId());

        List<BkAgrPriceBo> list = new ArrayList<>();

        for (AgrMateriaPriceItemBO agrMateriaPriceItemBO : agrMateriaPriceItemBOS) {
            BkAgrPriceBo bkAgrPriceBo = new BkAgrPriceBo();
            BeanUtils.copyProperties(agrMateriaPriceItemBO,bkAgrPriceBo);
            bkAgrPriceBo.setOperItemType(1);
            bkAgrPriceBo.setProvince(agrMateriaPriceItemBO.getProvinceCode().equals("")?null:Integer.valueOf(agrMateriaPriceItemBO.getProvinceCode()));
            bkAgrPriceBo.setCity(agrMateriaPriceItemBO.getCityCode().equals("")?null:Integer.valueOf(agrMateriaPriceItemBO.getCityCode()));
            bkAgrPriceBo.setOrgId(agrMateriaPriceItemBO.getExclusiveOrgId());
            bkAgrPriceBo.setOrgName(agrMateriaPriceItemBO.getExclusiveOrgName());
            bkAgrPriceBo.setStart(agrMateriaPriceItemBO.getStartNum());
            bkAgrPriceBo.setEnd(agrMateriaPriceItemBO.getStopNum());
            bkAgrPriceBo.setPrice(agrMateriaPriceItemBO.getPrice());
            bkAgrPriceBo.setRate(agrMateriaPriceItemBO.getTaxRate());

            list.add(bkAgrPriceBo);
        }

        agrUccAutoAgrPriceBO.setAgrPriceList(list);

        return agrUccAutoAgrPriceBO;
    }

    private AgrUccAutoAgrPriceBO makeChangeData2Ucc(List<BkAgrBigChangeItemDataWhileDo> bkWhileDos,BkAgrMainDo bkAgrMainDo,List<BkAgrMateriaPriceItemDo> bkAgrChangeBigDataLogDos){

        AgrUccAutoAgrPriceBO agrUccAutoAgrPriceBO = new AgrUccAutoAgrPriceBO();

        BeanUtils.copyProperties(bkAgrMainDo,agrUccAutoAgrPriceBO);
        // 新增
        agrUccAutoAgrPriceBO.setOperType(2);
        agrUccAutoAgrPriceBO.setBatchUniqueId(bkWhileDos.get(0).getBatchUniqueId());

        List<BkAgrPriceBo> list = new ArrayList<>();

        // 新增，不变，修改
        for (BkAgrBigChangeItemDataWhileDo agrMateriaPriceItemBO : bkWhileDos) {
            BkAgrPriceBo bkAgrPriceBo = new BkAgrPriceBo();
            BeanUtils.copyProperties(agrMateriaPriceItemBO,bkAgrPriceBo);
            bkAgrPriceBo.setOperItemType(agrMateriaPriceItemBO.getChangeType());
            bkAgrPriceBo.setProvince(agrMateriaPriceItemBO.getProvinceCode()==null||agrMateriaPriceItemBO.getProvinceCode().equals("")?0:Integer.parseInt(agrMateriaPriceItemBO.getProvinceCode()));
            bkAgrPriceBo.setCity(agrMateriaPriceItemBO.getCityCode()==null||agrMateriaPriceItemBO.getCityCode().equals("")?0:Integer.parseInt(agrMateriaPriceItemBO.getProvinceCode()));
            bkAgrPriceBo.setOrgId(agrMateriaPriceItemBO.getExclusiveOrgId());
            bkAgrPriceBo.setOrgName(agrMateriaPriceItemBO.getExclusiveOrgName());
            bkAgrPriceBo.setStart(agrMateriaPriceItemBO.getStartNum());
            bkAgrPriceBo.setEnd(agrMateriaPriceItemBO.getStopNum());
            bkAgrPriceBo.setPrice(agrMateriaPriceItemBO.getPrice());
            bkAgrPriceBo.setRate(agrMateriaPriceItemBO.getTaxRate());

            list.add(bkAgrPriceBo);
        }

        // 删除的
        for (BkAgrMateriaPriceItemDo bkAgrChangeBigDataLogDo : bkAgrChangeBigDataLogDos) {
            BkAgrPriceBo bkAgrPriceBo = new BkAgrPriceBo();
            BeanUtils.copyProperties(bkAgrChangeBigDataLogDo,bkAgrPriceBo);
            bkAgrPriceBo.setOperItemType(bkAgrChangeBigDataLogDo.getChangeType());
            bkAgrPriceBo.setProvince(bkAgrChangeBigDataLogDo.getProvinceCode()==null||bkAgrChangeBigDataLogDo.getProvinceCode().equals("")?0:Integer.parseInt(bkAgrChangeBigDataLogDo.getProvinceCode()));
            bkAgrPriceBo.setCity(bkAgrChangeBigDataLogDo.getCityCode()==null||bkAgrChangeBigDataLogDo.getCityCode().equals("")?0:Integer.parseInt(bkAgrChangeBigDataLogDo.getProvinceCode()));
            bkAgrPriceBo.setOrgId(bkAgrChangeBigDataLogDo.getExclusiveOrgId());
            bkAgrPriceBo.setOrgName(bkAgrChangeBigDataLogDo.getExclusiveOrgName());
            bkAgrPriceBo.setStart(bkAgrChangeBigDataLogDo.getStartNum());
            bkAgrPriceBo.setEnd(bkAgrChangeBigDataLogDo.getStopNum());
            bkAgrPriceBo.setPrice(bkAgrChangeBigDataLogDo.getPrice());
            bkAgrPriceBo.setRate(bkAgrChangeBigDataLogDo.getTaxRate());

            list.add(bkAgrPriceBo);
        }

        agrUccAutoAgrPriceBO.setAgrPriceList(list);

        log.info("转换给商品数据："+ JSON.toJSONString(agrUccAutoAgrPriceBO));

        return agrUccAutoAgrPriceBO;
    }
}
