package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.model.common.IUocCommonModel;
import com.tydic.dyc.agr.service.agr.AgrUpdateTodoInfoByIdService;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateTodoInfoByIdReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateTodoInfoByIdRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class AgrUpdateTodoInfoByIdServiceImpl implements AgrUpdateTodoInfoByIdService {
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public AgrUpdateTodoInfoByIdRspBo updateTodoInfoById(AgrUpdateTodoInfoByIdReqBo reqBo) {
        validateArgs(reqBo);
        UocTodo uocTodo = new UocTodo();
        //更新当前人已办
        uocTodo.setOrderId(reqBo.getOrderId());
        uocTodo.setBusiId(reqBo.getOrderId()+"");
        uocTodo.setCandidateOperId(Long.parseLong(reqBo.getCandidateOperId()));
        uocTodo.setTodoState(1);
        uocCommonModel.updateTodoById(uocTodo);
        //更新当前人他人已办
        uocTodo.setTodoState(2);
        uocTodo.setCandidateOperId(null);
        uocCommonModel.updateTodoById(uocTodo);
        AgrUpdateTodoInfoByIdRspBo rspBO = new AgrUpdateTodoInfoByIdRspBo();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
    private void validateArgs(AgrUpdateTodoInfoByIdReqBo uocUpdateTodoInfoByIdReqBo){
        if (null == uocUpdateTodoInfoByIdReqBo) {
            throw new ZTBusinessException("入参对象不能为空");
        }
    }
}
